/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "vdk/application.h"
#include "vdk/forms.h"
#include "vdk/messagebox.h"
#include "vdk/vdkfeatures.h"
#include <assert.h>
#include <unistd.h>
#include <config.h>

#ifdef VDKDEBUG
extern int objectC,objectD,formC,formD,childRemoved,objRemoved;

#endif
//static char buff[128];
/*
at idle callback:
execute garbage collection
*/
int VDKApplication::GcCallback(gpointer app)
{
g_return_val_if_fail(app != NULL , FALSE);
VDKApplication* theApp = reinterpret_cast<VDKApplication*>((VDKApplication*) app);
g_return_val_if_fail(theApp != NULL,FALSE);
if (theApp->MainForm)
  theApp->MainForm->CollectGarbage();
return TRUE;
}

/*
  constructor
  executing:
  <app> -rc <rc file>
  will result in rc file loading
  and parsing
  */
VDKApplication::VDKApplication(int* argc, char** argv, char* rcf,
			       bool have_locale)
{
int depth;
// load rc file
if(rcf)
  rcfile = rcf;
if( ! rcfile.isNull()  && ! access((char*) rcfile,F_OK) )
  gtk_rc_add_default_file ((char*) rcfile);
if(have_locale)
  gtk_set_locale();
gtk_init (argc, &argv);
depth = gdk_visual_get_best_depth();
#ifdef VDKDEBUG
printf("\nbpp:%d",depth);
fflush(stdout);
#endif
gdk_rgb_init ();
MainForm = NULL;
idleTag = gcTag = 0;
}
/*
  destructor:
  delete main form that in turn
  deletes all childs and
  all objects
  */
VDKApplication::~VDKApplication()
{
if(MainForm) delete MainForm;
#ifdef VDKDEBUG
printf("\nobjects constructed:%d\nobjects destroyed:%d",objectC,objectD);
printf("\nforms constructed:%d\nforms destroyed:%d",formC,formD);
printf("\nchilds removed:%d\nobjs removed:%d\n\n",
       childRemoved,
       objRemoved);
fflush(stdout);
#endif
}
/*
runs app:
calls:
Setup() thet should be overridden by user
initiates event loop
*/
void
VDKApplication::Run(void)
{
  Setup();
  g_return_if_fail(MainForm != NULL);
  gtk_main();
}
/*
call it before Run()
 */
void
VDKApplication::SetResourceFile(char* rcf)
{
gtk_rc_parse (rcf);
}
/*
set idle call back
*/
void VDKApplication::SetIdleCallback(GtkFunction idlecb, gpointer data)
{
if( (idlecb == NULL) ||
    (data == NULL) )
  {
    if(idleTag)
      gtk_idle_remove(idleTag);
    return;
  }
else if(idleTag)
  gtk_idle_remove(idleTag);
 idleTag = gtk_idle_add(idlecb , data);
}
/*
set garbage collection
*/
void VDKApplication::SetGarbageCollection(unsigned int tick)
{
 gcTag = gtk_timeout_add(tick,(GtkFunction) VDKApplication::GcCallback,
		reinterpret_cast<gpointer>(this));
}
/*
 */
void VDKApplication::RemoveGarbageCollection()
{
if(gcTag)
  gtk_timeout_remove(gcTag);
}
/*
quit application
*/
void
VDKApplication::Terminate(void)
{
MainForm->CloseChilds();
gtk_main_quit ();
}

/*
 */
GtkWidget*
VDKApplication::MainWindow()
{
  return MainForm->Window();
}

/*
 */
gint
VDKApplication::MessageBox(char* caption,
 			   char* text,
	 		   int mode,
 			   char *oktext,
	 		   char *canceltext,
			   unsigned int wait)
{
  int answer;
  if(MainForm)
    {
      MessageBoxWindow* dialog =
	new MessageBoxWindow(MainForm,
			     caption,
			     text,
			     mode,
			     oktext,
			     canceltext,
			     &answer,
			     wait);
      dialog->Setup();
      dialog->ShowModal(GTK_WIN_POS_CENTER);
    }
  return answer;
}
