/*
 * VFEtable.c
 *
 *  Programmmed by Werner Lemberg
 *  E-Mail:  a7621gac@awiuni11.bitnet
 *
 *  Edition History
 *  19 Feb 1996  First version.
 *
 */

/* This file is part of VFlib
 *
 * Copyright (C) 1995-1998 Hirotsugu KAKUGAWA.   All rights reserved.
 *
 * This file is part of the VFlib Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <stdio.h>  /* definition of NULL */
#include "VFenc.h"


/* All entries must be in uppercase! */

EncodingTable  EncTable[] = {
  /* use these strings on the command line of bdfindex to force an encoding
     class in cases where bdfindex fails. */
  {"BIG5",          ENC_BIG5},
  {"EUC",           ENC_EUC},
  {"SJIS",          ENC_SJIS},
  {"UNICODE",       ENC_UNIC},
  {NULL,             -1},
};


CharSetTable ChSetTable[] = {
  /* most of these entries are directly taken from the BDF files delivered
     with X11R6. */
  {"BIG5.HKU",          CS_BIG5_HKU,            ENC_BIG5},
  {"BIG5.ETEN",         CS_BIG5_ETEN,           ENC_BIG5},
  {"CNS11643.1992",     CS_CNS11643_1992,       ENC_EUC},
  {"CNS11643.1992.1",   CS_CNS11643_1992_1,     ENC_EUC},
  {"CNS11643.1992.2",   CS_CNS11643_1992_2,     ENC_EUC},
  {"CNS11643.1992.3",   CS_CNS11643_1992_3,     ENC_EUC},
  {"CNS11643.1992.4",   CS_CNS11643_1992_4,     ENC_EUC},
  {"CNS11643.1992.5",   CS_CNS11643_1992_5,     ENC_EUC},
  {"CNS11643.1992.6",   CS_CNS11643_1992_6,     ENC_EUC},
  {"CNS11643.1992.7",   CS_CNS11643_1992_7,     ENC_EUC},
  {"GB2312.1980",       CS_GB2312_1980,         ENC_EUC},
  {"GB12345.1990",      CS_GB12345_1990,        ENC_EUC},
  {"JISX0208.1983",     CS_JISX0208_1983,       ENC_EUC},
  {"JISX0212.1990",     CS_JISX0212_1990,       ENC_EUC},
  {"KSC5601.1987",      CS_KSC5601_1987,        ENC_EUC},

  /* HBF header files use a hyphen instead of a dot. */
  {"BIG5-HKU",          CS_BIG5_HKU,            ENC_BIG5},
  {"BIG5-ETEN",         CS_BIG5_ETEN,           ENC_BIG5},
  {"CNS11643-1992",     CS_CNS11643_1992,       ENC_EUC},
  {"CNS11643-1992-1",   CS_CNS11643_1992_1,     ENC_EUC},
  {"CNS11643-1992-2",   CS_CNS11643_1992_2,     ENC_EUC},
  {"CNS11643-1992-3",   CS_CNS11643_1992_3,     ENC_EUC},
  {"CNS11643-1992-4",   CS_CNS11643_1992_4,     ENC_EUC},
  {"CNS11643-1992-5",   CS_CNS11643_1992_5,     ENC_EUC},
  {"CNS11643-1992-6",   CS_CNS11643_1992_6,     ENC_EUC},
  {"CNS11643-1992-7",   CS_CNS11643_1992_7,     ENC_EUC},
  {"GB2312-1980",       CS_GB2312_1980,         ENC_EUC},
  {"GB12345-1990",      CS_GB12345_1990,        ENC_EUC},
  {"JISX0208-1983",     CS_JISX0208_1983,       ENC_EUC},
  {"JISX0212-1990",     CS_JISX0212_1990,       ENC_EUC},
  {"KSC5601-1987",      CS_KSC5601_1987,        ENC_EUC},

  {NULL,                -1,                     -1},
};
