/*
                 Process Forking, Execution, and Management

	Functions:

        void chldkill(int arroooool)
	char **ExecExplodeCommand(char *cmd, int *strc)

	void Execute(char *cmd)


	Non-blocking:

	pid_t Exec(char *cmd)
	pid_t ExecAOE(char *cmd, char *stdout_path, char *stderr_path)
	pid_t ExecAO(char *cmd, char *stdout_path)


	Blocking:

	pid_t ExecB(char *cmd)
	pid_t ExecBAOE(char *cmd, char *stdout_path, char *stderr_path)
	pid_t ExecBAO(char *cmd, char *stdout_path)

	---

 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <unistd.h>
#include <signal.h>

#include <sys/time.h>

extern int errno;
#include <errno.h>

#ifndef _USE_BSD
# define _USE_BSD
#endif
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/wait.h>

#include "../include/os.h"
#include "../include/string.h"
#include "../include/disk.h"

#include "../include/prochandle.h"


/*
 *	Signal handler for SIGCHLD.
 */
void chldkill(int arroooool)
{
        int status;

        while(wait3(&status, WNOHANG, (struct rusage *)0) > 0);

	return;
}



/*
 *	Explodes cmd string.   Returns are dynamically allocated
 *	and need to be free()'ed.
 */
char **ExecExplodeCommand(char *cmd, int *strc)
{
        int x, y, z;
        int str_num;
        int src_pos;
        int len;
        char **strv;

	char skip_quotes;
        
char c = ' ';
        
            
        /* Error checks. */
        if(strc == NULL)
            return(NULL);
        if(cmd == NULL)
        {
            *strc = 0;  
            return(NULL);
        }
             
                
        /* ************************************************************* */
        /* Reset values. */
        src_pos = 0;
        str_num = 0;
            
        strv = NULL;
        *strc = 0;
             
        len = strlen(cmd);
	skip_quotes = 0;

	/* Skip initial characters. */
	while(src_pos < len)
	{
	    if(cmd[src_pos] != c)
		break;

	    src_pos++;
	}


	/* Begin exploding strings. */
        while(src_pos < len)
        {
	    skip_quotes = 0;

            /* Get length y of this segment x. */
            x = src_pos;
            y = 0;
            while((cmd[x] != c) && (x < len))
            {
		/* Quote grouping skip. */
		if(cmd[x] == '"')
		{
		    skip_quotes = 1;
		    x++;

		    /* Seek to end quote. */
		    while(x < len)
		    {
			if(cmd[x] == '"')
			    break;

			x++; y++;
		    }

		    break;
		}

                x++;
                y++;
            }
            /* y is now length of this segment. */

            /* Allocate new string for this segment. */
            str_num = *strc;
            *strc += 1;
            strv = (char **)realloc(strv, *strc * sizeof(char *));
            strv[str_num] = (char *)calloc(1, (y + 1) * sizeof(char));

            /* Copy segment. */
            x = src_pos;
            z = 0;
            while((x < len) && (z < y))
            {
		/* Skip quotes. */
		if(cmd[x] == '"')
		{
		    x++;
		    continue;
		}

                strv[str_num][z] = cmd[x];
                z++; x++;
            }
            strv[str_num][y] = '\0';    /* Null terminate. */
        
            /* Seek next src_pos. */
	    if(y < 1)
		src_pos += 1;
	    else
                src_pos += y;
	    if(skip_quotes)
	    {
                while(src_pos < len)
                {
                    if(cmd[src_pos] == '"')
		    {
			src_pos++;
                        break;
		    }
                    src_pos++;
                }
	    }
	    while(src_pos < len)
            {
		if(cmd[src_pos] != c)
		    break;

		src_pos++;
	    }
        }
        

        /* Return the allocated strings. */
        return(strv);
}



void Execute(char *cmd)
{
	if(cmd == NULL)
	    return;


	/* For eliminating zombies proccesses. */
	signal(SIGCHLD, chldkill);

	/* Fork off child process. */
        switch(fork())
        {
	  /* Forking error. */
          case -1:
	    perror("fork");
            exit(1);
	    break;

	  /* We are the child: run then command then exit. */  
          case 0:
            if(system(cmd) == -1)
                exit(-1);
	    else
                exit(0);
	    break;

	  /* We are the parent: do nothing. */        
          default:
            break;
        }


        return;
}



/* ****************************************************************** */


/*
 *	Fork off a child process to execute so it does not block
 *	execution of parent.
 *
 *	Current directory will be changed on the child process.
 */
pid_t Exec(char *cmd)
{
        int i;
	char *strptr;
        int argc;   
        char **argv;
	char new_cd[PATH_MAX];

        pid_t p;
 

        /* Error checks. */
        if(cmd == NULL)
            return(0);

        /* Explode cmd string, argv and its strings are allocated. */
        argv = ExecExplodeCommand(cmd, &argc);  
        if((argv == NULL) || (argc < 1))
            return(0);

        /* Put NULL on last pointer. */
        argv = (char **)realloc(argv, (argc + 1) * sizeof(char *));
        if(argv == NULL)
            return(0);
        argv[argc] = NULL;


	/* Set new current dir. */
	if(argc > 0)
	{
	    strptr = GetParentDir(argv[0]);
	    if(strptr == NULL)
		strncpy(new_cd, "/", PATH_MAX);
	    else
	        strncpy(new_cd, strptr, PATH_MAX);
	}
	else
	{
	    strncpy(new_cd, "/", PATH_MAX);
	}
	new_cd[PATH_MAX - 1] = '\0';


        /* ********************************************************* */
                
        /* Set SIGCHLD to signal handler to eliminate zombies. */
        signal(SIGCHLD, chldkill);
        
        /* Fork off a process. */
        p = fork();
        switch(p)   
        {
          /* Forking error. */
          case -1:
            perror("fork");
            exit(1);
            break;
 
          /* We are the child: run the command then exit. */
          case 0:
	    /* Change dir. */
	    if(chdir(new_cd))
		chdir("/");

            /* Execute command and arguments. */
            execvp(argv[0], argv);

            exit(0);
            break;
        
          /* We are the parent: Do nothing. */
          default:
            break;
        }


        /* ********************************************************* */

        /* Free allocated string pointers. */
        for(i = 0; i < argc; i++)
            free(argv[i]);

        free(argv);
	argv = NULL;
        argc = 0;


        return(p);
}


pid_t ExecAOE(char *cmd, char *stdout_path, char *stderr_path)
{
        int i;
	char *strptr;
        int argc; 
        char **argv;
        char new_cd[PATH_MAX];
         
        FILE *stdout_fp;
        FILE *stderr_fp;

	pid_t p;
 

        /* Error checks. */
        if(cmd == NULL)
            return(0);

        /* Create stdout file (as needed). */
        if(stdout_path != NULL)  
            stdout_fp = fopen(stdout_path, "a");
        else
            stdout_fp = NULL;
            
        /* Create stderr file (as needed). */
        if(stderr_path != NULL)  
            stderr_fp = fopen(stderr_path, "a");
        else
            stderr_fp = NULL;


        /* Explode cmd string, argv and its strings are allocated. */
        argv = ExecExplodeCommand(cmd, &argc);
        if((argv == NULL) || (argc < 1))
            return(0);

        /* Put NULL on last pointer. */
        argv = (char **)realloc(argv, (argc + 1) * sizeof(char *));
        if(argv == NULL)
            return(0);
        argv[argc] = NULL;


        /* Set new current dir. */
        if(argc > 0)
        {
            strptr = GetParentDir(argv[0]);
            if(strptr == NULL)
                strncpy(new_cd, "/", PATH_MAX);
            else
                strncpy(new_cd, strptr, PATH_MAX);
        }
        else
        {
            strncpy(new_cd, "/", PATH_MAX);
        }
        new_cd[PATH_MAX - 1] = '\0';
 
 
        /* ********************************************************* */

        /* Set SIGCHLD to signal handler to eliminate zombies. */
        signal(SIGCHLD, chldkill);

        /* Fork off a process. */
	p = fork();
        switch(p)
        {
          /* Forking error. */
          case -1:
            perror("fork");
            exit(1);
            break;
         
          /* We are the child: run the command then exit. */
          case 0:
            /* Redirect outputs. */
            if(stdout_fp != NULL)
                dup2(fileno(stdout_fp), fileno(stdout));
            if(stderr_fp != NULL)
                dup2(fileno(stderr_fp), fileno(stderr));
        
            /* Execute command and arguments. */
            execvp(argv[0], argv);
            exit(0);
            break;

          /* We are the parent: Do nothing. */
          default:
            break;
        }


        /* ********************************************************* */

        /* Free allocated string pointers. */
        for(i = 0; i < argc; i++)
            free(argv[i]);

        free(argv);
	argv = NULL;
        argc = 0;

          
        /* Close output files. */
        if(stdout_fp != NULL)
        {
            fclose(stdout_fp);
            stdout_fp = NULL;
        }
        if(stderr_fp != NULL)
        {
            fclose(stderr_fp);   
            stderr_fp = NULL;
        }

                
        return(p);
}



pid_t ExecAO(char *cmd, char *stdout_path)
{
	pid_t p;

	p = ExecAOE(cmd, stdout_path, NULL);

	return(p);
}




/* ********************************************************************
 *
 *	Execute and block execution of parent.
 */

pid_t ExecB(char *cmd)
{
        int i, status;
        int argc;   
        char **argv;

        pid_t p;


        /* Error checks. */
        if(cmd == NULL)
            return(0);

        /* Explode cmd string, argv and its strings are allocated. */
        argv = ExecExplodeCommand(cmd, &argc);
        if((argv == NULL) || (argc < 1))
            return(0);

        /* Put NULL on last pointer. */
        argv = (char **)realloc(argv, (argc + 1) * sizeof(char *));
        if(argv == NULL)
            return(0);
        argv[argc] = NULL;


	/* ************************************************************* */

        /* Fork off a process. */
        p = fork();
        switch(p)   
        {
          /* Forking error. */
          case -1:
            perror("fork");
            exit(1);
            break;

          /* We are the child: run the command then exit. */
          case 0:
            /* Execute command and arguments. */
            execvp(argv[0], argv);
            exit(0);
            break;

          /* We are the parent: wait for child to finish. */
          default:
            wait(&status);
            break;
        }


        /* ********************************************************* */

        /* Free allocated string pointers. */
        for(i = 0; i < argc; i++)
            free(argv[i]);

        free(argv);
	argv = NULL;
        argc = 0; 


        return(p);
}


pid_t ExecBAOE(char *cmd, char *stdout_path, char *stderr_path)
{
	int i, status;
	int argc;
	char **argv;

	FILE *stdout_fp;
	FILE *stderr_fp;

	pid_t p;


        /* Error checks. */
        if(cmd == NULL)
            return(0);

	/* Create stdout file (as needed). */
	if(stdout_path != NULL)
	    stdout_fp = fopen(stdout_path, "a");
	else
	    stdout_fp = NULL;

        /* Create stderr file (as needed). */
        if(stderr_path != NULL)
            stderr_fp = fopen(stderr_path, "a");
        else
            stderr_fp = NULL;


	/* Explode cmd string, argv and its strings are allocated. */
	argv = ExecExplodeCommand(cmd, &argc);
	if((argv == NULL) || (argc < 1))
	    return(0);

	/* Put NULL on last pointer. */
	argv = (char **)realloc(argv, (argc + 1) * sizeof(char *));
	if(argv == NULL)
            return(0);
	argv[argc] = NULL;


        /* ********************************************************* */

	/* Fork off a process. */
	p = fork();
        switch(p)
        {
          /* Forking error. */
          case -1:
            perror("fork");
            exit(1);
            break;

          /* We are the child: run the command then exit. */
          case 0:
	    /* Redirect outputs. */
	    if(stdout_fp != NULL)
	        dup2(fileno(stdout_fp), fileno(stdout));
	    if(stderr_fp != NULL)
                dup2(fileno(stderr_fp), fileno(stderr));

	    /* Execute command and arguments. */
	    execvp(argv[0], argv);
	    exit(0);
            break;
 
          /* We are the parent: wait for child to finish. */
          default:
	    wait(&status);
            break;
        }   


        /* ********************************************************* */

        /* Free allocated string pointers. */
	for(i = 0; i < argc; i++)
	    free(argv[i]);

	free(argv);
	argv = NULL;
	argc = 0;


	/* Close output files. */
	if(stdout_fp != NULL)
	{
	    fclose(stdout_fp);
	    stdout_fp = NULL;
	}
	if(stderr_fp != NULL)
	{
	    fclose(stderr_fp);
	    stderr_fp = NULL;
	}


	return(p);
}



pid_t ExecBAO(char *cmd, char *stdout_path)
{
	pid_t p;

	p = ExecBAOE(cmd, stdout_path, NULL);

	return(p);
}
