/*
                         Mixer Channel Device IO

	Functions:

        int YMixerGet(
                Recorder *recorder,
                int mixer_code,
                Coefficient *value1,
                Coefficient *value2
        )

	int MYixerSet(
	        Recorder *recorder,
	        int mixer_code,
	        Coefficient value1,
	        Coefficient value2
	)

	---

 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>

#ifdef __linux__
# include <linux/soundcard.h>
#endif

#include "ysound.h"
#include "ymixer.h"




int GET_MIXER_NUM_BY_NAME(int fd, char *name);


int YMixerSetBass(int fd, double value1, double value2);
int YMixerSetCD(int fd, double value1, double value2);
int YMixerSetGainIn(int fd, double value1, double value2);
int YMixerSetGainOut(int fd, double value1, double value2);
int YMixerSetLine(int fd, double value1, double value2);
int YMixerSetLine1(int fd, double value1, double value2);
int YMixerSetLine2(int fd, double value1, double value2);
int YMixerSetLine3(int fd, double value1, double value2);
int YMixerSetMic(int fd, double value1, double value2);
int YMixerSetMix(int fd, double value1, double value2);
int YMixerSetPCM(int fd, double value1, double value2);
int YMixerSetPCM2(int fd, double value1, double value2);
int YMixerSetRec(int fd, double value1, double value2);
int YMixerSetSpeaker(int fd, double value1, double value2);
int YMixerSetSynth(int fd, double value1, double value2);
int YMixerSetTreble(int fd, double value1, double value2);
int YMixerSetVolume(int fd, double value1, double value2);

int YMixerGetBass(int fd, double *value, double *value2);
int YMixerGetCD(int fd, double *value1, double *value2);
int YMixerGetGainIn(int fd, double *value1, double *value2);
int YMixerGetGainOut(int fd, double *value1, double *value2);
int YMixerGetLine(int fd, double *value, double *value2);
int YMixerGetLine1(int fd, double *value, double *value2);
int YMixerGetLine2(int fd, double *value, double *value2);
int YMixerGetLine3(int fd, double *value, double *value2);
int YMixerGetMic(int fd, double *value1, double *value2);
int YMixerGetMix(int fd, double *value, double *value2);
int YMixerGetPCM(int fd, double *value1, double *value2);
int YMixerGetPCM2(int fd, double *value1, double *value2);
int YMixerGetRec(int fd, double *value, double *value2);
int YMixerGetSpeaker(int fd, double *value, double *value2);
int YMixerGetSynth(int fd, double *value1, double *value2);
int YMixerGetTreble(int fd, double *value, double *value2);
int YMixerGetVolume(int fd, double *value1, double *value2);


/*
 *	Returns the mixer device's number matching name or
 *	-1 on failed match.
 */
int GET_MIXER_NUM_BY_NAME(int fd, char *name)
{
	int i;
	int mixermask;
        const char *reg_name[] = SOUND_DEVICE_NAMES;


	if((fd < 0) ||
           (name == NULL)
	)
	    return(-1);


        /* Get mixer info mask. */
        if(ioctl(fd, SOUND_MIXER_READ_DEVMASK, &mixermask))
        {
	    /* Could not get mixer info mask. */
            return(-1);
        }

        for(i = 0; i < SOUND_MIXER_NRDEVICES; i++)
        {
            if(((1 << i) & mixermask) &&
               !strcmp(name, reg_name[i])
            )
                break;
        }

        if(i < SOUND_MIXER_NRDEVICES)
	    return(i);
	else
	    return(-1);
} 



/* **************************************************************** */

#define YMIXER_SET_MAC	\
if(ioctl(fd, SOUND_MIXER_READ_STEREODEVS, &stereomask))\
 return(-1);\
\
/* Is this a stereo channel device? */\
if((value1 != value2) && !((1 << i) & stereomask))\
{\
 value1 = (value1 + value2) / 2;\
 value2 = value1;\
}\
\
left = (unsigned int)(value1 * 100);\
right = (unsigned int)(value2 * 100);\
\
packed_value = (right << 8) + left;\
\
return(ioctl(fd, MIXER_WRITE(i), &packed_value));


/*
 *	Mixer channel device set functions.
 */
int YMixerSetBass(int fd, double value1, double value2)
{
        int i, left, right, stereomask, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "bass");
        if(i < 0)
            return(-1);

	YMIXER_SET_MAC
}

int YMixerSetCD(int fd, double value1, double value2)
{
        int i, left, right, stereomask, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "cd");
        if(i < 0)
            return(-1);
            
        YMIXER_SET_MAC
}

int YMixerSetGainIn(int fd, double value1, double value2)
{
        int i, left, right, stereomask, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "igain");
        if(i < 0)
            return(-1);

        YMIXER_SET_MAC
}

int YMixerSetGainOut(int fd, double value1, double value2)
{
        int i, left, right, stereomask, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "ogain");
        if(i < 0)
            return(-1);

        YMIXER_SET_MAC
}

int YMixerSetLine(int fd, double value1, double value2)
{
        int i, left, right, stereomask, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "line");
        if(i < 0)
            return(-1);

        YMIXER_SET_MAC
}

int YMixerSetLine1(int fd, double value1, double value2)
{
        int i, left, right, stereomask, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "line1");
        if(i < 0)
            return(-1);

        YMIXER_SET_MAC
}

int YMixerSetLine2(int fd, double value1, double value2)
{
        int i, left, right, stereomask, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "line2");
        if(i < 0)
            return(-1);
            
        YMIXER_SET_MAC
}

int YMixerSetLine3(int fd, double value1, double value2)
{
        int i, left, right, stereomask, packed_value;
        
        
        i = GET_MIXER_NUM_BY_NAME(fd, "line3");
        if(i < 0)
            return(-1);
            
        YMIXER_SET_MAC
}

int YMixerSetMic(int fd, double value1, double value2)
{
        int i, left, right, stereomask, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "mic");
        if(i < 0)
            return(-1);

        YMIXER_SET_MAC
}

int YMixerSetMix(int fd, double value1, double value2)
{
        int i, left, right, stereomask, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "mix");
        if(i < 0)
            return(-1);

        YMIXER_SET_MAC
}

int YMixerSetPCM(int fd, double value1, double value2)
{
        int i, left, right, stereomask, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "pcm");
        if(i < 0)
            return(-1);

        YMIXER_SET_MAC
}

int YMixerSetPCM2(int fd, double value1, double value2)
{
        int i, left, right, stereomask, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "pcm2");
        if(i < 0)
            return(-1);

        YMIXER_SET_MAC
}

int YMixerSetRec(int fd, double value1, double value2)
{
        int i, left, right, stereomask, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "rec");
        if(i < 0)
            return(-1);

        YMIXER_SET_MAC
}

int YMixerSetSpeaker(int fd, double value1, double value2)
{
        int i, left, right, stereomask, packed_value;
        
        
        i = GET_MIXER_NUM_BY_NAME(fd, "speaker");
        if(i < 0)
            return(-1);
            
        YMIXER_SET_MAC
}

int YMixerSetSynth(int fd, double value1, double value2)
{
        int i, left, right, stereomask, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "synth");
        if(i < 0)
            return(-1);

        YMIXER_SET_MAC
}

int YMixerSetTreble(int fd, double value1, double value2)
{
        int i, left, right, stereomask, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "treble");
        if(i < 0)
            return(-1);

        YMIXER_SET_MAC
}

int YMixerSetVolume(int fd, double value1, double value2)
{
        int i, left, right, stereomask, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "vol");
        if(i < 0)
            return(-1);

        YMIXER_SET_MAC
}


/* ***************************************************************** */

#define YMIXER_GET_MAC	\
if(ioctl(fd, MIXER_READ(i), &packed_value))\
 return(-1);\
*value1 = (double)(packed_value & 0x000000ff) / (double)100;\
*value2 = (double)((packed_value & 0x0000ff00) >> 8) / (double)100;



/*
 *      Mixer channel device get functions.
 */
int YMixerGetBass(int fd, double *value1, double *value2)
{
        int i, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "bass");
        if(i < 0)
            return(-1);

	YMIXER_GET_MAC

	return(0);
}

int YMixerGetCD(int fd, double *value1, double *value2)
{
        int i, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "cd");
        if(i < 0)
            return(-1);

        YMIXER_GET_MAC

        return(0);
}

int YMixerGetGainIn(int fd, double *value1, double *value2)
{
        int i, packed_value;
        
        
        i = GET_MIXER_NUM_BY_NAME(fd, "igain");
        if(i < 0)
            return(-1);
            
        YMIXER_GET_MAC

        return(0);
}

int YMixerGetGainOut(int fd, double *value1, double *value2)
{
        int i, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "ogain");
        if(i < 0)
            return(-1);

        YMIXER_GET_MAC

        return(0);
}

int YMixerGetLine(int fd, double *value1, double *value2)
{
        int i, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "line");
        if(i < 0)
            return(-1);

        YMIXER_GET_MAC

        return(0);
}

int YMixerGetLine1(int fd, double *value1, double *value2)
{
        int i, packed_value;
        
        
        i = GET_MIXER_NUM_BY_NAME(fd, "line1");
        if(i < 0)
            return(-1);

        YMIXER_GET_MAC

        return(0);
}

int YMixerGetLine2(int fd, double *value1, double *value2)
{
        int i, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "line2");
        if(i < 0)
            return(-1);

        YMIXER_GET_MAC

        return(0);
}

int YMixerGetLine3(int fd, double *value1, double *value2)
{
        int i, packed_value;
        
        
        i = GET_MIXER_NUM_BY_NAME(fd, "line3");
        if(i < 0)
            return(-1);
            
        YMIXER_GET_MAC

        return(0);
}

int YMixerGetMic(int fd, double *value1, double *value2)
{
        int i, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "mic");
        if(i < 0)
            return(-1);

        YMIXER_GET_MAC

        return(0);
}

int YMixerGetMix(int fd, double *value1, double *value2)
{
        int i, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "mix");
        if(i < 0)
            return(-1);

        YMIXER_GET_MAC

        return(0);
}       

int YMixerGetPCM(int fd, double *value1, double *value2)
{
        int i, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "pcm");
        if(i < 0)
            return(-1);

        YMIXER_GET_MAC

        return(0);
}

int YMixerGetPCM2(int fd, double *value1, double *value2)
{
        int i, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "pcm2");
        if(i < 0)
            return(-1);

        YMIXER_GET_MAC

        return(0);
}

int YMixerGetRec(int fd, double *value1, double *value2)
{
        int i, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "rec");
        if(i < 0)
            return(-1);

        YMIXER_GET_MAC

        return(0);
}

int YMixerGetSpeaker(int fd, double *value1, double *value2)
{
        int i, packed_value;
        
        
        i = GET_MIXER_NUM_BY_NAME(fd, "speaker");
        if(i < 0)
            return(-1);
            
        YMIXER_GET_MAC
        
        return(0);
}

int YMixerGetSynth(int fd, double *value1, double *value2)
{
        int i, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "synth");
        if(i < 0)
            return(-1);

        YMIXER_GET_MAC

        return(0);
}

int YMixerGetTreble(int fd, double *value1, double *value2)
{
        int i, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "treble");
        if(i < 0)
            return(-1);
            
        YMIXER_GET_MAC
        
        return(0);
}

int YMixerGetVolume(int fd, double *value1, double *value2)
{
        int i, packed_value;


        i = GET_MIXER_NUM_BY_NAME(fd, "vol");
        if(i < 0)
            return(-1);

        YMIXER_GET_MAC

        return(0);
}


/* ******************************************************************* */

/*
 *      Gets mixer channel device values for the specified channel
 *	device mixer_code.   Returns -1 on error, -2 on unsupported
 *	mixer_code, or 0 on success.
 */
int YMixerGet(
	Recorder *recorder,
	int mixer_code,		/* One of YMixerCode*. */
	Coefficient *value1,	/* [0, 1]. */
	Coefficient *value2	/* [0, 1]. */
)
{
	int fd, status = -2;


	if(recorder == NULL)
	    return(-1);

	fd = recorder->audio.mixer_fd;
        if(fd < 0)
            return(-1);


	if((value1 == NULL) ||
           (value2 == NULL)
	)
	    return(-1);

	*value1 = 0;
	*value2 = 0;

        switch(mixer_code)
        {
          case YMixerCodeBass:
            status = YMixerGetBass(fd, value1, value2);
            break;

          case YMixerCodeCD:
            status = YMixerGetCD(fd, value1, value2);
	    break;

          case YMixerCodeGainIn:
            status = YMixerGetGainIn(fd, value1, value2);
            break;

          case YMixerCodeGainOut:
            status = YMixerGetGainOut(fd, value1, value2);
            break;

          case YMixerCodeLine:
            status = YMixerGetLine(fd, value1, value2);
            break;

          case YMixerCodeLine1:
            status = YMixerGetLine1(fd, value1, value2);
            break;

          case YMixerCodeLine2:
            status = YMixerGetLine2(fd, value1, value2);
            break;

          case YMixerCodeLine3:
            status = YMixerGetLine3(fd, value1, value2);
            break;

          case YMixerCodeMic:
            status = YMixerGetMic(fd, value1, value2);
            break;

          case YMixerCodeMix:
            status = YMixerGetMix(fd, value1, value2);
            break;

          case YMixerCodePCM:
            status = YMixerGetPCM(fd, value1, value2);        
            break;

          case YMixerCodePCM2:
            status = YMixerGetPCM2(fd, value1, value2);
            break;

          case YMixerCodeRec:
            status = YMixerGetRec(fd, value1, value2);
            break;

          case YMixerCodeSpeaker:
            status = YMixerGetSpeaker(fd, value1, value2);
            break;

          case YMixerCodeSynth:
            status = YMixerGetSynth(fd, value1, value2);
            break;

          case YMixerCodeTreble:
            status = YMixerGetTreble(fd, value1, value2);
            break;

          case YMixerCodeVolume:
            status = YMixerGetVolume(fd, value1, value2);
            break;
	}


	return(0);
}


/*
 *	Sets mixer channel device values for the specified channel
 *	device mixer_code. Returns -1 on error, -2 on unsupported
 *	mixer_code, or 0 on success.
 */
int YMixerSet(
	Recorder *recorder,
	int mixer_code,		/* One of YMixerCode*. */
	Coefficient value1,	/* [0, 1]. */
	Coefficient value2	/* [0, 1]. */
)
{
	int fd, status = -2;


        if(recorder == NULL)
            return(-1);

        fd = recorder->audio.mixer_fd;
        if(fd < 0)
            return(-1);


	/* Sanitize values. */
        if(value1 < 0)
            value1 = 0;
        if(value1 > 1)
            value1 = 1;

        if(value2 < 0)
            value2 = 0;
        if(value2 > 1)
            value2 = 1;
        
	switch(mixer_code)
	{
	  case YMixerCodeBass:
            status = YMixerSetBass(fd, value1, value2);
            break;

          case YMixerCodeCD:
            status = YMixerSetCD(fd, value1, value2);
            break;

          case YMixerCodeGainIn:
            status = YMixerSetGainIn(fd, value1, value2);
            break;

          case YMixerCodeGainOut:
            status = YMixerSetGainOut(fd, value1, value2);
            break;

          case YMixerCodeLine:
            status = YMixerSetLine(fd, value1, value2);
            break;

          case YMixerCodeLine1:
            status = YMixerSetLine1(fd, value1, value2);
            break;

          case YMixerCodeLine2:
            status = YMixerSetLine2(fd, value1, value2);
            break;

          case YMixerCodeLine3:
            status = YMixerSetLine3(fd, value1, value2);
            break;

          case YMixerCodeMic:
            status = YMixerSetMic(fd, value1, value2);
            break;

          case YMixerCodeMix:
            status = YMixerSetMix(fd, value1, value2);
            break;

          case YMixerCodePCM:
            status = YMixerSetPCM(fd, value1, value2);
            break;

          case YMixerCodePCM2:
            status = YMixerSetPCM2(fd, value1, value2);
            break;

          case YMixerCodeRec:
            status = YMixerSetRec(fd, value1, value2);
            break;

          case YMixerCodeSpeaker:
            status = YMixerSetSpeaker(fd, value1, value2);
            break;

          case YMixerCodeSynth:
            status = YMixerSetSynth(fd, value1, value2);
            break;

          case YMixerCodeTreble:
            status = YMixerSetTreble(fd, value1, value2);
            break;

	  case YMixerCodeVolume:
	    status = YMixerSetVolume(fd, value1, value2);  
	    break;
	}



        return(status);
}
