/*
                        Add Mode Dialog

	Functions:

	void AddModeAddBtnCB(GtkWidget *widget, gpointer data)
	void AddModeCancelBtnCB(GtkWidget *widget, gpointer data)
	void AddModeTextActivateCB(GtkWidget *widget, gpointer data)
	void AddModeDestroyCB(
	        GtkWidget *widget,
	        GdkEvent *event,   
	        gpointer data  
	)
	int AddModeCreate(void)
	void AddModeDestroy(void)

	---

 */

#include <string.h>
#include "yiffconfig.h"


/*
 *	Add mode button callback.
 *
 *	Adds a new Audio mode to the ycw's Audio mode list.
 */
void AddModeAddBtnCB(GtkWidget *widget, gpointer data)
{
        gint i, n, sel_row, new_name_len;
        yc_win_struct *ycw;
        add_mode_dialog_struct *amd;
        audio_mode_struct *mode_ptr;
	GtkCList *clist;
	gchar *strptr, *strptr2;
        gchar *text[1];


        amd = (add_mode_dialog_struct *)data;
        

	/* Ger referance to ycw. */
	ycw = amd->ref_ycw;
	if(ycw == NULL)
	    return;

	clist = GTK_CLIST(ycw->audio_modes_list);
	if(clist == NULL)
	    return;


        /* Sanitize total. */
        if(ycw->total_audio_modes < 0)
            ycw->total_audio_modes = 0;


        sel_row = ycw->cur_sel_audio_mode;
        /* If not selected, then append. */
        if(sel_row < 0)
        {
            sel_row = ycw->total_audio_modes;
            /* Don't change current selected row number. */
        }
        else
        {
            /* Change selected row number. */
            ycw->cur_sel_audio_mode++;
        }

        /* Get new name entered on amd's name text widget. */
        strptr = gtk_entry_get_text(
            GTK_ENTRY(amd->name_text)
        );
	/* Check if name is valid. */
	if(strptr == NULL)
	{
            dprint(&dialog,
 "Cannot get audio mode name from entry (internal error)."
            );
	    return;
	}
	new_name_len = strlen(strptr);
	if(new_name_len <= 0)
	{
	    dprint(&dialog,
 "Audio mode names must be atleast one character long."
	    );
	    return;
	}
	if(strchr(strptr, ' ') != NULL)
	{
            dprint(&dialog, 
 "Audio mode names may not contain spaces." 
            ); 
	    return; 
	}
	for(i = 0; i < ycw->total_audio_modes; i++)
	{
	    strptr2 = NULL;
	    gtk_clist_get_text(clist, i, 0, &strptr2);
	    if(!strcasecmp(strptr2, strptr))
	    {
                dprint(&dialog,
"An Audio mode by that name already exists, please\n\
choose a different name. Audio mode name matching is\n\
case insensitive"
                );
		return;
	    }
	}

	/* Add new audio mode name to list widget. */
	text[0] = strptr;
        gtk_clist_insert(
            clist,
            sel_row,
            text
        );


        /* Add audio mode list. */
        if(sel_row >= ycw->total_audio_modes)
        {
            n = ycw->total_audio_modes;
            ycw->total_audio_modes++;

            ycw->audio_mode = (audio_mode_struct **)realloc(
                ycw->audio_mode,
                ycw->total_audio_modes * sizeof(audio_mode_struct *)
            );
            if(ycw->audio_mode == NULL)
            {
                ycw->total_audio_modes = 0;   
                return;
            }

            ycw->audio_mode[n] = (audio_mode_struct *)calloc(
                1,
                sizeof(audio_mode_struct)
            );
        }
        else
        {
            n = sel_row;
            ycw->total_audio_modes++;
            if(n >= ycw->total_audio_modes)
                n = ycw->total_audio_modes - 1;

            ycw->audio_mode = (audio_mode_struct **)realloc(
                ycw->audio_mode,
                ycw->total_audio_modes * sizeof(audio_mode_struct *)
            );
            if(ycw->audio_mode == NULL)
            {
                ycw->total_audio_modes = 0;
                return;
            }

            /* Shift pointer array up. */
            for(i = ycw->total_audio_modes - 1; i > n; i--)
                ycw->audio_mode[i] = ycw->audio_mode[i - 1];

            ycw->audio_mode[n] = (audio_mode_struct *)calloc(
                1,
                sizeof(audio_mode_struct)
            );
        }


        mode_ptr = ycw->audio_mode[n];
        if(mode_ptr == NULL)
            return;

        mode_ptr->sample_rate = 8000;
        mode_ptr->channels = 1;
        mode_ptr->sample_size = 8;
        mode_ptr->fragment_size = 1024;
        mode_ptr->num_fragments = 2;		/* Default to 2. */
        mode_ptr->allow_fragmenting = 1;	/* Default to true. */
        mode_ptr->direction = 0;		/* Default to play. */

        mode_ptr->cycle_us = 30000;
        mode_ptr->write_ahead_us = 30000 * 1.5;	/* Default to 1.5 times cycle. */


	/* Select entire text content for next time use. */
	gtk_entry_select_region(
	    GTK_ENTRY(amd->name_text),
	    0, new_name_len
	);


	/* Hide the add mode dialog. */
        gtk_widget_hide(amd->toplevel);


	return;
}

void AddModeCancelBtnCB(GtkWidget *widget, gpointer data)
{
	add_mode_dialog_struct *amd;


	amd = (add_mode_dialog_struct *)data;

	gtk_widget_hide(amd->toplevel);


	return;
}

void AddModeTextActivateCB(GtkWidget *widget, gpointer data)
{
	add_mode_dialog_struct *amd;

        amd = (add_mode_dialog_struct *)data;

	/* Call Add mode button CB. */
	AddModeAddBtnCB(amd->add_btn, amd);

	return;
}

void AddModeDestroyCB(
        GtkWidget *widget,
        GdkEvent *event,
        gpointer data
)
{
	AddModeCancelBtnCB(NULL, NULL);

	return;
}

int AddModeCreate(void)
{
        GtkWidget *w, *parent, *parent2;
        add_mode_dialog_struct *amd;


        amd = &add_mode_dialog;

	amd->ref_ycw = NULL;


        w = gtk_window_new(GTK_WINDOW_DIALOG);
        amd->toplevel = w;
        gtk_widget_set_usize(GTK_WIDGET(w), 360, 162);
	gtk_widget_center(GTK_WIDGET(w), 0);
        gtk_window_set_title(GTK_WINDOW(w), "Add Audio Mode");
        gtk_signal_connect(
            GTK_OBJECT(w),
            "delete_event",
            GTK_SIGNAL_FUNC(AddModeDestroyCB),
            amd
        );
        gtk_signal_connect(
            GTK_OBJECT(w),
            "destroy",
            GTK_SIGNAL_FUNC(AddModeDestroyCB),
            amd
        );

	parent = amd->toplevel;
        w = gtk_vbox_new(FALSE, 10);
	gtk_container_add(GTK_CONTAINER(parent), w);
	gtk_widget_show(w);

	parent = w;
	w = gtk_label_new(
"Enter the name of the new preset Audio mode you wish\n\
to add. Remember that Audio mode names should be\n\
considered case sensitive."
	);
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 5);
	gtk_widget_show(w);


	w = gtk_table_new(2, 1, FALSE);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 5);
        gtk_widget_show(w);

	parent2 = w;

        w = gtk_label_new("Name:");
        gtk_table_attach(GTK_TABLE(parent2),
            w,
            0, 1,
            0, 1,
            GTK_SHRINK,
            GTK_SHRINK,
            2, 2
        );
        gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
        gtk_widget_show(w);

        w = gtk_entry_new_with_max_length(256);
        amd->name_text = w;
/*
        gtk_entry_set_text(GTK_ENTRY(w), DEF_YSERVER_ADDRESS);
 */
        gtk_table_attach(GTK_TABLE(parent2),
            w,
            1, 2,
            0, 1,
            GTK_FILL | GTK_SHRINK | GTK_EXPAND,
            GTK_SHRINK,
            2, 2
        );
        gtk_signal_connect(
            GTK_OBJECT(w),
            "activate",
            GTK_SIGNAL_FUNC(AddModeTextActivateCB),
            amd
        );
        gtk_widget_show(w);


	w = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	parent2 = w;

        w = gtk_button_new_with_label("Add");
        amd->add_btn = w;
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_set_usize(GTK_WIDGET(w), 60, 25);
        gtk_signal_connect(
            GTK_OBJECT(w),
            "clicked",
            GTK_SIGNAL_FUNC(AddModeAddBtnCB),
            amd
        );
        gtk_widget_show(w);

        w = gtk_button_new_with_label("Cancel");
        amd->cancel_btn = w;
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_set_usize(GTK_WIDGET(w), 60, 25);
        gtk_signal_connect(
            GTK_OBJECT(w),
            "clicked",
            GTK_SIGNAL_FUNC(AddModeCancelBtnCB),
            amd
        );
        gtk_widget_show(w);


	return(0);
}


void AddModeDestroy(void)
{
        add_mode_dialog_struct *amd;


        amd = &add_mode_dialog;


	amd->toplevel = NULL;

	amd->ref_ycw = NULL;


	return;
}
