#include <stdio.h>

#include <Y2/Y.h>
#include <Y2/Ylib.h>

#define CON_ARG		"127.0.0.1:9433"


int main(int argc, char *argv[])
{
	YConnection *con;
	char *filename;
	YEventSoundObjectAttributes sndobj_attrib;
	YID play_id;
	YEvent event;


	/* Need atleast one argument, being the file name.
	 * This is so that we can play a sound object on file.
	 */
	if(argc < 2)
		return(1);
	else
		filename = argv[1];


	/* Connect to the Y server. We pass NULL as the start argument,
	 * this means the Y server will not be started if it was detected
	 * to be not running. The connection argument is CON_ARG
	 * which is defined at the beginning of the source. The
	 * connection argument is a string of the format "<addr>:<port>",
	 * the <addr> needs to be in IP (1numbers and dots') notation.
	 */
	con = YOpenConnection(
		NULL,
		CON_ARG
	);
	if(con == NULL)
	{
		/* Failed to connect to the Y server. */
	        fprintf(
			stderr,
			"%s: Cannot connect to YIFF server.\n",
			CON_ARG
		);
		return(1);
	}


	/* Let's check if the filename exists on the computer
	 * that the Y server is running on (think about that!) and
	 * obtain its attributes.
	 */

        if(YGetSoundObjectAttributes(
		con,
		filename,
		&sndobj_attrib
        ))
	{
		/* Can't get sound object attributes. */
		fprintf(
			stderr,
			"%s: Error: Missing or corrupt.\n",
			filename
		);
	}
	else
	{
		/* Start playing the sound object. */
		play_id = YStartPlaySoundObject(
			con,
                        filename,
			0,		/* Start position. */
                        1.0, 1.0,	/* Left and right vol coeff. */
			1		/* Repeats. */
		);

		/* Print sound object attributes. */
		switch(sndobj_attrib.format)
                {
			case SndObjTypeDSP:
			printf(
"ID: %i  Type: DSP  SmpRate: %i Hz  Bits: %i  Ch: %i\n",
                            play_id,
                            sndobj_attrib.sample_rate,
                            sndobj_attrib.sample_size,
                            sndobj_attrib.channels
                        );
                        break;

                        case SndObjTypeMIDI:
                        printf(
 "ID: %i  Type: MIDI\n",
                            play_id
                        );
                        break;

                        default:
                        printf(
 "ID: %i  Type: *Unknown*\n",
                            play_id
                        );
                }

		/* Wait untill audio is done playing. */
		while(1)
		{
			if(YGetNextEvent(
				con,
				&event,
				False	/* Nonblocking. */
		    	) > 0)
		    	{
	                	if((event.type == YSoundObjectKill) &&
			           (event.kill.yid == play_id)
			        )
				{
			        	/* Our play has stopped. */
					printf("Done playing.\n");
					break;
				}
				if((event.type == YDisconnect) ||
                                   (event.type == YShutdown)
				)
				{
					/* We got disconnect from Y server. */
					printf("Y server disconnected us.\n");
					break;
				}
			}

			usleep(1000);	/* Don't hog the CPU. */
		}
	}


	/* Disconnect from the Y server. We need to pass the original
	 * connection pointer con to close that connection to the Y server.
	 * The second argument asks us do we want to leave the Y server up
	 * when we disconnect. If we were the program that started the Y server
	 * and the second argument is set to False then the Y server
	 * will be automatically shut down.  To ensure that the Y server
	 * stays running, you can pass True instead.
	 */
	YCloseConnection(con, False);
	con = NULL;


	return(0);
}
