#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>

#include <Y2/Y.h>
#include <Y2/Ylib.h>
#include <Y2/Ymixercodes.h>

#include "../include/string.h"
#include "../include/strexp.h"


#ifndef DEF_CON_ARG
# define DEF_CON_ARG    "127.0.0.1:9433"
#endif            


/*
 *	Print usage help.
 */
void PrintUsage()
{
	printf("\
Usage: ymixer [mixer] [value1] [value2] [options]\n\
\n\
    [mixer] specifies the mixer channel device name, running without\n\
    any arguments prints a list of available mixer names.
\n\
    [value1] and [value2] specify the percent values in the domain\n\
    of [0.0%%, 100.0%%] to be set (decimals allowed). If neither is\n\
    specified then the current value is printed.\n\
\n\
    [options] can be any of the following:\n\
\n\
        --recorder <address:port>    Specify which YIFF server to connect to.\n\
\n"
	);


	return;
}


int main(int argc, char *argv[])
{
	int i, n;
	char *strptr;
	char *con_arg = NULL;

	YConnection *con = NULL;

	int mixer_code = 0;
	int mixer_num = 0;

	int got_values = 0;
	Coefficient value1 = 0, value2 = 0;
	char *mixer_name[] = YMixerConicalNames;


	/* Parse arguments. */
	for(i = 1; i < argc; i++)
	{
	    if(argv[i] == NULL)
		continue;

	    /* Help. */
	    if(strcasepfx(argv[i], "--h") ||
               strcasepfx(argv[i], "-h") ||
               !strcmp(argv[i], "?")
	    )
	    {
		PrintUsage();

		free(con_arg);
		con_arg = NULL;
		return(0);
	    }
            /* Connect address. */
            else if(strcasepfx(argv[i], "--rec") || 
                    strcasepfx(argv[i], "-rec")
            )
            {
                i++;
                if(i < argc)
                {
                    free(con_arg);
                    con_arg = StringCopyAlloc(argv[i]);
                }
                else 
                {
                    fprintf(stderr,
                        "%s: Requires argument.\n",
                        argv[i - 1]
                    );
                }
            }
	    /* Mixer code and index number. */
	    else if(i == 1)	/* `First' argument. */
	    {
		strptr = argv[i];	/* For efficiency. */
		/* Go through mixer names (not mixer codes). */
		for(n = 0; n < YTotalMixers; n++)
		{
		    /* Argument matches this mixer name? */
		    if(!strcasecmp(strptr, mixer_name[n]))
		    {
			/* Got match, but remember to add base offset
			 * to get correct mixer code (not mixer number).
			 */
			mixer_code = n + YMixerCodeBaseOffset;
			mixer_num = n;
		    }
		}
	    }
            /* Value 1. */
            else if(i == 2)
            {
		value1 = atof(argv[i]);
		got_values = 1;	/* Note that we got value(s). */
            }
            /* Value 2. */
            else if(i == 3)
            {
                value2 = atof(argv[i]);
		got_values = 1;	/* Note that we got value(s). */
            }
	}



	/*
	 *	Connect to YIFF server.
	 */
	con = YOpenConnection(
	    NULL,		/* No start argument. */
	    con_arg
	);
	if(con == NULL)
	{
	    printf("%s: Cannot connect to YIFF server.\n",
		(con_arg == NULL) ? DEF_CON_ARG : con_arg
	    );

            free(con_arg);
            con_arg = NULL;

	    return(-1);
	}


	/* Set or get values? */
	if(got_values)
	{
	    /* We have values, so set them. */
	    if(YSetMixerChannel(
		con,
		mixer_code,
		value1 / 100, value2 / 100
	    ))
		fprintf(
		    stderr,
		    "%s channel: Cannot set values.\n",
		    mixer_name
		);
	}
	else
	{
	    /* No values specified, so print mixer channel value(s). */

	    if(mixer_code == 0)
	    {
		/* Mixer code is 0, that implies that we print all mixer
		 * channel values.
		 */
		/* Go through mixer numbers. */
		for(i = 0; i < YTotalMixers; i++)
		{
		    /* Calculate mixer code (remember i is mixer number). */
		    mixer_code = i + YMixerCodeBaseOffset;

		    /* Set mixer index number. */
		    mixer_num = i;

		    /* Get mixer values for this mixer code. */
		    if(YGetMixerChannel(
			con, mixer_code,
			&value1, &value2
		    ))
			printf(
			    "%s: Cannot obtain values.\n",
			    mixer_name[mixer_num]
			);
		    else
			printf(
			    "%s: %.1lf%% %.1lf%%\n",
			    mixer_name[mixer_num],
			    value1 * 100, value2 * 100
			);
		}
	    }
	    else
	    {
		/* Print specific mixer channel. */

		/* Sanitize mixer index number. */
		if(mixer_num >= YTotalMixers)
		    mixer_num = YTotalMixers - 1;
		if(mixer_num < 0)
		    mixer_num = 0;

                /* Get mixer values. */
                if(YGetMixerChannel(
                    con, mixer_code,
                    &value1, &value2
                ))
                    printf(
                        "%s: Cannot obtain values.\n",
                        mixer_name[mixer_num]
                    );
                else
                    printf(
                        "%s: %.1lf%% %.1lf%%\n",
                        mixer_name[mixer_num],
                        value1 * 100, value2 * 100
                    );
	    }
	}

	/*
	 *	Disconnect from YIFF server
	 */
	YCloseConnection(con, False);
	con = NULL;

	free(con_arg);
	con_arg = NULL;


	return(0);
}
