// resource.cc for bbmail - an tool to display new mail in X11.
//
//  Copyright (c) 1998-1999 John Kennis, jkennis@chello.nl
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//

#include "resource.hh"
#include "blackboxstyle.hh"

Resource::Resource(ToolWindow *toolwindow): 
  BaseResource(toolwindow)
{
	report.force_check=False;
  frame.font=0;
  label.font=0;
  menu.font=0;
  Load();
}

Resource::~Resource()
{
	Clean();
}

void Resource::Clean()
{
	if (label.font) 
		XFreeFont(bbtool->getDisplay(), label.font);
	if (frame.font) 
		XFreeFont(bbtool->getDisplay(), frame.font);
	if (menu.font)
		XFreeFont(bbtool->getDisplay(), menu.font);
  frame.font=label.font=menu.font=0;				
		
	delete [] spoolfile;
	delete [] report.runCommand;

}


void Resource::LoadBBToolResource(void)
{
	XrmValue value;
	char *value_type;

	if (XrmGetResource(resource_db, "bbmail.autoConfig",
		     "Bbmail.Autoconfig", &value_type, &value))
	{
    	if (! strncasecmp("true", value.addr, value.size))
    	{
				style.auto_config = True;
		}
	    else
    		style.auto_config = False;
	}
	else
		style.auto_config = False;
	SizeAndPosition();

	Frame();

	Menu();

	Show();

	if (show.label)	
  {    
    Label();
  }

  if (show.envelope)
  {  
    Envelope();

  }	
	MailCheckSettings();

	MailboxDep();
}


void Resource::Frame()
{
	XrmValue value;
	char *value_type;

  readTexture("bbmail.frame","Bbmail.Frame",BB_FRAME,"Toolbar",
               "slategrey","darkslategrey",
               "Raised Gradient Vertical Bevel1",&frame.texture);
	
	if (XrmGetResource(resource_db, "bbmail.bevelWidth","Bbmail.BevelWidth",
						&value_type, &value))
	{
		if (sscanf(value.addr, "%u", &frame.bevelWidth) != 1)
			frame.bevelWidth = 4;
		else if (frame.bevelWidth == 0)
			frame.bevelWidth = 4;
	}
	else if (XrmGetResource(resource_db, BB_BEVELWIDTH,"BevelWidth", &value_type,
                          &value))
	{
		if (sscanf(value.addr, "%u", &frame.bevelWidth) != 1)
			frame.bevelWidth = 4;
		else if (frame.bevelWidth == 0)
			frame.bevelWidth = 4;
	}
	else
    	frame.bevelWidth = 4;
}

void Resource::Menu()
{
	XrmValue value;
	char *value_type;

	
	readTexture("bbmail.menu","Bbmail.Menu",BB_MENU,"Menu.Frame",
              "slategrey","darkslategrey",
              "Raised Diagonal Gradient Bevel1",&menu.texture);
															   	
  readColor("bbmail.menu.highlight.color",
				    "Bbmail.Menu.Highlight.Color",
             BB_MENU_HIGHLIGHT_COLOR,"Menu.highlightColor",
             "rgb:c/9/6",&menu.highlightColor);
  
	readColor("bbmail.menu.textColor","Bbmail.Menu.TextColor",
							      BB_MENU_TEXTCOLOR,"Menu.Frame.TextColor",
                    "LightGrey",&menu.textColor);

	readColor("bbmail.menu.highlight.textColor",
	    			"Bbmail.Menu.Highlight.TextColor",
			 			BB_MENU_HITEXTCOLOR,"Menu.Frame.HiTextColor",
            "white",&menu.hitextColor);

  if (XrmGetResource(resource_db,"bbmail.menuJustify","Bbmail.MenuJustify",
						&value_type, &value))
	{
    	if (! strncasecmp("leftjustify", value.addr, value.size))
	      menu.justify = LeftJustify;
    	else if (! strncasecmp("rightjustify", value.addr, value.size))
	      menu.justify = RightJustify;
	    else if (! strncasecmp("centerjustify", value.addr, value.size))
	      menu.justify = CenterJustify;
	    else
    	  menu.justify = LeftJustify;
	  }
	  else if (XrmGetResource(resource_db,BB_MENU_JUSTIFY,"Bbmail.MenuJustify",
								&value_type, &value))
	  {
    	if (! strncasecmp("leftjustify", value.addr, value.size))
	      menu.justify = LeftJustify;
    	else if (! strncasecmp("rightjustify", value.addr, value.size))
	      menu.justify = RightJustify;
	    else if (! strncasecmp("centerjustify", value.addr, value.size))
	      menu.justify = CenterJustify;
	    else
    	  menu.justify = LeftJustify;	
	  }
	  else
	    menu.justify = LeftJustify;
    
    if (XrmGetResource(resource_db, "bbmail.menu.bulletStyle", 
                       "Bbmail.Menu.BulletStyle", &value_type, &value)) {
    if (! strncasecmp(value.addr, "empty", value.size))
      menu.bullet_style = Empty;
    else if (! strncasecmp(value.addr, "square", value.size))
      menu.bullet_style = Square;
    else if (! strncasecmp(value.addr, "triangle", value.size))
      menu.bullet_style = Triangle;
    else if (! strncasecmp(value.addr, "diamond", value.size))
      menu.bullet_style = Diamond;
    else
      menu.bullet_style = Round;
  } else {
    if (XrmGetResource(resource_db, BB_MENU_BULLETSTYLE, 
                       "Menu.BulletStyle", &value_type, &value)) {
      if (! strncasecmp(value.addr, "empty", value.size))
        menu.bullet_style = Empty;
      else if (! strncasecmp(value.addr, "square", value.size))
        menu.bullet_style = Square;
      else if (! strncasecmp(value.addr, "triangle", value.size))
        menu.bullet_style = Triangle;
      else if (! strncasecmp(value.addr, "diamond", value.size))
        menu.bullet_style = Diamond;
      else
        menu.bullet_style = Round;
    } else
      menu.bullet_style = Round;
  }
    
  if (XrmGetResource(resource_db, "bbmail.menu.bulletPosition",
                     "Bbmail.Menu.BulletPosition", &value_type, &value)) {
    if (! strncasecmp(value.addr, "right", value.size))
      menu.bullet_pos = Right;
    else
      menu.bullet_pos = Left;
  } else {
    if (XrmGetResource(resource_db, BB_MENU_BULLETPOSITION,
                       "Menu.BulletPosition", &value_type, &value)) {
      if (! strncasecmp(value.addr, "right", value.size))
        menu.bullet_pos = Right;
      else
        menu.bullet_pos = Left;
    } else
      menu.bullet_pos = Left;
  }

	const char *defaultFont = "-*-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*";
	
	if (menu.font)
	{
		XFreeFont(bbtool->getDisplay(), menu.font);
		menu.font = 0;
	}
	
	if (XrmGetResource(resource_db, "bbmail.menu.font", "Bbmail.Menu.Font",
						&value_type, &value))
	{
		if ((menu.font = XLoadQueryFont(bbtool->getDisplay(), value.addr)) == NULL)
		{
    	fprintf(stderr, " blackbox: couldn't load font '%s'\n"
	      							" ...  reverting to default font.", value.addr);
		    if ((menu.font = XLoadQueryFont(bbtool->getDisplay(), defaultFont)) == NULL)
			{
				fprintf(stderr,
					"blackbox: couldn't load default font.  please check to\n"
					"make sure the necessary font is installed '%s'\n",
					defaultFont);
			exit(2);
			}
		}
	}
	else if  (XrmGetResource(resource_db, BB_MENU_FONT, "MenuFont", &value_type, &value))
	{
		if ((menu.font = XLoadQueryFont(bbtool->getDisplay(), value.addr)) == NULL)
		{
			fprintf(stderr, " blackbox: couldn't load font '%s'\n"
	      					" ...  reverting to default font.", value.addr);
			if ((menu.font = XLoadQueryFont(bbtool->getDisplay(), defaultFont)) == NULL)
			{
				fprintf(stderr,
					"blackbox: couldn't load default font.  please check to\n"
					"make sure the necessary font is installed '%s'\n",
					defaultFont);
				exit(2);
			}
		}
	}
	else
	{
		if ((menu.font = XLoadQueryFont(bbtool->getDisplay(), defaultFont)) == NULL)
		{
			fprintf(stderr,"blackbox: couldn't load default font.  please check to\n"
				    "make sure the necessary font is installed '%s'\n", defaultFont);
			exit(2);
		}
	}	
	
	    	    	
}
	
void Resource::SizeAndPosition()
{
	XrmValue value;
	char *value_type;
	unsigned int w,h;
	char positionstring[11];

  if (!(bbtool->withdrawn))
  {
  	if (XrmGetResource(resource_db, "bbmail.withdrawn",
		     "Bbmail.Withdrawn", &value_type, &value))
    {
  		if (! strncasecmp("true", value.addr, value.size))
	  		bbtool->withdrawn = True;
	    else
		  	bbtool->withdrawn = False;
  	}	
	  else
		  bbtool->withdrawn = False;
  }

  if (!(bbtool->shape))
  {
  	if (XrmGetResource(resource_db, "bbmail.shape",
		     "Bbmail.Shape", &value_type, &value))
    {
  		if (! strncasecmp("true", value.addr, value.size))
	  		bbtool->shape = True;
	    else
		  	bbtool->shape = False;
  	}	
	  else
		  bbtool->shape = bbtool->withdrawn;
  }

  
	if (!(bbtool->position))
	{
		if (!(XrmGetResource(resource_db, "bbmail.position","Bbmail.Position",
							&value_type, &value)))
			strncpy(positionstring, "-0-0", 5);
		else
			strncpy(positionstring, value.addr, strlen(value.addr)+1);
	}
	else
		strncpy(positionstring, bbtool->position, strlen(bbtool->position)+1);
	
  position.mask=XParseGeometry(positionstring, &position.x, &position.y, &w, &h);
	if (!(position.mask & XValue))
		position.x=0;
	if (!(position.mask & YValue))
		position.y=0;

	/* need this to compute the height */
	const char *defaultFont = "-*-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*";
	
	if (frame.font)
	{
    	XFreeFont(bbtool->getDisplay(), frame.font);
		frame.font = 0;
	}
	
	if (XrmGetResource(resource_db, "bbmail.heightBy.font","Bbmail.heightBy.Font",
						&value_type, &value))
	{
    	if ((frame.font = XLoadQueryFont(bbtool->getDisplay(), value.addr)) == NULL)
		{
    		fprintf(stderr, " blackbox: couldn't load font '%s'\n"
	      					" ...  reverting to default font.", value.addr);
	    	if ((frame.font = XLoadQueryFont(bbtool->getDisplay(), defaultFont)) == NULL)
			{
				fprintf(stderr,"blackbox: couldn't load default font.  please check to\n"
								"make sure the necessary font is installed '%s'\n",
					defaultFont);
				exit(2);
			}
		}
	}
	else if (XrmGetResource(resource_db, BB_FONT,"TitleFont", &value_type, &value))
	{
		if ((frame.font = XLoadQueryFont(bbtool->getDisplay(), value.addr)) == NULL)
		{
    		fprintf(stderr, " blackbox: couldn't load font '%s'\n"
	      					" ...  reverting to default font.", value.addr);
			if ((frame.font = XLoadQueryFont(bbtool->getDisplay(), defaultFont)) == NULL)
			{
				fprintf(stderr,
					"blackbox: couldn't load default font.  please check to\n"
					"make sure the necessary font is installed '%s'\n",
					defaultFont);
				exit(2);
			}
		}
	}
	else 
	{
    	if ((frame.font = XLoadQueryFont(bbtool->getDisplay(), defaultFont)) == NULL)
		{
			fprintf(stderr,
	      			"blackbox: couldn't load default font.  please check to\n"
	      			"make sure the necessary font is installed '%s'\n", defaultFont);
			exit(2);
		}
	}
}
	


void	Resource::MailCheckSettings()
{
	XrmValue value;
	char *value_type;

	
	if (XrmGetResource(resource_db, "bbmail.forceCheck.onDelay",
						"Bbmail.ForceCheck.OnDelay",
						&value_type, &value))
	{
		if (sscanf(value.addr, "%u", &report.check_delay) != 1)
			report.check_delay = 5;
		else if (report.check_delay == 0)
			report.check_delay = 5;
	}
	else
    	report.check_delay = 5;

	if (XrmGetResource(resource_db, "bbmail.force.checkDelay","Bbmail.Force.CheckDelay",
						&value_type, &value))
	{
		if (sscanf(value.addr, "%u", &report.force_check_delay) != 1)
			report.force_check_delay = 60;
		else if (report.check_delay == 0)
			report.force_check_delay = 1;
	}
	else
    	report.force_check_delay = 60;    	

	if (XrmGetResource(resource_db, "bbmail.raised","Bbmail.Raised", &value_type, &value))
	{
		if (! strncasecmp("true", value.addr, value.size))
			bbtool->raised = True;
		else
			bbtool->raised = False;
	}
	else
		bbtool->raised = True;
	
	if (XrmGetResource(resource_db, "bbmail.autoRaise","Bbmail.AutoRaise",
						&value_type, &value))
	{
		if (! strncasecmp("true", value.addr, value.size))
			report.auto_raise = True;
		else
			report.auto_raise = False;
	}
	else
		report.auto_raise = True;

}


void Resource::Label(void)
{
	XrmValue value;
	char *value_type;

	/* text-label resources */
	if (XrmGetResource(resource_db, "bbmail.label.transparent",
		     "Bbmail.label.Transparent", &value_type, &value))
	{
		if (! strncasecmp("true", value.addr, value.size))
			label.transparent = True;
	    else
			label.transparent = False;
	}	
	else
		label.transparent = False;
	
	readTexture("bbmail.label", "Bbmail.Label",BB_LABEL,"Toolbar.Label",
              "slategrey","darkslategrey",
              "Sunken Gradient Vertical Bevel1",&label.texture);

	if (show.newmail_counter)
	{
		readColor("bbmail.newmail.counter.textColor",
      				"Bbmail.Newmail.Counter.TextColor",
               BB_LABEL_TEXTCOLOR, "Toolbar.TextColor",
               "LightGrey",&label.newmail_textColor);

    
		readDatabaseColor("bbmail.newmail.counter.boring.textColor",
		  		            "Bbmail.Newmail.Counter.Boring.TextColor",
         							&label.newmail_boring_textColor);
      if (!label.newmail_boring_textColor.isAllocated())
  			CopyColor(&label.newmail_textColor, &label.newmail_boring_textColor);
	}
	
	if (show.totalmail_counter)
	{
		readColor("bbmail.totalmail.counter.textColor",
      								"Bbmail.TotalMail.Counter.TextColor",
                      BB_LABEL_TEXTCOLOR, "Toolbar.TextColor",
                      "LightGrey",&label.totalmail_textColor);

    readDatabaseColor("bbmail.totalmail.counter.boring.textColor",
		       						"Bbmail.Totalmail.Counter.Boring.TextColor",
						           &label.totalmail_boring_textColor);
    if (!label.totalmail_boring_textColor.isAllocated())
			CopyColor(&label.totalmail_textColor, &label.totalmail_boring_textColor);
	}
	
	if (show.newmail_counter & show.totalmail_counter)
	{
		readColor("bbmail.seperator.counter.textColor",
		      		"Bbmail.Seperator.Counter.TextColor",
               BB_LABEL_TEXTCOLOR, "Toolbar.TextColor",
               "LightGrey",&label.seperator_textColor);

      readDatabaseColor("bbmail.seperator.counter.boring.textColor",
  					            "Bbmail.Seperator.Counter.Boring.TextColor",
								        &label.seperator_boring_textColor);
      if (!label.seperator_boring_textColor.isAllocated())
				CopyColor(&label.seperator_textColor, 
                  &label.seperator_boring_textColor);

	}
	const char *defaultFont = "-*-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*";
	
	if (label.font)
	{
		XFreeFont(bbtool->getDisplay(), label.font);
		label.font = 0;
	}
	
	if (XrmGetResource(resource_db, "bbmail.label.font", "Bbmail.Label.Font",
						&value_type, &value))
	{
		if ((label.font = XLoadQueryFont(bbtool->getDisplay(), value.addr)) == NULL)
		{
    	fprintf(stderr, " blackbox: couldn't load font '%s'\n"
	      							" ...  reverting to default font.", value.addr);
		    if ((label.font = XLoadQueryFont(bbtool->getDisplay(), defaultFont)) == NULL)
			{
				fprintf(stderr,
					"blackbox: couldn't load default font.  please check to\n"
					"make sure the necessary font is installed '%s'\n",
					defaultFont);
			exit(2);
			}
		}
	}
	else if  (XrmGetResource(resource_db, BB_FONT, "TitleFont", &value_type, &value))
	{
		if ((label.font = XLoadQueryFont(bbtool->getDisplay(), value.addr)) == NULL)
		{
			fprintf(stderr, " blackbox: couldn't load font '%s'\n"
	      					" ...  reverting to default font.", value.addr);
			if ((label.font = XLoadQueryFont(bbtool->getDisplay(), defaultFont)) == NULL)
			{
				fprintf(stderr,
					"blackbox: couldn't load default font.  please check to\n"
					"make sure the necessary font is installed '%s'\n",
					defaultFont);
				exit(2);
			}
		}
	}
	else
	{
		if ((label.font = XLoadQueryFont(bbtool->getDisplay(), defaultFont)) == NULL)
		{
			fprintf(stderr,"blackbox: couldn't load default font.  please check to\n"
				    "make sure the necessary font is installed '%s'\n", defaultFont);
			exit(2);
		}
	}
}


void Resource::Show()
{
	XrmValue value;
	char *value_type;

  if (XrmGetResource(resource_db, "bbmail.numberOf.digits",
						     "Bbmail.numberOf.digits", &value_type, &value))
	{				
			if (sscanf(value.addr, "%u", &report.number_of_digits) != 1)
				report.number_of_digits = 2;
      else if (report.number_of_digits==0)
        report.number_of_digits=1;
        
	}
	else
   			report.number_of_digits = 2;

	/* what to show.resources */
	if (XrmGetResource(resource_db, "bbmail.show.newmail.counter",
					     "Bbmail.Display.Newmail.Counter", &value_type, &value))
	{
		if (! strncasecmp("true", value.addr, value.size))
			show.newmail_counter = True;
		else
			show.newmail_counter = False;
	}
	else
		show.newmail_counter = True;

	if (XrmGetResource(resource_db, "bbmail.show.totalmail.counter",
		     			"Bbmail.Display.Totalmail.Counter", &value_type, &value))
	{
		if (! strncasecmp("true", value.addr, value.size))
			show.totalmail_counter = True;
		else
			show.totalmail_counter = False;
	}
	else
		show.totalmail_counter = True;

	if (!( (show.totalmail_counter) | (show.newmail_counter))) show.label=False;
	else show.label=True;

	if (XrmGetResource(resource_db, "bbmail.show.envelope", "Bbmail.Display.Envelope",
						&value_type, &value))
	{
		if (! strncasecmp("true", value.addr, value.size)) show.envelope = True;
		else show.envelope = False;
	}
	else show.envelope = True;

	if (XrmGetResource(resource_db, "bbmail.show.onlyAtnewmail",
					     "Bbmail.Display.OnlyAtNewmail", &value_type, &value))
	{
		if (! strncasecmp("false", value.addr, value.size))
			show.onlyAtNewMail = False;
		else
			show.onlyAtNewMail = True;
	}
	else
		show.onlyAtNewMail = False;

	if (XrmGetResource(resource_db,"bbmail.pressed.runCommand","Bbmail.Pressed.RunCommand",
						&value_type, &value))
	{
		int len = strlen(value.addr);
		delete [] report.runCommand;
		report.runCommand = new char[len + 2];
		memset(report.runCommand, 0, len + 2);
		strncpy(report.runCommand, value.addr, len);
		if (value.addr[len-1]!='&')
		{
			report.runCommand[len]='&';
			report.runCommand[len+1]='\0';
		}
	}
	else
		report.runCommand=NULL;
}


void Resource::Envelope()
{
	XrmValue value;
	char *value_type;
	
	if (!(show.onlyAtNewMail))
	{
    unsigned long texture;
    texture = (frame.texture.getTexture() & ~(BImage_Raised|BImage_Sunken|
                 BImage_Flat))|BImage_Sunken;

    readDatabaseTexture("bbmail.envelope","Bbmail.Envelope",
                        &envelope.texture);
    if (!envelope.texture.getTexture()) {
      envelope.texture.setTexture(texture);
      CopyColor(frame.texture.getColor(),envelope.texture.getColor());
      CopyColor(frame.texture.getColorTo(),envelope.texture.getColorTo());
    }

    texture = (frame.texture.getTexture() & ~(BImage_Raised|BImage_Sunken|
                 BImage_Flat))|BImage_Flat;

     
    
      readDatabaseTexture("bbmail.envelope.pressed","Bbmail.Envelope.Pressed",
                           &envelope.texture_pressed);
    if (!envelope.texture.getTexture()) {
      envelope.texture_pressed.setTexture(texture);
      CopyColor(frame.texture.getColor(),envelope.texture_pressed.getColor());
      CopyColor(frame.texture.getColorTo(),
                envelope.texture_pressed.getColorTo());
    }

		readColor("bbmail.envelope.textColor","Bbmail.Envelope.TextColor",
				      BB_ENVELOPE_TEXTCOLOR,"Toolbar.TextColor",
              "black",&envelope.textColor);

    readColor("bbmail.envelope.error.textColor",
		    			"Bbmail.Envelope.error.TextColor",
               0,0,"red2",&envelope.error_textColor);

		if (XrmGetResource(resource_db, "bbmail.envelope.bevelWidth",
						     "Bbmail.Envelope.BevelWidth", &value_type, &value))
		{				
			if (sscanf(value.addr, "%u", &envelope.bevelWidth) != 1)
				envelope.bevelWidth = 2;
		}
		else
   			envelope.bevelWidth = 2;

	}
}


void Resource::MailboxDep(void)
{
	XrmValue value;
	char *value_type;
	int i;
	char strname[48];
	char strclass[48];
	bool default_defined=False;

	if (bbtool->spooldir)
	{
		report.number_of_spoolfiles=1;
		delete [] spoolfile;
		spoolfile = new SpoolList[report.number_of_spoolfiles];
		memset(spoolfile,0,
		report.number_of_spoolfiles*sizeof(SpoolList));
		spoolfile[0].LoadFilename(bbtool->spooldir);
		default_defined=True;
	}
	else
	{
		/* read number of spool-files */
		if (XrmGetResource(resource_db, "bbmail.numberOf.mailboxes",
							"bbmail.NumberOf.Mailboxes", &value_type, &value))
		{
  			if (sscanf(value.addr, "%d", &report.number_of_spoolfiles) != 1)
				report.number_of_spoolfiles = 1;
			else
			{
		  	    if (report.number_of_spoolfiles < 0)
					report.number_of_spoolfiles = 0;
				if (report.number_of_spoolfiles > 100)
					report.number_of_spoolfiles = 100;
			}
		}
		else
			report.number_of_spoolfiles = 0;
			
		if (report.number_of_spoolfiles!=0)
		{
			delete [] spoolfile;
			spoolfile = new SpoolList[report.number_of_spoolfiles];
			memset(spoolfile,0,
			report.number_of_spoolfiles*sizeof(SpoolList));
		}
		if ((report.number_of_spoolfiles)==0)
		{
			if (!getenv("MAIL"))
			{
				fprintf(stderr,"\nAborting: No spool filename specified. \n\n");
				fprintf(stderr, "Make sure the enviroment variable MAIL is set\n");
		  		exit(1);
			}
			report.number_of_spoolfiles=1;
			delete [] spoolfile;
			spoolfile = new SpoolList[report.number_of_spoolfiles];
			memset(spoolfile,0,
			report.number_of_spoolfiles*sizeof(SpoolList));
			spoolfile[0].LoadFilename(getenv("MAIL"));
			default_defined=True;
		}
	}
	/* read spool file names */
	for (i=0;i<report.number_of_spoolfiles;i++)
	{
		if (!(default_defined))
		{
			sprintf(strname,"bbmail.mailbox.%d.filename",i+1);
			sprintf(strclass,"Bbmail.Mailbox.%d.Filename",i+1);
			if (XrmGetResource(resource_db,strname,
				     strclass, &value_type, &value)) 
				spoolfile[i].LoadFilename(value.addr);
			else
			  spoolfile[i].filename=NULL;
		}
		/* new mail */
		if (show.envelope)
		{
			sprintf(strname,"bbmail.mailbox.%d.name",i+1);
			sprintf(strclass,"Bbmail.Mailbox.%d.name",i+1);
			if (XrmGetResource(resource_db,strname,
				     strclass, &value_type, &value))
				spoolfile[i].LoadName(value.addr);
			else
			{
				/* change this to default = filename */
				char *dummy = new char [12];
				sprintf(dummy,"mailbox %d",i+1);
				spoolfile[i].LoadName(dummy);
				delete [] dummy;
			}
				
			sprintf(strname,"bbmail.mailbox.%d.newmail",i+1);
			sprintf(strclass,"Bbmail.Mailbox.%d.Newmail",i+1);

			readTexture(strname,strclass,BB_NEWMAIL,"Toolbar.Button",
                          "rgb:c/9/6","rgb:8/6/4",
                          "Raised Gradient Diagonal Bevel1",
                          &spoolfile[i].newmail_texture);
			
			sprintf(strname,"bbmail.mailbox.%d.newmail.pressed",i+1);
			sprintf(strclass,"Bbmail.Mailbox.%d.Newmail.Pressed",i+1);


			readTexture(strname,strclass,BB_NEWMAIL_PRESSED,"Toolbar.Button.Pressed",
                          "rgb:c/9/6","rgb:8/6/4",
                          "Sunken Gradient Diagonal Bevel1",
								          &spoolfile[i].newmail_pressed_texture);

      sprintf(strname,"bbmail.mailbox.%d.newmail.textColor",i+1);
			sprintf(strclass,"Bbmail.Mailbox.%d.Newmail.textColor",i+1);

			  readColor(strname,strclass,BB_ENVELOPE_TEXTCOLOR,"Toolbar.TextColor",
                   "black",&spoolfile[i].newmail_textColor);

        sprintf(strname,"bbmail.mailbox.%d.newmail.error.textColor",i+1);
			sprintf(strclass,"Bbmail.Mailbox.%d.Newmail.Error.textColor",i+1);

			readColor(strname,strclass,0,0,"black",
                &spoolfile[i].newmail_error_textColor);
			
			sprintf(strname,"bbmail.mailbox.%d.newmail.pressed.runCommand",i+1);
			sprintf(strclass,"Bbmail.Mailbox.%d.Newmail.Pressed.RunCommand",i+1);
		
			if (XrmGetResource(resource_db,strname,strclass,&value_type, &value))
				spoolfile[i].LoadrunCommand(value.addr);
			else
			{
				if (report.runCommand!=NULL)
					spoolfile[i].LoadrunCommand(report.runCommand);
				else
					spoolfile[i].runCommand=NULL;
			}
		} /* end envelope resources */

	
		sprintf(strname,"bbmail.mailbox.%d.newmail.statusFlag",i+1);
		sprintf(strclass,"Bbmail.Mailbox.%d.Newmail.StatusFlag",i+1);

		if (XrmGetResource(resource_db,strname,strclass,&value_type, &value))
			spoolfile[i].LoadstatusFlag(value.addr);
		else
		{
			char *status = "Status: R";
			spoolfile[i].LoadstatusFlag(status);
		}

		spoolfile[i].procDefined=False;
		sprintf(strname,"bbmail.mailbox.%d.proc",i+1);
		sprintf(strclass,"Bbmail.Mailbox.%d.proc",i+1);
		if (XrmGetResource(resource_db,strname,strclass, &value_type, &value))
		{
			spoolfile[i].LoadProc(value.addr);
			spoolfile[i].procDefined=True;
			if (spoolfile[i].filename==NULL)
			{
			  report.force_check=True;
			  spoolfile[i].force_check=True;
			}
		}
		else
			spoolfile[i].proc=NULL;


		sprintf(strname,"bbmail.mailbox.%d.reversedProc",i+1);
		sprintf(strclass,"Bbmail.Mailbox.%d.ReversedProc",i+1);
		if (XrmGetResource(resource_db,strname,strclass, &value_type, &value))
		{
			spoolfile[i].LoadreversedProc(value.addr);
			spoolfile[i].procDefined=True;
			if (spoolfile[i].filename==NULL)
			{
			  report.force_check=True;
			  spoolfile[i].force_check=True;
			}			
	  	}
		else
			spoolfile[i].reversedProc=NULL;

		sprintf(strname,"bbmail.mailbox.%d.newmail.runCommand",i+1);
		sprintf(strclass,"Bbmail.Mailbox.%d.newmail.RunCommand",i+1);
		if (XrmGetResource(resource_db,strname,strclass, &value_type, &value))
		{
			spoolfile[i].LoadnewmailProc(value.addr);
	  	}
		else
			spoolfile[i].newmailProc=NULL;
			
		sprintf(strname,"bbmail.mailbox.%d.newmail.bell",i+1);
		sprintf(strclass,"Bbmail.Mailbox.%d.newmail.Bell",i+1);	
		if (XrmGetResource(resource_db,strname,strclass, &value_type, &value))
		{
			if (! strncasecmp("false", value.addr, value.size))
				spoolfile[i].bell = False;
			else
				spoolfile[i].bell = True;
		}
		else
		  spoolfile[i].bell = True;

		sprintf(strname,"bbmail.mailbox.%d.mode",i+1);
		sprintf(strclass,"Bbmail.Mailbox.%d.Mode",i+1);	
		if (XrmGetResource(resource_db,strname,strclass, &value_type, &value))
		{
			if (! strncasecmp("2", value.addr, value.size)) {
				spoolfile[i].first_is_new = True;
      	spoolfile[i].second_is_total = False;
      	spoolfile[i].second_ignore = False;
      }
			else if (! strncasecmp("3", value.addr, value.size)) {
				spoolfile[i].first_is_new = False;
       	spoolfile[i].second_is_total = True;
       	spoolfile[i].second_ignore = False;
      }
			else if (! strncasecmp("4", value.addr, value.size)) {
				spoolfile[i].first_is_new = True;
       	spoolfile[i].second_is_total = True;
       	spoolfile[i].second_ignore = True;
      }
      else {
      	spoolfile[i].first_is_new = True;
       	spoolfile[i].second_is_total = True;
       	spoolfile[i].second_ignore = False;
      }
		}
		else {
    	spoolfile[i].first_is_new = True;
     	spoolfile[i].second_is_total = True;
     	spoolfile[i].second_ignore = False;
    }

		if ((spoolfile[i].filename==NULL)&(!spoolfile[i].procDefined))
		{
			fprintf(stderr,"Warning bbmail.mailbox.%d.filename not defined",i+1);
		}
	} /* for */
}
