;;;
;;;  cmail-modes.el - cmail summary and readmail mode definition
;;;
;;;  $Author: iwa $
;;;  created at: Mon Jul 12 10:59:10 JST 1993
;;;
;;;  Copyright (C) 1992-1996 Yukihiro Matsumoto

;; This file is not part of GNU Emacs but obeys its copyright notice.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU Emacs, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.

(provide 'cmail-modes)

;;
;; ++++ $B3F<o%b!<%I@_Dj(B ++++++++++++++++++++++++++++++++++++++++++++++++++
(put 'cmail-summary-mode 'mode-class 'special)
(defvar cmail-summary-mode-map nil)
(defun cmail-summary-mode ()
  "$B%5%^%j!<I=<(;~$K;HMQ$9$k%b!<%I!%(B

$B%-!<%P%$%s%I$O0J2<$NDL$j(B,
\\{cmail-summary-mode-map}"
  (interactive)
  (save-excursion
    (kill-all-local-variables)
    (use-local-map cmail-summary-mode-map)
    (setq mode-name "Summary")
    (setq major-mode 'cmail-summary-mode)
    (setq truncate-lines t)
    (buffer-flush-undo (current-buffer))
    (setq buffer-read-only t)
    (run-hooks 'cmail-summary-mode-hook)))
;;
(defun cmail-describe-mode ()
  (interactive)
  (cmail-select-buffer *cmail-mail-buffer)
  (cmail-select-buffer *cmail-summary-buffer)
  (call-interactively 'describe-mode))

(if cmail-summary-mode-map
    nil
  (setq cmail-summary-mode-map (make-keymap))
  (suppress-keymap cmail-summary-mode-map)
  (define-key cmail-summary-mode-map "h" 'cmail-describe-mode)
  (define-key cmail-summary-mode-map "?" 'cmail-describe-mode)
  (define-key cmail-summary-mode-map "\C-p"
    (if cmail-cursor-fast 'cmail-up-imme 'cmail-go-up))
  (define-key cmail-summary-mode-map "\C-n"
    (if cmail-cursor-fast 'cmail-down-imme 'cmail-go-down))

  (define-key cmail-summary-mode-map "p" 'cmail-previous-mail)
  (define-key cmail-summary-mode-map "n" 'cmail-next-mail)

  (define-key cmail-summary-mode-map "P" 'cmail-previous-unread-mail)
  (define-key cmail-summary-mode-map "N" 'cmail-next-unread-mail)

  (define-key cmail-summary-mode-map "\C-c\C-p" 'cmail-previous-unread-mail)
  (define-key cmail-summary-mode-map "\C-c\C-n" 'cmail-next-unread-mail)

  (define-key cmail-summary-mode-map "t" 'cmail-toggle-header)
  (define-key cmail-summary-mode-map "\C-c\C-r" 'cmail-caesar-message)
  (define-key cmail-summary-mode-map "." 'cmail-show-contents)
  (define-key cmail-summary-mode-map " " 'cmail-read-contents)
  (define-key cmail-summary-mode-map "\C-?" 'cmail-read-reverse)
  (define-key cmail-summary-mode-map "b" 'cmail-read-reverse)
  (define-key cmail-summary-mode-map "\177" 'cmail-read-reverse)
  (define-key cmail-summary-mode-map "\C-m" 'cmail-read-each-line)
  (define-key cmail-summary-mode-map "j" 'cmail-read-each-line)
  (define-key cmail-summary-mode-map "k" 'cmail-read-each-line-backward)
  (define-key cmail-summary-mode-map "<" 'cmail-beginning-of-mail)
  (define-key cmail-summary-mode-map ">" 'cmail-end-of-mail)
  (define-key cmail-summary-mode-map "=" 'cmail-expand-summary-window)
  (define-key cmail-summary-mode-map "l" 'cmail-disp-summary)
  (define-key cmail-summary-mode-map "L" 'cmail-disp-unlimit-summary)
  (define-key cmail-summary-mode-map "d" 'cmail-mark-delete)
  (define-key cmail-summary-mode-map "u" 'cmail-unmark)
  (define-key cmail-summary-mode-map "H" 'cmail-mark-hold)
  (define-key cmail-summary-mode-map "U" 'cmail-mark-unread)
  (define-key cmail-summary-mode-map "\M-u" 'cmail-mark-active)
  (define-key cmail-summary-mode-map "\C-c\C-x" 'cmail-expire-mark)
  (define-key cmail-summary-mode-map "g" 'cmail-summary-get-newmail)
  (define-key cmail-summary-mode-map "\C-ca" 'cmail-add-new-address-from-mail)
  (define-key cmail-summary-mode-map "m" 'cmail-mail-from-summary)
  (define-key cmail-summary-mode-map "a" 'cmail-mail-this-line)
  (define-key cmail-summary-mode-map "z" 'cmail-forward)
  (define-key cmail-summary-mode-map "Z" 'cmail-alt-forward)
  (define-key cmail-summary-mode-map "r" 'cmail-reply)
  (define-key cmail-summary-mode-map "R" 'cmail-reply-include-text)
  (define-key cmail-summary-mode-map "f" 'cmail-followup)
  (define-key cmail-summary-mode-map "F" 'cmail-followup-include-text)
  (define-key cmail-summary-mode-map "B" 'cmail-resend-bounced-mail)
  (define-key cmail-summary-mode-map "@" 'cmail-send-digest)
  (define-key cmail-summary-mode-map "e" 'cmail-edit-index)
  (define-key cmail-summary-mode-map "E" 'cmail-edit)
  (define-key cmail-summary-mode-map "o" 'cmail-save-mail)
  (define-key cmail-summary-mode-map "\C-o" 'cmail-save-mail-as-mbox)
  (define-key cmail-summary-mode-map "|" 'cmail-pipe)
  (define-key cmail-summary-mode-map "^" 'cmail-mark-mail)
  (define-key cmail-summary-mode-map "C" 'cmail-confirm-mark)
  (define-key cmail-summary-mode-map "\M-^" 'cmail-mark-all)
  (define-key cmail-summary-mode-map "\M-m" 'cmail-move-to-folder)
  (define-key cmail-summary-mode-map "\M-c" 'cmail-copy-to-folder)
  (define-key cmail-summary-mode-map "c" 'cmail-catch-up-all)
  (define-key cmail-summary-mode-map "%" 'cmail-move-index)
  (define-key cmail-summary-mode-map "i" 'cmail-move-index)
  (define-key cmail-summary-mode-map "G" 'cmail-goto-index)
  (define-key cmail-summary-mode-map "\M-`" 'cmail-goto-index)
  (define-key cmail-summary-mode-map "x" 'cmail-execute-index)
  (define-key cmail-summary-mode-map "X" 'cmail-confirm-execute)
  (define-key cmail-summary-mode-map "\M-o" 'cmail-reorder-folder)
  (define-key cmail-summary-mode-map "\M-l" 'cmail-summary-limit)
  (define-key cmail-summary-mode-map "\M-f" 'cmail-visit-folder)
  (define-key cmail-summary-mode-map "v" 'cmail-visit-folder)
  (define-key cmail-summary-mode-map "V" 'cmail-visit-saving-folder)
  (define-key cmail-summary-mode-map "/" 'cmail-mark-specified-mails)
  (define-key cmail-summary-mode-map "*" 'cmail-burst-digest)
  (define-key cmail-summary-mode-map "\M-r" 'cmail-remake-folder-headings)
  (define-key cmail-summary-mode-map "\M-d" 'cmail-diet-folder)
  (define-key cmail-summary-mode-map "\M-y" 'cmail-copy-folder)
  (define-key cmail-summary-mode-map "\M-n" 'cmail-rename-folder)
  (define-key cmail-summary-mode-map "\M-k" 'cmail-kill-folder)
  (define-key cmail-summary-mode-map "\M-tr" 'cmail-r2c)
  (define-key cmail-summary-mode-map "\M-tm" 'cmail-m2c)
  (define-key cmail-summary-mode-map "\M-tc" 'cmail-c2m)
  (if (fboundp 'menu:select-from-menu)
      (define-key cmail-summary-mode-map "\M-s" 'cmail-sort-index))
  (define-key cmail-summary-mode-map "\C-c\C-sn" 'cmail-sort-by-number)
  (define-key cmail-summary-mode-map "\C-c\C-s\C-n" 'cmail-sort-by-number)
  (define-key cmail-summary-mode-map "\C-c\C-ss" 'cmail-sort-by-subject)
  (define-key cmail-summary-mode-map "\C-c\C-s\C-s" 'cmail-sort-by-subject-relative)
  (define-key cmail-summary-mode-map "\C-c\C-sd" 'cmail-sort-by-date)
  (define-key cmail-summary-mode-map "\C-c\C-s\C-d" 'cmail-sort-by-time)
  (define-key cmail-summary-mode-map "\C-c\C-sa" 'cmail-sort-by-author)
  (define-key cmail-summary-mode-map "\C-c\C-s\C-a" 'cmail-sort-by-author)
  (define-key cmail-summary-mode-map "\C-c\C-sb" 'cmail-sort-by-bytes)
  (define-key cmail-summary-mode-map "\C-c\C-s\C-b" 'cmail-sort-by-bytes)
  (define-key cmail-summary-mode-map "s" 'cmail-summary-isearch-article)
  (define-key cmail-summary-mode-map "\C-cs" 'cmail-summary-search-article-forward)
  (define-key cmail-summary-mode-map "\C-cr" 'cmail-summary-search-article-backward)
  (define-key cmail-summary-mode-map "\C-cw" 'cmail-stop-page-breaking)
  (define-key cmail-summary-mode-map "\M-p" 'cmail-print)
  (define-key cmail-summary-mode-map "S" 'cmail-saving-folder)
  (define-key cmail-summary-mode-map "W" 'cmail-name-and-address)
  (define-key cmail-summary-mode-map "w" 'cmail-save-folder)
  (define-key cmail-summary-mode-map "\M-w" 'cmail-save-all-folders)
  (define-key cmail-summary-mode-map "\C-x\C-s" 'cmail-save-folder)
  (define-key cmail-summary-mode-map "\C-x\C-w" 'cmail-save-folder)
  (define-key cmail-summary-mode-map "\C-c\C-v" 'cmail-version)
  (define-key cmail-summary-mode-map "\C-c^" 'cmail-mark-thread)
  (define-key cmail-summary-mode-map "\C-cd" 'cmail-th-mark-delete)
  (define-key cmail-summary-mode-map "\C-cp" 'cmail-refer-parent-article)
  (define-key cmail-summary-mode-map "\C-t" 'cmail-toggle-thread)
  (define-key cmail-summary-mode-map "\C-cmt" 'cmail-toggle-mime-forwarding)
  (define-key cmail-summary-mode-map "\C-cmm" 'cmail-draft-list)
  (define-key cmail-summary-mode-map "\C-c\C-fr" 'cmail-reply-ignore-reply-to)
  (define-key cmail-summary-mode-map "\C-c\C-fR" 'cmail-reply-include-text-ignore-reply-to)
  (define-key cmail-summary-mode-map "\C-c\C-ff" 'cmail-followup-ignore-reply-to)
  (define-key cmail-summary-mode-map "\C-c\C-fF" 'cmail-followup-include-text-ignore-reply-to)
  (define-key cmail-summary-mode-map "Q" 'cmail-close-folder)
  (define-key cmail-summary-mode-map "A" 'cmail-auto-archive)
  (define-key cmail-summary-mode-map "\M-a" 'cmail-auto-archive-all)
  (define-key cmail-summary-mode-map "\C-cf" 'cmail-folders)
  (define-key cmail-summary-mode-map "q" 'cmail-summary-quit)
  (if cmail-always-display-folders
      (define-key cmail-summary-mode-map "\C-i" 'cmail-summary-to-folders)))
;;
(put 'cmail-readmail-mode 'mode-class 'special)
(defvar cmail-readmail-mode-map nil)
(defun cmail-readmail-mode ()
  "$B%a%$%kI=<(;~$K;HMQ$9$k%b!<%I!%(B

$B%-!<%P%$%s%I$O0J2<$NDL$j(B,
\\{cmail-readmail-mode-map}"
  (interactive)
  (save-excursion
    (kill-all-local-variables)
    (use-local-map cmail-readmail-mode-map)
    (setq mode-name "Readmail")
    (setq major-mode 'cmail-readmail-mode)
    (make-local-variable 'truncate-partial-width-windows)
    (setq truncate-partial-width-windows nil)
    (setq truncate-lines nil)
    (cmail-narrow-to-page)
    (buffer-flush-undo (current-buffer))
    (setq buffer-read-only t)
    (run-hooks 'cmail-readmail-mode-hook)))
;;
(if cmail-readmail-mode-map
    nil
  (setq cmail-readmail-mode-map (make-keymap))
  (suppress-keymap cmail-readmail-mode-map)
  (define-key cmail-readmail-mode-map " " 'cmail-go-summary)
  (define-key cmail-readmail-mode-map "\C-m" 'cmail-go-summary)
  (define-key cmail-readmail-mode-map "s" 'cmail-go-summary)
  (define-key cmail-readmail-mode-map "g" 'cmail-summary-get-newmail)
  (define-key cmail-readmail-mode-map "v" 'cmail-visit-folder)
  (define-key cmail-readmail-mode-map "w" 'widen)
  (define-key cmail-readmail-mode-map "r" 'cmail-refer-article)
  (define-key cmail-readmail-mode-map "\M-f" 'cmail-visit-folder))

;;
(defun cmail-folder-mode ()
  "$B%a%$%k%U%)%k%@%P%C%U%!$N%b!<%I(B($B%@%_!<(B)$B!%(B"
  (interactive)
  (save-excursion
    (kill-all-local-variables)
    (setq mode-name "cmail folder")
    (setq major-mode 'cmail-folder-mode)))
;;
(require 'derived)
(require 'sendmail)
(fset 'original-mail-mode (symbol-function 'mail-mode))
(define-derived-mode cmail-mail-mode original-mail-mode "Mail"
  "A mail mode for cmail derived from mail-mode."
  (if cmail-use-X-Nsubject
      (define-key cmail-mail-mode-map "\C-c\C-f\C-n" 'cmail-mail-x-nsubject))
  (define-key cmail-mail-mode-map "\C-c\C-y" 'cmail-yank-original)
  (define-key cmail-mail-mode-map "\C-c\C-s" 'cmail-send)
  (define-key cmail-mail-mode-map "\C-c\C-c" 'cmail-send-and-exit)
  (define-key cmail-mail-mode-map "\C-i" 'cmail-complete-address-or-tab)
  (define-key cmail-mail-mode-map "\C-c\C-r" 'cmail-caesar-region)
  (define-key cmail-mail-mode-map "\C-xk" 'cmail-mail-kill-buffer))
;; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
