/*
** Copyright 1998 - 1999 Double Precision, Inc.
** See COPYING for distribution information.
*/

#if	HAVE_CONFIG_H
#include	"config.h"
#endif

#include	<stdlib.h>
#include	<string.h>
#include	<ctype.h>
#include	"searchinfo.h"
#include	"imapwrite.h"
#include	"imaptoken.h"

static const char rcsid[]="$Id: searchinfo.c,v 1.3 1999/12/06 13:33:00 mrsam Exp $";


static struct searchinfo *alloc_search(
	struct searchinfo **head)
{
struct searchinfo *si=(struct searchinfo *)malloc(sizeof(**head));

	if (si == 0)	write_error_exit(0);
	memset(si, 0, sizeof(*si));
	si->next= *head;
	*head=si;
	return (si);
}

void free_search(struct searchinfo *si)
{
struct searchinfo *p;

	while (si)
	{
		p=si->next;
		if (si->as)	free(si->as);
		if (si->bs)	free(si->bs);

		if (si->sei.r)	free(si->sei.r);
		free(si);
		si=p;
	}
}

static struct searchinfo *alloc_search_andlist(struct searchinfo **);
static struct searchinfo *alloc_search_notkey(struct searchinfo **);
static struct searchinfo *alloc_search_key(struct searchinfo **);

struct searchinfo *alloc_parsesearch(struct searchinfo **head)
{
struct	searchinfo *si;

	*head=0;
	if ((si=alloc_search_andlist(head)) == 0)
	{
		free_search(*head);
		return (0);
	}
	return (si);
}

static struct searchinfo *alloc_search_andlist(struct searchinfo **head)
{
struct searchinfo *si, *a, *b;
struct imaptoken *t;

	si=alloc_search_notkey(head);
	if (!si)	return (0);
	while ((t=currenttoken())->tokentype != IT_RPAREN && t->tokentype !=
		IT_EOL)
	{
		if ((a=alloc_search_notkey(head)) == 0)	return (0);
		b=alloc_search(head);
		b->type=search_and;
		b->a=si;
		b->b=a;
		si=b;
	}
	return (si);
}

static struct searchinfo *alloc_search_notkey(struct searchinfo **head)
{
struct imaptoken *t=currenttoken();

	if (t->tokentype == IT_ATOM && strcmp(t->tokenbuf, "NOT") == 0)
	{
	struct searchinfo *si=alloc_search(head);

		si->type=search_not;
		nexttoken();
		if ((si->a=alloc_search_key(head)) == 0)
			return (0);
		return (si);
	}
	return (alloc_search_key(head));
}

/* Additional initalization for search keys that will search msg contents */

static void init_search(struct searchinfo *si, char *s)
{
unsigned i, j, *r;

	for (i=0; s[i]; i++)
		s[i]=toupper((int)(unsigned char)s[i]);

	si->sei.string=s;
	si->sei.i=0;
	if ((si->sei.r=r=(unsigned *)malloc(sizeof(unsigned)*strlen(s))) == 0)
		write_error_exit(0);

	for (i=0; s[i]; i++)
		r[i]=0;

	for (i=0; s[i]; i++)
		for (j=0; s[i+j]; j++)
			if (s[j] != s[i+j])
			{
				if (r[i+j] < j)
					r[i+j]=j;
				break;
			}
}

static struct searchinfo *alloc_search_key(struct searchinfo **head)
{
struct imaptoken *t=currenttoken();
struct searchinfo *si;
const char *keyword;

	if (t->tokentype == IT_LPAREN)
	{
		nexttoken();
		if ((si=alloc_search_andlist(head)) == 0 ||
			currenttoken()->tokentype != IT_RPAREN)
			return (0);
		nexttoken();
		return (si);
	}

	if (t->tokentype != IT_ATOM && t->tokentype != IT_NUMBER)
		return (0);

	keyword=t->tokenbuf;

	if (strcmp(keyword, "ALL") == 0)
	{
	struct searchinfo *si;

		(si=alloc_search(head))->type=search_all;
		nexttoken();
		return (si);
	}

	if (strcmp(keyword, "OR") == 0)
	{
	struct searchinfo *si;

		si=alloc_search(head);
		si->type=search_or;
		nexttoken();
		if ((si->a=alloc_search_notkey(head)) == 0 ||
			(si->b=alloc_search_notkey(head)) == 0)	return (0);
		return (si);
	}

	if (strcmp(keyword, "HEADER") == 0)
	{
	struct imaptoken *t;
	struct searchinfo *si;
	char	*p;

		si=alloc_search(head);
		si->type=search_header;
		t=nexttoken();
		if (t->tokentype != IT_ATOM && t->tokentype != IT_QUOTED_STRING)
			return (0);
		si->as=my_strdup(t->tokenbuf);
		for (p=si->as; *p; p++)
			*p=toupper((int)(unsigned char)*p);
		t=nexttoken();
		if (t->tokentype != IT_ATOM && t->tokentype != IT_QUOTED_STRING)
			return (0);
		si->bs=my_strdup(t->tokenbuf);
		nexttoken();
		init_search(si, si->bs);
		return (si);
	}

	if (strcmp(keyword, "BCC") == 0 ||
		strcmp(keyword, "CC") == 0 ||
		strcmp(keyword, "FROM") == 0 ||
		strcmp(keyword, "TO") == 0 ||
		strcmp(keyword, "SUBJECT") == 0)
	{
	struct imaptoken *t;
	struct searchinfo *si;

		si=alloc_search(head);
		si->type=search_header;
		si->as=my_strdup(keyword);
		t=nexttoken();
		if (t->tokentype != IT_ATOM && t->tokentype != IT_QUOTED_STRING)
			return (0);
		si->bs=my_strdup(t->tokenbuf);
		nexttoken();
		init_search(si, si->bs);
		return (si);
	}

	if (strcmp(keyword, "BEFORE") == 0)
	{
	struct imaptoken *t;
	struct searchinfo *si;

		si=alloc_search(head);
		si->type=search_before;
		t=nexttoken();
		if (t->tokentype != IT_ATOM && t->tokentype != IT_QUOTED_STRING)
			return (0);
		si->as=my_strdup(t->tokenbuf);
		nexttoken();
		return (si);
	}

	if (strcmp(keyword, "BODY") == 0)
	{
	struct imaptoken *t;
	struct searchinfo *si;

		si=alloc_search(head);
		si->type=search_body;
		t=nexttoken();
		if (t->tokentype != IT_ATOM && t->tokentype != IT_QUOTED_STRING)
			return (0);
		si->as=my_strdup(t->tokenbuf);
		nexttoken();
		init_search(si, si->as);
		return (si);
	}
	if (strcmp(keyword, "LARGER") == 0)
	{
	struct imaptoken *t;
	struct searchinfo *si;

		si=alloc_search(head);
		si->type=search_larger;
		t=nexttoken();
		if (t->tokentype != IT_NUMBER)
			return (0);
		si->as=my_strdup(t->tokenbuf);
		nexttoken();
		return (si);
	}

	if (strcmp(keyword, "ON") == 0)
	{
	struct imaptoken *t;
	struct searchinfo *si;

		si=alloc_search(head);
		si->type=search_on;
		t=nexttoken();
		if (t->tokentype != IT_ATOM && t->tokentype != IT_QUOTED_STRING)
			return (0);
		si->as=my_strdup(t->tokenbuf);
		nexttoken();
		return (si);
	}

	if (strcmp(keyword, "SENTBEFORE") == 0)
	{
	struct imaptoken *t;
	struct searchinfo *si;

		si=alloc_search(head);
		si->type=search_sentbefore;
		t=nexttoken();
		if (t->tokentype != IT_ATOM && t->tokentype != IT_QUOTED_STRING)
			return (0);
		si->as=my_strdup(t->tokenbuf);
		nexttoken();
		return (si);
	}

	if (strcmp(keyword, "SENTON") == 0)
	{
	struct imaptoken *t;
	struct searchinfo *si;

		si=alloc_search(head);
		si->type=search_senton;
		t=nexttoken();
		if (t->tokentype != IT_ATOM && t->tokentype != IT_QUOTED_STRING)
			return (0);
		si->as=my_strdup(keyword);
		nexttoken();
		return (si);
	}

	if (strcmp(keyword, "SENTSINCE") == 0)
	{
	struct imaptoken *t;
	struct searchinfo *si;

		si=alloc_search(head);
		si->type=search_sentsince;
		t=nexttoken();
		if (t->tokentype != IT_ATOM && t->tokentype != IT_QUOTED_STRING)
			return (0);
		si->as=my_strdup(t->tokenbuf);
		nexttoken();
		return (si);
	}

	if (strcmp(keyword, "SINCE") == 0)
	{
	struct imaptoken *t;
	struct searchinfo *si;

		si=alloc_search(head);
		si->type=search_since;
		t=nexttoken();
		if (t->tokentype != IT_ATOM && t->tokentype != IT_QUOTED_STRING)
			return (0);
		si->as=my_strdup(t->tokenbuf);
		nexttoken();
		return (si);
	}

	if (strcmp(keyword, "SMALLER") == 0)
	{
	struct imaptoken *t;
	struct searchinfo *si;

		si=alloc_search(head);
		si->type=search_smaller;
		t=nexttoken();
		if (t->tokentype != IT_NUMBER)
			return (0);
		si->as=my_strdup(t->tokenbuf);
		nexttoken();
		return (si);
	}

	if (strcmp(keyword, "TEXT") == 0)
	{
	struct imaptoken *t;
	struct searchinfo *si;

		si=alloc_search(head);
		si->type=search_text;
		t=nexttoken();
		if (t->tokentype != IT_ATOM && t->tokentype != IT_QUOTED_STRING)
			return (0);
		si->as=my_strdup(t->tokenbuf);
		nexttoken();
		init_search(si, si->as);
		return (si);
	}

	if (strcmp(keyword, "UID") == 0)
	{
	struct searchinfo *si;
	struct imaptoken *t;

		si=alloc_search(head);
		si->type=search_uid;
		t=nexttoken();
		if (!ismsgset(t))
			return (0);
		si->as=my_strdup(t->tokenbuf);
		nexttoken();
		return (si);
	}

	if (strcmp(keyword, "KEYWORD") == 0
		|| strcmp(keyword, "UNKEYWORD") == 0)
	{
	int	isnot= *keyword == 'U';
	struct imaptoken *t;
	struct searchinfo *si;

		si=alloc_search(head);
		si->type=search_keyword;
		t=nexttoken();
		if (t->tokentype != IT_ATOM && t->tokentype != IT_QUOTED_STRING)
			return (0);
		si->as=my_strdup(t->tokenbuf);
		nexttoken();

		if (isnot)
		{
		struct searchinfo *si2=alloc_search(head);

			si2->type=search_not;
			si2->a=si;
			si=si2;
		}
		return (si);
	}
	if (strcmp(keyword, "ANSWERED") == 0 ||
		strcmp(keyword, "DELETED") == 0 ||
		strcmp(keyword, "DRAFT") == 0 ||
		strcmp(keyword, "FLAGGED") == 0 ||
		strcmp(keyword, "RECENT") == 0 ||
		strcmp(keyword, "SEEN") == 0)
	{
	struct searchinfo *si;

		si=alloc_search(head);
		si->type=search_keyword;
		if ((si->as=malloc(strlen(keyword)+2)) == 0)
			write_error_exit(0);
		si->as[0]='\\';
		strcpy(si->as+1, keyword);
		nexttoken();
		return (si);
	}

	if (strcmp(keyword, "UNANSWERED") == 0 ||
		strcmp(keyword, "UNDELETED") == 0 ||
		strcmp(keyword, "UNDRAFT") == 0 ||
		strcmp(keyword, "UNFLAGGED") == 0 ||
		strcmp(keyword, "UNSEEN") == 0)
	{
	struct searchinfo *si;
	struct searchinfo *si2;

		si=alloc_search(head);
		si->type=search_keyword;
		if ((si->as=malloc(strlen(keyword))) == 0)
			write_error_exit(0);
		si->as[0]='\\';
		strcpy(si->as+1, keyword+2);
		nexttoken();

		si2=alloc_search(head);
		si2->type=search_not;
		si2->a=si;
		return (si2);
	}

	if (strcmp(keyword, "NEW") == 0)
	{
	struct searchinfo *si, *si2;

		si=alloc_search(head);
		si->type=search_and;
		si2=si->a=alloc_search(head);
		si2->type=search_keyword;
		si2->as=my_strdup("\\RECENT");
		si2=si->b=alloc_search(head);
		si2->type=search_not;
		si2=si2->a=alloc_search(head);
		si2->type=search_keyword;
		si2->as=my_strdup("\\SEEN");
		nexttoken();
		return (si);
	}

	if (strcmp(keyword, "OLD") == 0)
	{
	struct searchinfo *si, *si2;

		si=alloc_search(head);
		si->type=search_not;
		si2=si->a=alloc_search(head);
		si2->type=search_keyword;
		si2->as=my_strdup("\\RECENT");
		nexttoken();
		return (si);
	}

	if (ismsgset(t))
	{
		si=alloc_search(head);
		si->type=search_messageset;
		si->as=my_strdup(t->tokenbuf);
		nexttoken();
		return (si);
	}

	return (0);
}

#if 1

void debug_search(struct searchinfo *si)
{
	if (!si)	return;

	switch (si->type) {
	case search_messageset:
		writes("MESSAGE SET: ");
		writes(si->as);
		return;
	case search_all:
		writes("ALL");
		return;
	case search_keyword:
		writes("KEYWORD \"");
		writeqs(si->as);
		writes("\"");
		return;
	case search_not:
		writes("NOT (");
		debug_search(si->a);
		writes(")");
		return;
	case search_and:
		writes("AND (");
		debug_search(si->a);
		writes(", ");
		debug_search(si->b);
		writes(")");
		return;
	case search_or:
		writes("OR (");
		debug_search(si->a);
		writes(", ");
		debug_search(si->b);
		writes(")");
		return;
	case search_header:
		writes("HEADER \"");
		writeqs(si->as);
		writes("\" \"");
		writeqs(si->bs);
		writes("\"");
		return;
	case search_before:
		writes("BEFORE \"");
		writeqs(si->as);
		writes("\"");
		return;
	case search_body:
		writes("BODY \"");
		writeqs(si->as);
		writes("\"");
		return;
	case search_larger:
		writes("LARGER \"");
		writeqs(si->as);
		writes("\"");
		return;
	case search_on:
		writes("ON \"");
		writeqs(si->as);
		writes("\"");
		return;
	case search_sentbefore:
		writes("SENTBEFORE \"");
		writeqs(si->as);
		writes("\"");
		return;
	case search_senton:
		writes("SENTON \"");
		writeqs(si->as);
		writes("\"");
		return;
	case search_sentsince:
		writes("SENTSINCE \"");
		writeqs(si->as);
		writes("\"");
		return;
	case search_since:
		writes("SINCE \"");
		writeqs(si->as);
		writes("\"");
		return;
	case search_smaller:
		writes("SMALLER \"");
		writeqs(si->as);
		writes("\"");
		return;
	case search_text:
		writes("TEXT \"");
		writeqs(si->as);
		writes("\"");
		return;
	case search_uid:
		writes("UID \"");
		writeqs(si->as);
		writes("\"");
		return;
	}
}

#endif
