case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh
    ;;
esac
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac

echo "Extracting filter/Makefile (with variable substitutions)"
: if mailermode is not 2755 then we dont need the chgrp
: set chgrp to a null command in this case
if test "$mailermode" = 755; then
	chgrp=":"
fi
cat >Makefile <<!GROK!THIS!
#
# @(#)$Id: Makefile.SH,v 1.2.8.1 1999/11/07 17:32:58 hurtta Exp $
#
#  Makefile for the Elm system filter program
#
#         (C) Copyright 1986,1987, by Dave Taylor
#         (C) Copyright 1988-1992, USENET Community Trust
#
#
# Variables
#	Variables established by Configure
CC		=	$cc
CCFLAGS		=	$ccflags $xencf
CHGRP		=	$chgrp
CHMOD		=	$chmod
CP		=	$cp
DEST		=	$bin
ECHO		=	$echo
LFLAGS		=	$ldflags $xenlf
LIB		=	$lib
LIB2		= 	$libs
LIBS		=	$termlib $dbm
LINT		=	$lint
MAILGRP		=	$mailgrp
MAILERMODE	=	$mailermode
MAKE		=	$make
MV		=	$mv
OPTIMIZE	=	$optimize
RM		= 	$rm -f
TOUCH		=	$touch

!GROK!THIS!

cat >>Makefile <<'!NO!SUBS!'
#	Variables you may want to manually edit
#		If you want debug logging then you'll
#		want to uncomment the following.
#DEBUG		=	-DDEBUG

#	Other variables
BIN		=	../bin
INCLDIR		=	../hdrs
CFLAGS		=	-I$(INCLDIR) $(CCFLAGS) $(OPTIMIZE) $(DEBUG) $(DACSNET) 
LINTFLAGS	=	-I$(INCLDIR)
SHELL		=	/bin/sh

# Definitions of variables
FILTER_SRC	=	actions.c	\
			filter.c	\
			lock.c		\
			parse.c		\
			regexp.c	\
			rules.c		\
			summarize.c	\
			utils.c		\
			audit.c

FILTER_OBJ	=	actions.o	\
			filter.o	\
			lock.o		\
			parse.o		\
			regexp.o	\
			rules.o		\
			summarize.o	\
			utils.o		\
			audit.o		

# Standard targets
all:		Makefile $(BIN)/filter
		
install:	Makefile $(DEST)/filter

Makefile: Makefile.SH ../config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

uninstall:	
		$(RM) $(DEST)/filter

lint:		
		$(LINT) $(LINTFLAGS) $(FILTER_SRC) > LINT.OUT

clean:		
		$(RM) $(FILTER_OBJ) $(BIN)/filter

# Dependencies and rules
#	Dependencies of header files upon other header files they include
.PRECIOUS:		$(INCLDIR)/defs.h $(INCLDIR)/elm.h $(INCLDIR)/headers.h

$(INCLDIR)/defs.h:	$(INCLDIR)/../config.h $(INCLDIR)/sysdefs.h
			$(CHMOD) u+w $@
			$(TOUCH) $@

$(INCLDIR)/elm.h:	$(INCLDIR)/curses.h $(INCLDIR)/defs.h
			$(CHMOD) u+w $@
			$(TOUCH) $@

$(INCLDIR)/headers.h:	$(INCLDIR)/curses.h $(INCLDIR)/defs.h
			$(CHMOD) u+w $@
			$(TOUCH) $@

#	Dependencies and rules for C object files
actions.o:		$(INCLDIR)/defs.h $(INCLDIR)/filter.h $(INCLDIR)/s_filter.h $(INCLDIR)/elmlib.h
filter.o:		$(INCLDIR)/defs.h $(INCLDIR)/filter.h $(INCLDIR)/s_filter.h $(INCLDIR)/elmlib.h
lock.o:			$(INCLDIR)/defs.h $(INCLDIR)/filter.h $(INCLDIR)/s_filter.h $(INCLDIR)/elmlib.h
parse.o:		$(INCLDIR)/defs.h $(INCLDIR)/filter.h $(INCLDIR)/s_filter.h $(INCLDIR)/elmlib.h
regexp.o:		$(INCLDIR)/defs.h $(INCLDIR)/regexp.h $(INCLDIR)/elmlib.h
rules.o:		$(INCLDIR)/defs.h $(INCLDIR)/filter.h $(INCLDIR)/s_filter.h $(INCLDIR)/elmlib.h
summarize.o:		$(INCLDIR)/defs.h $(INCLDIR)/filter.h $(INCLDIR)/s_filter.h $(INCLDIR)/elmlib.h
utils.o:		$(INCLDIR)/defs.h $(INCLDIR)/filter.h $(INCLDIR)/s_filter.h $(INCLDIR)/elmlib.h
audit.o:		$(INCLDIR)/defs.h $(INCLDIR)/filter.h $(INCLDIR)/s_filter.h $(INCLDIR)/elmlib.h

#	Dependencies and rules for compiling programs
$(BIN)/filter:	$& $(FILTER_OBJ)
		$(CC) $(LFLAGS) -o $@ $(FILTER_OBJ) ../lib/libutil.a $(LIB2)

#	Dependencies and rules for installing programs from bin directory
$(DEST)/filter:		$(BIN)/filter
			-$(MV) $(DEST)/filter $(DEST)/filter.old
			-$(RM) $(DEST)/filter.old
			$(CP) $? $@
			$(CHGRP) $(MAILGRP) $@
			$(CHMOD) $(MAILERMODE) $@
!NO!SUBS!
