static char rcsid[] = "@(#)$Id: dispaddr.c,v 1.6 1999/03/11 15:06:53 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.6 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *
 *  Initially written by: Michael Elkins <elkins@aero.org>, 1995
 *****************************************************************************/

#include "headers.h"
#include "me.h"

static void addr_to_str P_((char *f, int size, struct addr_item *addr));
static void addr_to_str(f,size,addr)
     char *f; 
     int size; 
     struct addr_item *addr;
{
  struct addr_item *ptr;

  f[0] = '\0';
  for (ptr=addr; ptr && ptr->addr; ptr++) {
    char * t = ptr->fullname;
    if (!t[0])
      t = ptr->addr;
    if (ptr == addr)
      strfcpy(f, t, size);
    else {
      strfcat(f, ", ", size);
      strfcat(f, t, size);
    }
  }
}

int
DisplayAddress (h, f, size, decoder)
     struct header_rec *h;
     char *f;
     int size;
     decode_who decoder;
{
  int i = 0, using_to = 0;
  struct addr_item *p,*ptr;
  int okay_to = 1, okay_cc = 1;

  dprint(9, (debugfile,
	     "DisplayAddress: size=%d, h (header_rec)=%X\n",
	     size,h));
  
  f[0] = '\0';
  
  if (!h->to ||
      !h->to->addr ||
      !h->to->fullname) {
    /* No To: address, must select From: address anyway.... */
    goto was_from;
  }

  for (p = h->from; p && p->addr && p->fullname; p++)
    if (addr_matches_user (p->addr, username) ||
	0 == strincmp(p->fullname, full_username,STRING))
      break;

  for (ptr = h->to; ptr && ptr->addr && ptr->fullname; ptr++)
    if (okay_address_l(ptr, h->from))
      okay_to = 0;

  dprint(9, (debugfile,
	     "DisplayAddress: size=%d, h (header_rec)=%X\n",
	     size,h));


  for (ptr = h->cc; ptr && ptr->addr && ptr->fullname; ptr++)
    if (!okay_address_l(ptr, h->from))
      okay_cc = 0;


  dprint(6, (debugfile,
	     "DisplayAddress: okay_to=%d, okay_cc=%d, I have sender=%s (%s)\n",
	     okay_to,okay_cc, 
	     p && p->addr ? "Yes" : "No", 
	     p && p->addr ? p->addr : ""
	     ));


  if (p && p->addr && p->fullname ||
      addr_matches_user (h->env_from, username)) {
    /* I sent this message.  Use the TO address.  
     * (perhaps I have also receiver... hmm.)
     */
    f[0] = '\0';
    addr_to_str(f,size,h->to);
    if (f[0])
      using_to = TRUE;
  }
  else if (okay_to && okay_cc) {

    /* This message is not addressed to me. */

    if (showto) {
      f[0] = '\0';
      addr_to_str(f,size,h->to);
      if (f[0])
	using_to = TRUE;
      else
	goto was_from;
    } else 
      goto was_from;
      
  }
  else { /* This message is addressed to me (or sender of mail). */
  was_from:
    addr_to_str(f,size,h->from);
    if (f[0] == '\0')
      strfcpy (f, h->env_from, size);
    if (f[0] == '\0' || 0 == strcmp(f,"<>"))
      strfcpy (f, "Mailer Daemon", size);
  }

  dprint(6, (debugfile,
	     "DisplayAddress=%d, f=%s\n",using_to,f));
  return(using_to);
}


