
static char rcsid[] = "@(#)$Id: newalias.c,v 1.4 1998/11/07 14:12:22 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.4 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *
 *****************************************************************************/

/** Install a new set of aliases for the 'Elm' mailer. 

	If invoked without the -g argument, it assumes that
  it is working with an individual users alias tables, and
  generates the .alias.pag and .alias.dir files in their
  .elm directory.
	If, however, it is invoked with the -g flag,
  it assumes that the user is updating the system alias
  file and uses the defaults for everything.

  The format for the input file is;
    alias1, alias2, ... = username = address
or  alias1, alias2, ... = groupname= member, member, member, ...
                                     member, member, member, ...

**/

#include "elmutil.h"
#include "s_newalias.h"
#include "sysdefs.h"		/* ELM system definitions */

void error();

int  is_system=0;		/* system file updating?     */

main(argc, argv)
int argc;
char *argv[];
{
	char inputname[SLEN], dataname[SLEN];
	char home_dir[SLEN];		/* the users home directory  */
	int  a;


	locale_init();
	user_init();
	init_defaults();
	read_rc_file();

	sleepmsg=0;		/* not in elm, dont wait for messages */

	for (a = 1; a < argc; ++a) {
	  if (strcmp(argv[a], "-g") == 0)
	    is_system = 1;
#ifdef DEBUG
	  else if (strcmp(argv[a], "-d") == 0)
	    debug = 10;
#endif
	  else {
	      fprintf(stderr, catgets(elm_msg_cat,
	            NewaliasSet, NewaliasUsage, "Usage: %s [-g]\n"), argv[0]);
	      exit(1);
	  }
	}

	if (is_system) {   /* update system aliases */
	    printf(catgets(elm_msg_cat, NewaliasSet, NewaliasUpdateSystem,
	            "Updating the system alias file..."));

	    strfcpy(inputname, system_text_file, sizeof inputname);
	    strfcpy(dataname,  system_data_file, sizeof dataname);
	}
	else {
	  char *cp = getenv("HOME");
	    printf(catgets(elm_msg_cat, NewaliasSet, NewaliasUpdatePersonal,
		"Updating your personal alias file..."));
	
	    if (cp == NULL) {
	        error(catgets(elm_msg_cat, NewaliasSet, NewaliasNoHOME,
		        "I'm confused - no HOME variable in environment!"));
	        exit(1);
	    }

	    strfcpy(home_dir,cp,sizeof home_dir);

	    strfcpy(inputname, user_text_file,sizeof inputname);
	    strfcpy(dataname, user_data_file,sizeof dataname);
	}

	if ((a = do_newalias(inputname, dataname, FALSE, TRUE)) < 0) {
	    exit(1);
	}
	else {
	    printf(catgets(elm_msg_cat, NewaliasSet, NewaliasProcessed,
	            "processed %d aliases.\n"), a);
	    exit(0);
	}

	/*NOTREACHED*/
}

void
error(err_message)
char *err_message;
{
	fflush(stdout);
	fprintf(stderr, "\n%s\n", err_message);
	return;
}
