/*
** 
** Copyright (C) 1993 Swedish University Network (SUNET)
** 
** 
** This program is developed by UDAC, Uppsala University by commission
** of the Swedish University Network (SUNET). 
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITTNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
** 
** 
**                                           Martin.Wendel@its.uu.se
** 				             Torbjorn.Wictorin@its.uu.se
** 
**                                           ITS	
**                                           P.O. Box 887
**                                           S-751 08 Uppsala
**                                           Sweden
** 
*/
#include "emil.h"


int
init_data(struct data *d)
{
  if (d == NULL)
    return(NOK);
  d->offset = d->bodystart;
  return(OK);
}
long
get_length(struct data *d)
{
  if (d == NULL || d->offset >= d->end)
    return(0);
  else
    return(d->bodyend - d->offset);
}

int
check_length(struct data *d, long l)
{
  if (d == NULL || d->offset >= d->end)
    return(NOK);
  if (d->bodystart + l > d->end)
    return(NOK);
  return(OK);
}

char *
get_string(struct data *d, unsigned long offset, int length)
{
  char *c;
  c = (char *)Yalloc(length + 1);
  bcopy(d->contents + d->bodystart + offset,
	c, length);
  return(c);
}

void
set_type(struct data *d)
{
  if (d != NULL)
    {
      if ((d->type = confextr("APPLEFILE", d->appletype, NULL)) == NULL)
	if ((d->type = confextr("APPLEFILE", "DEFAULT", NULL)) == NULL)
	  d->type = NEWSTR("APPLICATION");
    }
}
