#!/usr/local/bin/perl
#
# Copyright (C) 1993-1997 Ken'ichi Fukamachi
#          All rights reserved. 
#               1993-1996 fukachan@phys.titech.ac.jp
#               1996-1997 fukachan@sapporo.iij.ad.jp
# 
# FML is free software; you can redistribute it and/or modify
# it under the terms of GNU General Public License.
# See the file COPYING for more details.
#
# $Id: euc2jiskuten.pl,v 1.6 1997/08/18 14:07:25 fukachan Exp $;
#


### MAIN ###
&Init;
&Conv;
exit 0;
### MAIN ENDS ###


sub Init
{
    require 'getopts.pl';
    &Getopts("d");

    $debug = 1 if $opt_d;

    &SetConversionTable;
}


sub Conv
{
    while (sysread(STDIN, $_, 1)) { 

	if ($E2jkHash{$_}) {
	    $buf  = $_;
	    $cord = $E2jkHash{$_};
	    $info = "Hash Hit";
	}
	elsif (ord($_) & 0x80) {
	    sysread(STDIN, $n, 1);	# 2 bytes;

	    if ($cord = $E2jkHash{"$_$n"}) {
		$buf   = "${_}${n}";
		$info  = "(Hash ON 0x80)";
	    }
	    else {
		$cord .= sprintf("%02d", (ord($_) & 0x7f) - 0x20);
		$buf  .= $_;
		$cord .= sprintf("%02d", (ord($n) & 0x7f) - 0x20);
		$buf  .= $n;	    
		$info  = "(ON 0x80)";
	    }
	}
	elsif ($_ eq ' ') {
	    $buf .= $_;
	    $cord = '0101';
	}
	elsif ($_ =~ /^[A-Za-z0-9]+$/) {
	    $buf .= $_;
	    $cord = sprintf("03%02d", ( ord($_) - 0x20) );
	    $info = "(1 byte > 0x20)";
	}
	

	if ($debug) {
	    printf "%-5s   \#%-5s\t%s\n", $buf, $cord, $info if $cord;
	}
	else {
	    print "#$cord" if $cord;
	}

	$buf = $info = $cord = "";  
    }

    print "\n";
}


# Automatically Generated based on egg-jsymbol.el
#          by fukachan@sapporo.iij.ad.jp (1997/03/20)
sub SetConversionTable
{
    %E2jkHash = (
		 ########## by egg-jsymbol.el ########## 
		 '', '0101',
		 '', '0102',
		 '', '0103',
		 '', '0104',
		 '', '0105',
		 '', '0106',
		 '', '0107',
		 '', '0108',
		 '', '0109',
		 '', '0110',
		 '', '0111',
		 '', '0112',
		 '', '0113',
		 '', '0114',
		 '', '0115',
		 '', '0116',
		 '', '0117',
		 '', '0118',
		 '', '0119',
		 '', '0120',
		 '', '0121',
		 '', '0122',
		 '', '0123',
		 '', '0124',
		 '', '0125',
		 '', '0126',
		 '', '0127',
		 '', '0128',
		 '', '0129',
		 '', '0130',
		 '', '0131',
		 '', '0132',
		 '', '0133',
		 '', '0134',
		 '', '0135',
		 '', '0136',
		 '', '0137',
		 '', '0138',
		 '', '0139',
		 '', '0140',
		 '', '0141',
		 '', '0142',
		 '', '0143',
		 '', '0144',
		 '', '0145',
		 '', '0146',
		 '', '0147',
		 '', '0148',
		 '', '0149',
		 '', '0150',
		 '', '0151',
		 '', '0152',
		 '', '0153',
		 '', '0154',
		 '', '0155',
		 '', '0156',
		 '', '0157',
		 '', '0158',
		 '', '0159',
		 '', '0160',
		 '', '0161',
		 '', '0162',
		 '', '0163',
		 '', '0164',
		 '', '0165',
		 '', '0166',
		 '', '0167',
		 '', '0168',
		 '', '0169',
		 '', '0170',
		 '', '0171',
		 '', '0172',
		 '', '0173',
		 '', '0174',
		 '', '0175',
		 '', '0176',
		 '', '0177',
		 '', '0178',
		 '', '0179',
		 '', '0180',
		 '', '0181',
		 '', '0182',
		 '', '0183',
		 '', '0184',
		 '', '0185',
		 '', '0186',
		 '', '0187',
		 '', '0188',
		 '', '0189',
		 '', '0190',
		 '', '0191',
		 '', '0192',
		 '', '0193',
		 '', '0194',
		 '', '0201',
		 '', '0202',
		 '', '0203',
		 '', '0204',
		 '', '0205',
		 '', '0206',
		 '', '0207',
		 '', '0208',
		 '', '0209',
		 '', '0210',
		 '', '0211',
		 '', '0212',
		 '', '0213',
		 '', '0214',
		 '', '0226',
		 '', '0227',
		 '', '0228',
		 '', '0229',
		 '', '0230',
		 '', '0231',
		 '', '0232',
		 '', '0233',
		 '', '0242',
		 '', '0243',
		 '', '0244',
		 '', '0245',
		 '', '0246',
		 '', '0247',
		 '', '0248',
		 '', '0260',
		 '', '0261',
		 '', '0262',
		 '', '0263',
		 '', '0264',
		 '', '0265',
		 '', '0266',
		 '', '0267',
		 '', '0268',
		 '', '0269',
		 '', '0270',
		 '', '0271',
		 '', '0272',
		 '', '0273',
		 '', '0274',
		 '', '0282',
		 '', '0283',
		 '', '0284',
		 '', '0285',
		 '', '0286',
		 '', '0287',
		 '', '0288',
		 '', '0289',
		 '', '0294',
		 '', '0316',
		 '', '0317',
		 '', '0318',
		 '', '0319',
		 '', '0320',
		 '', '0321',
		 '', '0322',
		 '', '0323',
		 '', '0324',
		 '', '0325',
		 '', '0333',
		 '', '0334',
		 '', '0335',
		 '', '0336',
		 '', '0337',
		 '', '0338',
		 '', '0339',
		 '', '0340',
		 '', '0341',
		 '', '0342',
		 '', '0343',
		 '', '0344',
		 '', '0345',
		 '', '0346',
		 '', '0347',
		 '', '0348',
		 '', '0349',
		 '', '0350',
		 '', '0351',
		 '', '0352',
		 '', '0353',
		 '', '0354',
		 '', '0355',
		 '', '0356',
		 '', '0357',
		 '', '0358',
		 '', '0365',
		 '', '0366',
		 '', '0367',
		 '', '0368',
		 '', '0369',
		 '', '0370',
		 '', '0371',
		 '', '0372',
		 '', '0373',
		 '', '0374',
		 '', '0375',
		 '', '0376',
		 '', '0377',
		 '', '0378',
		 '', '0379',
		 '', '0380',
		 '', '0381',
		 '', '0382',
		 '', '0383',
		 '', '0384',
		 '', '0385',
		 '', '0386',
		 '', '0387',
		 '', '0388',
		 '', '0389',
		 '', '0390',
		 '', '0601',
		 '', '0602',
		 '', '0603',
		 '', '0604',
		 '', '0605',
		 '', '0606',
		 '', '0607',
		 '', '0608',
		 '', '0609',
		 '', '0610',
		 '', '0611',
		 '', '0612',
		 '', '0613',
		 '', '0614',
		 '', '0615',
		 '', '0616',
		 '', '0617',
		 '', '0618',
		 '', '0619',
		 '', '0620',
		 '', '0621',
		 '', '0622',
		 '', '0623',
		 '', '0624',
		 '', '0633',
		 '', '0634',
		 '', '0635',
		 '', '0636',
		 '', '0637',
		 '', '0638',
		 '', '0639',
		 '', '0640',
		 '', '0641',
		 '', '0642',
		 '', '0643',
		 '', '0644',
		 '', '0645',
		 '', '0646',
		 '', '0647',
		 '', '0648',
		 '', '0649',
		 '', '0650',
		 '', '0651',
		 '', '0652',
		 '', '0653',
		 '', '0654',
		 '', '0655',
		 '', '0656',
		 '', '0701',
		 '', '0702',
		 '', '0703',
		 '', '0704',
		 '', '0705',
		 '', '0706',
		 '', '0707',
		 '', '0708',
		 '', '0709',
		 '', '0710',
		 '', '0711',
		 '', '0712',
		 '', '0713',
		 '', '0714',
		 '', '0715',
		 '', '0716',
		 '', '0717',
		 '', '0718',
		 '', '0719',
		 '', '0720',
		 '', '0721',
		 '', '0722',
		 '', '0723',
		 '', '0724',
		 '', '0725',
		 '', '0726',
		 '', '0727',
		 '', '0728',
		 '', '0729',
		 '', '0730',
		 '', '0731',
		 '', '0732',
		 '', '0733',
		 '', '0749',
		 '', '0750',
		 '', '0751',
		 '', '0752',
		 '', '0753',
		 '', '0754',
		 '', '0755',
		 '', '0756',
		 '', '0757',
		 '', '0758',
		 '', '0759',
		 '', '0760',
		 '', '0761',
		 '', '0762',
		 '', '0763',
		 '', '0764',
		 '', '0765',
		 '', '0766',
		 '', '0767',
		 '', '0768',
		 '', '0769',
		 '', '0770',
		 '', '0771',
		 '', '0772',
		 '', '0773',
		 '', '0774',
		 '', '0775',
		 '', '0776',
		 '', '0777',
		 '', '0778',
		 '', '0779',
		 '', '0780',
		 '', '0781',
		 '', '0801',
		 '', '0802',
		 '', '0803',
		 '', '0804',
		 '', '0805',
		 '', '0806',
		 '', '0807',
		 '', '0808',
		 '', '0809',
		 '', '0810',
		 '', '0811',
		 '', '0812',
		 '', '0813',
		 '', '0814',
		 '', '0815',
		 '', '0816',
		 '', '0817',
		 '', '0818',
		 '', '0819',
		 '', '0820',
		 '', '0821',
		 '', '0822',
		 '', '0823',
		 '', '0824',
		 '', '0825',
		 '', '0826',
		 '', '0827',
		 '', '0828',
		 '', '0829',
		 '', '0830',
		 '', '0831',
		 '', '0832',
		 );
}


1;
