# Copyright (C) 1993-1998 Ken'ichi Fukamachi
#          All rights reserved. 
#               1993-1996 fukachan@phys.titech.ac.jp
#               1996-1998 fukachan@sapporo.iij.ad.jp
# 
# FML is free software; you can redistribute it and/or modify
# it under the terms of GNU General Public License.
# See the file COPYING for more details.
#
# $Id: librcs.pl,v 1.1 1998/08/03 13:18:24 fukachan Exp $
#

sub RCSBackUp
{
    local($f) = @_;
    local($mode);

    &RCSInit;

    if (! $CI) {
	&Log("RCSBackUp: cannot find 'ci'");
	return $NULL;
    }

    &Log("RCSBackUp: $CI -l -q $f 2>&1|") if $debug;

    if (!-f $f) {
	&Log("RCSBackUp: cannot find $f");
	return;
    }

    # preserve mode
    $mode = (stat($f))[2];

    open(CI, "$CI -l -q $f 2>&1|") || 
	&Log("RCSBackUp Error: cannot exec $CI -q $file");
    while (<CI>) {
	chop;
	&Debug("RCSBackUp> $_") if $debug;
	&Log("RCSBackUp: $_") if /error/i;
    }
    close($f);

    # preserve mode
    chmod $mode, $f;
}


sub RCSInit
{
    -d "$DIR/RCS" || &MkDir("$DIR/RCS");

    # no check
    return if $RCS && $CI;

    local(@path) = ('/usr/bin', '/usr/ucb', '/usr/lib',
		    '/usr/local/bin', '/usr/contrib/bin', '/usr/pkg/bin');

    $RCS = $RCS || &SearchPath('rcs', @path);
    $CI  = $CI  || &SearchPath('ci', @path);
}


1;
