/* DSTART                                                                    */
/*                                                                           */
/*           maildrop - mail delivery agent with filtering abilities         */
/*                                                                           */
/*  Copyright 1998-1999, Double Precision Inc.                               */
/*                                                                           */
/*  This program is distributed under the terms of the GNU General Public    */
/*  License. See COPYING for additional information.                         */
/* DEND                                                                      */
#include	"token.h"

static const char rcsid[]="$Id: token.C 1.5 1999/08/02 05:02:26 mrsam Exp $";

static const char *names[]={
		"error",
		"eof",
		"\"...\"",
		"'...'",
		"`...`",
		"=",
		"{",
		"}",
		";",
		"/.../",
                "+",
		"-",
		"*",
		"/",
		"<",
		"<=",
		">",
		">=",
		"==",
		"!=",
		"||",
		"&&",
		"|",
		"&",
		"(",
		")",
		"!",
		"~",
		"lt",
		"le",
		"gt",
		"ge",
		"eq",
		"ne",
		"length",
		"substr",
		",",
		"=~",
		"if",
		"else",
		"while",
		"to",
		"cc",
		"exception",
		"echo",
		"xfilter",
		"dotlock",
		"flock",
		"logfile",
		"log",
		"include",
		"exit",
		"foreach",
		"getaddr",
		"lookup",
		"escape",
		"tolower",
		"toupper",
		"hasaddr",
		"gdbmopen",
		"gdbmclose",
		"gdbmfetch",
		"gdbmstore",
		"time",
		"import"
		} ;

static Buffer namebuf;

const char *Token::Name()
{
	if (type == qstring)
	{
		namebuf="string: \"";
		namebuf += buf;
		namebuf += "\"";
		namebuf.push(0);
		return (namebuf);
	}

	if (type == sqstring)
	{
		namebuf="string: '";
		namebuf += buf;
		namebuf += "'";
		namebuf.push(0);
		return (namebuf);
	}

	if (type == btstring)
	{
		namebuf="string: `";
		namebuf += buf;
		namebuf += "`";
		namebuf.push(0);
		return (namebuf);
	}

	if (type == regexpr)
	{
		namebuf="regexp: ";
		namebuf += buf;
		namebuf.push(0);
		return (namebuf);
	}

unsigned	t=(unsigned)type;

	if (t >= sizeof(names)/sizeof(names[0]))	t=0;
	return (names[t]);
}
