/*
   $@		JIS X0208-1978
   $B,$(B	JIS X0208-1983
   (I		JIS X0201 kana
   (J		JIS X0201 roman
   $(D		JIS X0212-1990  
   (B		ASCII

   $ 36 24    @ 64 40    ( 40 28    B 66 42
   I 73 49    D 68 44
*/

#define MUTT_JED_SLANG 

#include "config.h" /* to know USE_SLANG_CURSES is defined */

#if defined(USE_SLANG_CURSES) && defined(MUTT_JED_SLANG)
#include <slkanji.h>
#define Slang_Display_Code (kSLdisplay_code)
#else
#define    ESC    0x1b
#define    SS2    0x8e

#define JIS  0
#define EUC  1
#define SJIS 2
extern int Slang_Display_Code; /* 0 = JIS, 1 = EUC, 2 = SJIS */
#endif /* MUTT_JED_SLANG */
// extern int Slrn_Editor_Code;

#define	   SI     0x0f
#define	   SO	  0x0e

#define IS_SJIS1(c) (((c) >= 0x81 && (c) <= 0x9f) || ((c) >= 0xe0 && (c) <= 0xef)) /* 2byte ʸΤ */
#define IS_SJIS2(c) ((c) >= 0x40 && (c) <= 0xfc && (c) != 0x7f)
#define IS_SJISH(c) ((c) >= 0xa0 && (c) <= 0xdf)  /* SJIS hankaku katakana */

#define IS_EUC1(x) ((x) >= 0xa1 && (x) <= 0xfe)

#define IS_EUC2(x) IS_EUC1((x))

extern int euc2jis(unsigned char *, unsigned char *, int);
extern int euc2sjis(unsigned char *, unsigned char *, int);
extern int sjis2euc(unsigned char *, unsigned char *, int);
extern int jis2euc(unsigned char *, unsigned char *, int);
extern int jis2int(unsigned char *, unsigned char *, int);

/* slangkanji.cˤ롣ԤƬscanơܸ줫ɤȽ */
extern int kanji_pos(unsigned char *, unsigned char *);

extern int slrn_conv_file(char *, int);
extern void slrn_conv_string(char *, int);

extern void slrn_convert_koi8_r2iso8859_5(unsigned char *);
extern void slrn_convert_utf82int(unsigned char *);

#define JTMP_LEN 4096
extern unsigned char jtmp_str[JTMP_LEN];

extern int Slrn_Use_ISO8859;
extern int Slrn_Detect_SJIS;

extern int Slrn_Japanese_Messages;
extern int Slang_Current_Charset;

extern int recover_jis(unsigned char *, unsigned char *, int);
