/*
 * Copyright (c) 1997,1998 Motonori Nakamura <motonori@econ.kyoto-u.ac.jp>
 * Copyright (c) 1997,1998 WIDE Project
 * Copyright (c) 1997,1998 Kyoto University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by WIDE Project and
 *      its contributors.
 * 4. Neither the name of the Project, the University nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static char *_id_ = "$Id: log.c,v 1.6 1998/01/05 14:12:35 motonori Exp $";
#endif

# include "common.h"
# include "extern.h"

void
init_log()
{
	if (cnf.log_facility < 0)
		return;
	openlog("smtpfeed", LOG_NDELAY|LOG_PID, cnf.log_facility);
}

void
# ifdef __STDC__
log(int level, const char *fmt, ...)
# else
log(level, fmt, va_alist)
int level;
char *fmt;
va_dcl
# endif
{
	char buf[MAXLINE];
	int len;
	VA_LOCAL_DECL

	if (cnf.log_facility == LOG_NONE)
		return;
	buf[0] = '\0';
	if (env.queueid != NULL)
		strncpy(buf, env.queueid, MAXLINE);
	else if (env.envid != NULL)
		strncpy(buf, env.envid, MAXLINE);
	else
		strcpy(buf, "NOID");
	len = strlen(buf);
	if (len >= MAXLINE-2)
		len = 0;
	else {
		strcat(buf, ": ");
		len += 2;
	}

	VA_START(fmt);
	vsnprintf(buf+len, sizeof(buf)-len, fmt, ap);
	VA_END;

	if (cnf.log_facility == LOG_STDERR) {
		fprintf(stderr, "%s\n", buf);
	} else {
		syslog(level, "%s", buf);
	}
}
