/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __ADDRBOOK_H__
#define __ADDRBOOK_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#undef MIN
#undef MAX
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "gtkmanip.h"
#include "globals.h"
#include "parse.h"

#include "about.h"
#include "composer.h"


GtkWidget* create_frmAddrBook (GtkWidget *txtFld);
GtkWidget* create_frmAddrAdd (void);

void on_frmAddrBook_destroy (GtkObject *object, gpointer user_data);

void on_frmAddrBook_show (GtkWidget *widget, gpointer user_data);

void on_mnuAddrBookSave_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_mnuAddrBookAdd_Contact_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_mnuAddrBookDelete_Contact_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_mnuAddrBookClose_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_mnuAddrBookAbout_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_mnuAddrBookHowto_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_clistAddrList_select_row (GtkCList *clist, gint row, gint column, GdkEvent *event, gpointer user_data);

void on_cmdAddrBookAdd_clicked (GtkButton *button, gpointer user_data);

void on_cmdAddrBookDelete_clicked (GtkButton *button, gpointer user_data);

void on_cmdAddrBookSelect_clicked (GtkButton *button, gpointer user_data);

void on_cmdAddrBookCancel_clicked (GtkButton *button, gpointer user_data);

void on_frmAddrAdd_destroy (GtkObject *object, gpointer user_data);

void on_cmdAddrBookAddOK_clicked (GtkButton *button, gpointer user_data);

void on_cmdAddrBookAddCancel_clicked (GtkButton *button, gpointer user_data);

gint read_addrbook(void);

gint write_addrbook(void);

gchar* get_addrbook_path(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
