/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "date.h"

gint get_days_in_month (gint mon, gint year)
{
   switch (mon)
   {
      case 1: case 3: case 5: case 7: case 8: case 10: case 12:
         return 31;
      case 4: case 6: case 9: case 11:
         return 30;
      case 2:
         if ((year % 4 == 0 && year % 100 != 0) || year % 400 == 0)
            return 29;
         return 28;
      default:
         return 30;
   }
}

gint get_weekday (gchar *str)
{
   g_return_val_if_fail (str != NULL, 0);

   if (strncmp (str, "Mon", 3) == 0) {
      return 1;
   } else if (strncmp (str, "Tue", 3) == 0) {
      return 2;
   } else if (strncmp (str, "Wed", 3) == 0) {
      return 3;
   } else if (strncmp (str, "Thu", 3) == 0) {
      return 4;
   } else if (strncmp (str, "Fri", 3) == 0) {
      return 5;
   } else if (strncmp (str, "Sat", 3) == 0) {
      return 6;
   } else if (strncmp (str, "Sun", 3) == 0) {
      return 7;
   }

   return 0;  /* unknown week day */
}

gint get_month (gchar *str)
{
    g_return_val_if_fail (str != NULL, 0);
    
    if (strncmp (str, "Jan", 3) == 0) {
        return 1;
    } else if (strncmp (str, "Feb", 3) == 0) {
        return 2;
    } else if (strncmp (str, "Mar", 3) == 0) {
        return 3;
    } else if (strncmp (str, "Apr", 3) == 0) {
        return 4;
    } else if (strncmp (str, "May", 3) == 0) {
        return 5;
    } else if (strncmp (str, "Jun", 3) == 0) {
        return 6;
    } else if (strncmp (str, "Jul", 3) == 0) {
        return 7;
    } else if (strncmp (str, "Aug", 3) == 0) {
        return 8;
    } else if (strncmp (str, "Sep", 3) == 0) {
        return 9;
    } else if (strncmp (str, "Oct", 3) == 0) {
        return 10;
    } else if (strncmp (str, "Nov", 3) == 0) {
        return 11;
    } else if (strncmp (str, "Dec", 3) == 0) {
        return 12;
    }
    
    return 0;  /* unknown month */
}

date_t parse_date (gchar *datestr)
{
   date_t date;
   gchar month[6], tzone[6];
   gdouble tz;

   memset((void*)&date, 0, sizeof(date_t));
   g_return_val_if_fail (datestr != NULL, date);

   if (get_weekday(datestr)) /* sometimes we have a week day... */
   {
      strncpy(date.dow, datestr, 3);
      datestr += 3;
      if (*datestr == ',')
         datestr++;
      datestr++;
   }
   else
   {
      if (strchr(datestr, ','))  /* perhaps the week day is in a foreign language... */
         datestr += 5;
   }

   sscanf (datestr, "%d %3s %d %d:%d:%d %5s", &date.day, month, &date.year,
           &date.hour, &date.min, &date.sec, tzone);

   date.mon = get_month (month);
    
   tz = atoi (tzone) / 100.0;

   /* forget the whole time zone thing for now... */
   /*date.min -= (gint)(tz - (gint) tz) * 100;
   if (date.min > 59)
   {
      date.min -= 60;
      date.hour++;
   }
   else
      if (date.min < 0)
      {
         date.min += 60;
         date.hour--;
      }
    
   date.hour -= (gint)tz;
   if (date.hour > 23)
   {
      date.hour -= 24;
      date.day++;
   }
   else
      if (date.hour < 0)
      {
         date.hour += 24;
         date.day++;
      }
    
   if (date.day > get_days_in_month (date.mon, date.year))
   {
      date.day -= get_days_in_month (date.mon, date.year);
      date.mon++;
   }
   else
      if (date.day < 0)
      {
         date.day += get_days_in_month (date.mon, date.year);
         date.mon--;
      }
    
   if (date.mon > 11)
   {
      date.mon -= 12;
      date.year++;
   }
   else
      if (date.mon < 0)
      {
         date.mon += 12;
         date.year--;
      }*/
    
   return date;
}

gchar* print_date (struct tm* date)
{
   gchar* newdate;

   g_return_val_if_fail (date != NULL, NULL);

   newdate = g_new (gchar, 100);

   strftime (newdate, 100, "%a, %d %b %Y %H:%M:%S %z", date);

   return newdate;
}
