/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "main.h"
#include "gti.h"
#include "msgid.h"

gchar spruce_ver[] = "0.5.9";

/* lets keep track of open windows... */
extern gboolean AboutOpen;
extern gboolean AccountsOpen;
extern gboolean AddrBookOpen;
extern gboolean ComposerOpen;
extern gboolean FiltersOpen;
extern gboolean OptionsOpen;
extern gboolean PrintOpen;

/* generic globals */
extern gchar *spruceconf;                       /* spruce config file */
extern gchar *AddrSelected;                     /* addr selected by frmAddrBook */
extern gint first_time;
extern gint texticons;                          /* use text, icons or both? */

extern gint NumMailboxes;                       /* number of spruce mailboxes */
extern gint NumRemoteboxes;                     /* number of remote mailboxes */
extern gint NumSpoolboxes;                      /* number of local spools */

/* Identity */
extern gchar *SenderAddr;                       /* user's email addr */
extern gchar *ReplyTo;                          /* user's Reply-To email addr */
extern gint use_rand_sig;                       /* use spruce's random signature? */
extern gint auto_attach_sig;                    /* auto-attach the signature? */
extern gchar *signaturefile;                    /* user's signature file */
/* Accounts */
extern gint NumAccounts;                        /* number of pop3 accounts we have */
extern accounts_t AccountsList[MAX_ACCOUNTS];
extern Server SmtpServer;                       /* smtp server */
/* Appearance */
extern gchar *mesg_body_font;
extern gchar *unread_mesg_header_font;
extern gchar *read_mesg_header_font;
/* Misc */
extern gint save_outgoing;                      /* save outgoing messages? */
extern gint empty_on_exit;                      /* empty "Deleted items" on exit? */
extern gint save_sizes;                         /* save window and column sizes on exit? */
extern gint cm_delay;                           /* check mail every XX minutes */
extern gint hdr_trim_level;                     /* 0 = none; 1 = partial; 2 = full */
/* PGP */
extern gchar *pgp_identity;                     /* PGP Identity */
extern gint use_gnupg;                          /* do we use GNUpg or Pgp50i? */
extern gint pgp_sign;                           /* pgpv -s ? */
extern gint encrypt_to_self;                    /* always encrypt to self? */
extern gint store_passphrase;                   /* store our passphrase? */
extern gchar *pgp_passphrase;                   /* pgp passphrase */

extern GList *mime_parts;

/* here are our window widgets... */
extern GtkWidget *frmAbout;
extern GtkWidget *frmAccounts;
extern GtkWidget *frmAddrBook;
extern GtkWidget *frmComposer;
extern GtkWidget *frmFilters;
extern GtkWidget *frmMain;
extern GtkWidget *frmOptions;
extern GtkWidget *frmPrint;
extern GtkWidget *frmStatus;


/* used by main.c and gui.c */
static gint cMesg = -1;
static gint NumMesgs = 0;
static gint cMbox = -1;
static GtkWidget *selected_mailbox;
static gboolean refreshing_boxes    = FALSE;
static gboolean refreshing_maillist = FALSE;
static gboolean refreshing_message  = FALSE;
static gboolean MbxNewOpen = FALSE;
static GtkWidget *dlgNewMailbox;
static gchar *SaveFile;
static gboolean SaveAsOpen = FALSE;
static GtkWidget *frmMainSaveAs;
static gboolean fetching_mail = FALSE;
static GtkWidget *dlgCopyMove;
static gboolean CopyMoveOpen = FALSE;
static gint cm_operation = 0;
extern GtkWidget *mnuMessage_menu;
extern GtkWidget *mnuMailboxes_menu;
static gint sort_column = 0;                        /* column to sort */
static GtkSortType sort_type = GTK_SORT_ASCENDING;
static gint mime;
static gint mime_preferred_part;

int main(int argc, char *argv[])
{
   set_security();
   reset_globals();
   open_msgids_file();

   gtk_set_locale();
   gtk_init(&argc, &argv);

   if (!rc_read_defaults())
   {
      fprintf(stderr, "Ah...this is your first time running Spruce eh?\n");
      fprintf(stderr, "If this segfaults, please run 'spruce.inst'\n");
      fprintf(stderr, "Thanks.\n");
      first_run();
      frmMain = create_frmMain();  /* we needa create the main window so we can save defaults */
      rc_save_defaults();
      
      reset_globals();
      first_time = 1;
      rc_read_defaults();  /* seems to crash the Options dialog if we don't do this...hmmm */
	}

   spruce_init(argc, argv); /* read command line after spruce.conf so command line has precedence */

   frmMain = create_frmMain();
   read_accounts();

   read_sizes();	   /* we must read the sizes after frmMain has been created */

   filters_read();

   gtk_widget_show(frmMain);

   if (first_time)
	{
      frmOptions = create_frmOptions();
      gtk_widget_show(frmOptions);
      OptionsOpen = TRUE;
	}

   refresh_mailboxes(TOP);

   /* Check for new mail once every XX minutes. */
   if (cm_delay > 0)
      gtk_timeout_add(cm_delay * 60 * 1000, periodic_mail_check, 0);

   gtk_main();

   close_msgids_file();

   return 0;
}

void on_frmMain_destroy (GtkObject *object, gpointer user_data)
{
   if (empty_on_exit)
   {
      /* emtpy the contents of "Deleted items" */
      mailbox_delete("Deleted items");
      mailbox_create("Deleted items");
   }
   
   rc_save_defaults(); /* so the window size, and column sizes is saved */
   global_free();    /* free our globals variables */
   gtk_main_quit();  /* exit */
}

void on_mnuNew_Message_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   on_cmdNew_clicked(NULL, NULL);
}

void on_cmdNew_clicked (GtkWidget *widget, gpointer data)
{
   if (!ComposerOpen)
   {
      frmComposer = create_frmComposer(SenderAddr, NULL, NULL, NULL);
      gtk_widget_show(frmComposer);
      ComposerOpen = TRUE;
   }
}

void on_mnuSave_As_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   on_cmdSave_clicked(NULL, NULL);
}

void on_cmdSave_clicked (GtkWidget *widget, gpointer data)
{
   if (!SaveAsOpen && cMesg >= 0)
   {
      frmMainSaveAs = create_frmMainSaveAs();
      gtk_widget_show(frmMainSaveAs);
      SaveAsOpen = TRUE;
   }
}

void on_mnuPrint_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   on_cmdPrintToolbar_clicked(NULL, NULL);
}

void on_cmdPrintToolbar_clicked (GtkWidget *widget, gpointer data)
{
   GtkWidget *clistMail  = get_widget(frmMain, "clistMail");
   gchar *mailbox = NULL;
   gchar *mesgid  = NULL;
   gchar *mesg    = NULL;
   gchar from[512], date[512], subject[512];
   gchar header[2048];
   gint seen;
   struct mailboxformat *mb;

   if (!PrintOpen && cMesg >= 0)
   {
      if (selected_mailbox == NULL)
         return;	

      mb = gtk_object_get_data (GTK_OBJECT(selected_mailbox), "mailboxformat");
      if (mb == NULL)
         return;

      gtk_label_get (GTK_LABEL (GTK_BIN (GTK_WIDGET(selected_mailbox))->child), &mailbox);

      gtk_clist_get_text(GTK_CLIST(clistMail), cMesg, 0, &mesgid);
      if (mb->format == 1)
         mesg = mailbox_get_mesg (atoi(mesgid), mailbox);
      else
         if (mb->format == 2)
            mesg = imap_fetch (AccountsList[mb->account].socket, atoi(mesgid), 0, &seen);

      strncpy(from, mailbox_get_mesg_from(mesg), sizeof(from)-1);
		strncpy(date, mailbox_get_mesg_date(mesg), sizeof(date)-1);
		strncpy(subject, mailbox_get_mesg_subject(mesg), sizeof(subject)-1);
      g_snprintf(header, sizeof(header)-1, "From: %s\nDate: %s\nSubject: %s\n", from, date, subject);
		trim_header(mesg, hdr_trim_level);

      frmPrint = create_frmPrint(header, mesg);
      g_free(mesg);
      gtk_widget_show(frmPrint);
      PrintOpen = TRUE;
   }
}

void on_cmdCheckMail_clicked (GtkWidget *widget, gpointer data)
{
   mail_check (SHOW_STATUS_DIALOG);
}

void on_mnuCheck_Mail_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   on_cmdCheckMail_clicked(NULL, NULL);
}

gint periodic_mail_check (gpointer data)
{
   mail_check (HIDE_STATUS_DIALOG);
   return 1;
}

void mail_check (gboolean show_dialog)
{
   gint i;
   gint err;
   gchar reason[50];
   gchar buffer[256];

   if (!fetching_mail)
   {
      fetching_mail = TRUE;

      if (show_dialog)
      {
         frmStatus = create_frmStatus(NULL);
         gtk_widget_show(frmStatus);
      }

      for (i = 0; i < NumAccounts; i++)
      {
         if (AccountsList[i].type == TYPE_POP3)
         {
	         g_snprintf(buffer, 255, "%s", AccountsList[i].server.hostname);
		      if (show_dialog)
            {
               gtk_window_set_title (GTK_WINDOW (frmStatus), buffer);
            }
	         fprintf(stdout, "Retrieving mail from: %s:%d...",
	                 AccountsList[i].server.hostname,
	                 AccountsList[i].server.port);
	         fflush(stdout);
	         err = fetchmail(&AccountsList[i].server, AccountsList[i].login, 
	                         AccountsList[i].passwd, 
	                         get_mailbox(AccountsList[i].mailbox),
	                         AccountsList[i].delemail, show_dialog);

            update_display();

	         if(!err)
	         {
	            pop3error(reason, 49);
	            fprintf(stderr, "failed.\nSpruce%s\n", reason);
	            fflush(stdout);
	         }
	         else
	         {
	            fprintf(stdout, "done.\n");
	            fflush(stdout);
	         }
         }
      }

      if (show_dialog)
         gtk_widget_destroy(frmStatus);

      fetching_mail = FALSE;
      refresh_mail_list(STAY);
   }
}

void on_mnuExit_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   on_frmMain_destroy(NULL, NULL);
}

void on_mnuAddress_Book_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   on_cmdAddrbk_clicked(NULL, NULL);
}

void on_cmdAddrbk_clicked (GtkWidget *widget, gpointer data)
{
   if (!AddrBookOpen)
   {
      frmAddrBook = create_frmAddrBook(NULL);
      gtk_widget_show(frmAddrBook);
      AddrBookOpen = TRUE;
   }
}

void on_mnuAccounts_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   if (!AccountsOpen)
   {
      frmAccounts = create_frmAccounts(TRUE);
      gtk_widget_show(frmAccounts);
      AccountsOpen = TRUE;
   }
}

void on_mnuFilters_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   if(!FiltersOpen)
   {
      frmFilters = create_frmFilters();
      gtk_widget_show(frmFilters);
      filters_refresh();
      FiltersOpen = TRUE;
   }
}

void on_mnuOptions_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   if (!OptionsOpen)
   {
      frmOptions = create_frmOptions();
      gtk_widget_show(frmOptions);
      OptionsOpen = TRUE;
   }
}

void on_mnuMailboxCreate_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   if (!MbxNewOpen)
   {
      dlgNewMailbox = create_dlgNewMailbox();
      gtk_widget_show(dlgNewMailbox);
      MbxNewOpen = TRUE;
   }
}

void on_mnuMailboxDelete_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   gchar *mailbox;
   struct mailboxformat *mb;

   if (cMbox >= 0)
   {
      if (selected_mailbox == NULL)
           return;

      mb = gtk_object_get_data (GTK_OBJECT(selected_mailbox), "mailboxformat");
      if (mb == NULL)
           return;

      gtk_label_get (GTK_LABEL (GTK_BIN (GTK_WIDGET(selected_mailbox))->child), &mailbox);

      switch (mb->format)
      {
         case 1:  /* either a spruce mailbox or a spool */
            if (mailbox[0] != '/')
            {
               /* regular spruce mailbox */
               mailbox_delete(mailbox);
               NumMailboxes--;
               if (cMbox >= NumMailboxes)
                  cMbox = NumMailboxes - 1;
            }
            else
            {
               /* local spool */
               NumSpoolboxes--;
            }
            break;
         case 2:  /* remote mailbox */
            imap_mailbox_delete (AccountsList[mb->format].socket, mailbox);
            break;
         default:
            fprintf(stderr, "Unknown mailbox type. Skipping.\n");
            fflush(stderr);
      }

      rc_save_defaults();

      /*refresh_mailboxes();*/
      gtk_widget_destroy(selected_mailbox);
   }
}

void on_mnuMesgNext_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   on_cmdNext_clicked(NULL, NULL);
}

void on_cmdNext_clicked (GtkWidget *widget, gpointer data)
{
   GtkWidget *clist = get_widget(frmMain, "clistMail");
   GtkVisibility visible;

   if (cMesg < NumMesgs - 1)
   {
      gtk_clist_unselect_row(GTK_CLIST(clist), cMesg, 0);
      gtk_clist_select_row(GTK_CLIST(clist), cMesg + 1, 0);
      visible = gtk_clist_row_is_visible(GTK_CLIST(clist), cMesg);
      if (visible != GTK_VISIBILITY_FULL)
         gtk_clist_moveto(GTK_CLIST(clist), cMesg, 0, 1.0, 0.0);
   }
}

void on_mnuMesgPrevious_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   on_cmdPrevious_clicked(NULL, NULL);
}

void on_cmdPrevious_clicked (GtkWidget *widget, gpointer data)
{
   GtkWidget *clist = get_widget(frmMain, "clistMail");
   GtkVisibility visible;

   if (cMesg > 0)
   {
      gtk_clist_unselect_row(GTK_CLIST(clist), cMesg, 0);
      gtk_clist_select_row(GTK_CLIST(clist), cMesg - 1, 0);
      visible = gtk_clist_row_is_visible(GTK_CLIST(clist), cMesg);
      if (visible != GTK_VISIBILITY_FULL)
         gtk_clist_moveto(GTK_CLIST(clist), cMesg, 0, 0.0, 0.0);
   }
}

void on_mnuMesgReply_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   on_cmdReply_clicked (NULL, NULL);
}

void on_cmdReply_clicked (GtkWidget *widget, gpointer data)
{
   GtkWidget *clist   = get_widget(frmMain, "clistMail");
   GtkWidget *txtBody = get_widget(frmMain, "txtMessage");
   gchar *recipient   = NULL;
   gchar *OrigSubject = NULL;
   gchar *subject     = NULL;
   gchar *date        = NULL;
   gchar *body        = NULL;
   gchar *mod_body    = NULL;
   gchar *mesg        = NULL;
   gchar *replyto     = NULL;
   gchar *mailbox     = NULL;
   gchar *mesgid      = NULL;
   gint seen;
   struct mailboxformat *mb;

   if (!ComposerOpen && cMesg >= 0)
   {
      if (selected_mailbox == NULL)
          return;	
      mb = gtk_object_get_data (GTK_OBJECT(selected_mailbox), "mailboxformat");
      if (mb == NULL)
   	  return;
      gtk_label_get (GTK_LABEL (GTK_BIN (GTK_WIDGET(selected_mailbox))->child), &mailbox);

      gtk_clist_get_text(GTK_CLIST(clist), cMesg, 0, &mesgid);
      gtk_clist_get_text(GTK_CLIST(clist), cMesg, 1, &recipient);
      gtk_clist_get_text(GTK_CLIST(clist), cMesg, 2, &OrigSubject);
      gtk_clist_get_text(GTK_CLIST(clist), cMesg, 3, &date);

      if (mb->format == 1)
          mesg = mailbox_get_mesg(atoi(mesgid), mailbox);
      if (mb->format == 2)
          mesg = imap_fetch (AccountsList[mb->account].socket, atoi(mesgid), 0, &seen);
          
      replyto = mailbox_get_mesg_replyto(mesg);
      
      body = gtk_editable_get_chars(GTK_EDITABLE(txtBody), 0, -1);

      mod_body = quote_body(body, recipient, date);

      if (OrigSubject == NULL)
      {
         /* OrigSubject is NULL */
         subject = g_malloc(strlen("Re: ") + 1);
         sprintf(subject, "Re: ");
      }
      else
      {
         subject = g_malloc(strlen("Re: ") + strlen(OrigSubject) + 1);
         sprintf(subject, "Re: %s", OrigSubject);
      }

      if (replyto == NULL || strstrcase(recipient, replyto) != NULL)
      {
         frmComposer = create_frmComposer(SenderAddr, recipient, subject, mod_body);
      }
      else
      {
         frmComposer = create_frmComposer(SenderAddr, replyto, subject, mod_body);
      }
      gtk_widget_show(frmComposer);

      g_free(subject);
      g_free(mod_body);
      g_free(body);
      g_free(mesg);

      ComposerOpen = TRUE;
   }
}

void on_mnuMesgForward_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   on_cmdFwd_clicked(NULL, NULL);
}

void on_cmdFwd_clicked (GtkWidget *widget, gpointer data)
{
   GtkWidget *clist   = get_widget(frmMain, "clistMail");
   GtkWidget *txtBody = get_widget(frmMain, "txtMessage");
   gchar *OrigSubject = NULL;
   gchar *subject     = NULL;
   gchar *body        = NULL;
   gchar *mod_body    = NULL;
   gchar *sender      = NULL;
   gchar *date        = NULL;

   if (!ComposerOpen && cMesg >= 0)
   {
      gtk_clist_get_text(GTK_CLIST(clist), cMesg, 1, &sender);
      gtk_clist_get_text(GTK_CLIST(clist), cMesg, 2, &OrigSubject);
      gtk_clist_get_text(GTK_CLIST(clist), cMesg, 3, &date);

      if (OrigSubject == NULL)
      {
         /* OrigSubject is NULL */
         subject = g_malloc0(strlen("Fw: ") + 1);
         sprintf(subject, "Fw: ");
      }
      else
      {
         subject = g_malloc(strlen("Fw: ") + strlen(OrigSubject) + 1);
         sprintf(subject, "Fw: %s", OrigSubject);
      }

      body = gtk_editable_get_chars(GTK_EDITABLE(txtBody), 0, -1);

      mod_body = quote_body(body, sender, date);

      frmComposer = create_frmComposer(SenderAddr, NULL, subject, mod_body);
      gtk_widget_show(frmComposer);

      g_free(subject);
      g_free(mod_body);
      g_free(body);

      ComposerOpen = TRUE;
   }
}

void on_mnuMesgOpen_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   GtkWidget *clistMail  = get_widget(frmMain, "clistMail");
   GtkWidget *frmMesgReader = NULL;
   gchar *mesg = NULL;
   gchar *mailbox;
   gchar *mesgid;
   gint seen;
   struct mailboxformat *mb;

   if (selected_mailbox == NULL)
   	return;
   mb = gtk_object_get_data (GTK_OBJECT(selected_mailbox), "mailboxformat");
   if (mb == NULL)
   	return;
   gtk_label_get (GTK_LABEL (GTK_BIN (GTK_WIDGET(selected_mailbox))->child), &mailbox);


   if (cMesg >= 0)
   {
      gtk_clist_get_text(GTK_CLIST(clistMail), cMesg, 0, &mesgid);
      if (mb->format == 1)
      	mesg = mailbox_get_mesg(atoi(mesgid), mailbox);
      if (mb->format == 2)
      	mesg = imap_fetch (AccountsList[mb->account].socket, atoi(mesgid), 0, &seen);

      frmMesgReader = create_frmMesgReader(mesg, mailbox_get_mesg_subject(mesg));
      gtk_widget_show(frmMesgReader);
      g_free(mesg);
   }
}

void on_mnuMesgDelete_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   on_cmdDel_clicked(NULL, NULL);
}

void on_cmdDel_clicked (GtkWidget *widget, gpointer data)
{
   GtkWidget *clistMail  = get_widget(frmMain, "clistMail");
   gchar *mailbox;
   gchar *mesgid;
   GList *selection;
   guint num = 0, *mesg_nums, i = 0;
   gint y, temp;
   struct mailboxformat *mb;
   

   if (selected_mailbox == NULL)
   	return;
   mb = gtk_object_get_data (GTK_OBJECT(selected_mailbox), "mailboxformat");
   if (mb == NULL)
   	return;
   gtk_label_get (GTK_LABEL (GTK_BIN (GTK_WIDGET(selected_mailbox))->child), &mailbox);


   selection = GTK_CLIST(clistMail)->selection;
   num = g_list_length(selection);
   if (num <= 0)	/* no messages, so skip out */
      return;
      
   mesg_nums = g_malloc0(sizeof(gint) * num);

   selection = GTK_CLIST(clistMail)->selection;
   while(selection != NULL)
   {
      gtk_clist_get_text(GTK_CLIST(clistMail), (gint)selection->data, 0, &mesgid);
      mesg_nums[i] = atoi(mesgid);
      selection = selection->next;
      i++;
   }

   /* gotta sort the ids */
   y = 0;
   while(y == 0)
   {
      y = 1;
      i = 0;
      while(i < num - 1)
      {
         if(mesg_nums[i] > mesg_nums[i+1])
         {
            temp = mesg_nums[i];
            mesg_nums[i] = mesg_nums[i+1];
            mesg_nums[i+1] = temp;
            y = 0;
         }
         i++;
      }
   }

   if (num > 0)
   {
      if (mb->format == 1)
      {
      		if (strcmp(mailbox, "Deleted items"))
      		{
         		/* the user is not in the "Deleted items" mailbox */
         		/* so we want to move it/them to the "Deleted items" box */
         		mailbox_move_mesgs(num, mesg_nums, mailbox, "Deleted items");
      		}
      		else
      		{
         		/* the user is in the "Deleted items" mailbox */
         		/* so we should expunge the message(s) */
         		mailbox_del_mesgs(num, mesg_nums, mailbox);
      		}
      }

      if (mb->format == 2)
      {
         imap_delete (AccountsList[mb->account].socket, num, mesg_nums);
      }

      clistMail_update();
      if (mb->format == 1)
      	mailbox_refresh_mailpos(num, mesg_nums, NumMesgs, mailbox);
      cMesg--;
      i = 0;
      while(i < GTK_CLIST(clistMail)->rows)
      {
         gtk_clist_unselect_row(GTK_CLIST(clistMail), i, 0);
         i++;
      }
      if(NumMesgs > 0)
      {
         gtk_clist_select_row(GTK_CLIST(clistMail), cMesg+1, 0);
      }
      /*refresh_mail_list(STAY);*/
   }

   if (NumMesgs == 0)
   {
      cMesg = -1;
      refresh_txtMessage();
   }

   g_free(mesg_nums);
}

void on_mnuMesgExpunge_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   GtkWidget *clistMail  = get_widget(frmMain, "clistMail");
   gchar *mailbox;
   gchar *mesgid;
   GList *selection;
   guint num = 0, *mesg_nums, i = 0;
   gint y, temp;
   struct mailboxformat *mb;

   
   if (selected_mailbox == NULL)
	return;
   mb = gtk_object_get_data (GTK_OBJECT(selected_mailbox), "mailboxformat");
   if (mb == NULL)
   	return;
   gtk_label_get (GTK_LABEL (GTK_BIN (GTK_WIDGET(selected_mailbox))->child), &mailbox);


   selection = GTK_CLIST(clistMail)->selection;
   num = g_list_length(selection);
   if (num <= 0)	/* no messages selected */
      return;
      
   mesg_nums = g_malloc0(sizeof(gint) * num);

   selection = GTK_CLIST(clistMail)->selection;
   while(selection != NULL)
   {
      gtk_clist_get_text(GTK_CLIST(clistMail), (gint)selection->data, 0, &mesgid);
      mesg_nums[i] = atoi(mesgid);
      selection = selection->next;
      i++;
   }

   /* gotta sort the ids */
   y = 0;
   while(y == 0)
   {
      y = 1;
      i = 0;
      while(i < num - 1)
      {
         if(mesg_nums[i] > mesg_nums[i+1])
         {
            temp = mesg_nums[i];
            mesg_nums[i] = mesg_nums[i+1];
            mesg_nums[i+1] = temp;
            y = 0;
         }
         i++;
      }
   }

   if (num > 0)
   {
      /* let's really delete that badboy */
      mailbox_del_mesgs(num, mesg_nums, mailbox);
      /*refresh_mail_list(STAY);*/
      clistMail_update();
      mailbox_refresh_mailpos(num, mesg_nums, NumMesgs, mailbox);
      cMesg--;
      if (NumMesgs > 0)
         gtk_clist_select_row(GTK_CLIST(clistMail), cMesg+1, 0);
   }

   if(NumMesgs == 0)
   {
      cMesg = -1;
      refresh_txtMessage();
   }

   g_free(mesg_nums);
}

void on_mnuCopy_to_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   if (!CopyMoveOpen && cMesg >= 0)
	{
      /* show the "Copy To:" dialog */
      cm_operation = MCOPY;
      dlgCopyMove = create_dlgCopyMove("Copy message to...");
      gtk_widget_show(dlgCopyMove);
      CopyMoveOpen = TRUE;
	}
}

void on_mnuMove_to_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   if (!CopyMoveOpen && cMesg >= 0)
	{
      /* show the "Move To:" dialog */
      cm_operation = MMOVE;
      dlgCopyMove = create_dlgCopyMove("Move message to...");
      gtk_widget_show(dlgCopyMove);
      CopyMoveOpen = TRUE;
	}
}

void on_mnuMimeSave_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	GList *tmp;
	GtkWidget *clistMime = get_widget(frmMain, "clistMime");
	GtkWidget *file_sel;
	gchar name[128];
	gint part, ret;


	tmp = GTK_CLIST(clistMime)->selection;
	if (tmp == NULL)
		return;

	part = (gint)tmp->data;
	tmp = mime_parts;
	while (tmp != NULL && part > 0)
   {
		tmp=tmp->next;
		part--;
	}

	if (((struct mime_part *)tmp->data)->len <= 0)
		return;
		
	file_sel = gtk_file_selection_new(_("Filename"));
	ret = mime_get_parameter_value(((struct mime_part *)tmp->data)->parameter, "name", name);
	if (ret)
		gtk_file_selection_set_filename(GTK_FILE_SELECTION(file_sel), name);
		
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(file_sel)->ok_button), "clicked", 
                      GTK_SIGNAL_FUNC(on_mnuMimeSave_file), file_sel);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(file_sel)->cancel_button), "clicked",
                      GTK_SIGNAL_FUNC(on_mnuMimeSave_file_cancel), file_sel);
	gtk_widget_show(file_sel);
}	

void on_mnuMimeSave_file (GtkWidget *button, GtkFileSelection *file_sel)
{
	GtkWidget *clistMail = get_widget(frmMain, "clistMail");
	GtkWidget *clistMime = get_widget(frmMain, "clistMime");
	gchar *part, *mesg = NULL, *mailbox, *mesgid, *file;
	FILE *fp;
	GList *tmp;
	gint len, seen;
	struct mailboxformat *mb;

	if (selected_mailbox == NULL)
		return;	
	mb = gtk_object_get_data (GTK_OBJECT(selected_mailbox), "mailboxformat");
	if (mb == NULL)
		return;
	gtk_label_get (GTK_LABEL (GTK_BIN (GTK_WIDGET(selected_mailbox))->child), &mailbox);
  	
	gtk_clist_get_text(GTK_CLIST(clistMail), cMesg, 0, &mesgid);
	tmp = GTK_CLIST(clistMime)->selection;
	if (tmp == NULL)
		return;


	if (mb->format == 1)
		mesg = mailbox_get_mesg(atoi(mesgid), mailbox);
	if (mb->format == 2)
		mesg = imap_fetch (AccountsList[mb->account].socket, atoi(mesgid), 0, &seen);
	/*strip(mesg, '\r');*/
	part = mime_get_part(mesg, ((gint)tmp->data) + 1, &len);
	file = gtk_file_selection_get_filename(GTK_FILE_SELECTION(file_sel));
	fp = fopen(file, "wb");
	if (fp != NULL)
	{
		fwrite(part, 1, len, fp);
		fflush(fp);
		fclose(fp);
	}
	else
		fprintf(stderr, _("Couldn't open %s\n"), file);

	g_free(part);
	g_free(mesg);
	
	gtk_widget_destroy(GTK_WIDGET(file_sel));
}

void on_mnuMimeSave_file_cancel (GtkWidget *button, GtkFileSelection *file_sel)
{
   gtk_widget_destroy(GTK_WIDGET(file_sel));
}

void on_mnuHelpAbout_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   if (!AboutOpen)
   {
      /* show the about dialog box... */
      frmAbout = create_frmAbout();
      gtk_widget_show(frmAbout);
      AboutOpen = TRUE;
   }
}

void on_mnuHelpManual_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   /* bah, not right now */
}

void on_txtMessage_clicked (GtkWidget *text, GdkEvent *event, gpointer user_data)
{

	/* mouse wheel scroll up */
	if (event->button.button == 5)
	{
		gtk_adjustment_set_value(GTK_ADJUSTMENT(GTK_TEXT(text)->vadj), GTK_ADJUSTMENT(GTK_TEXT(text)->vadj)->value+15); 
	}
	/* mouse wheel scroll down */
	if (event->button.button == 4)
	{
		gtk_adjustment_set_value(GTK_ADJUSTMENT(GTK_TEXT(text)->vadj), GTK_ADJUSTMENT(GTK_TEXT(text)->vadj)->value-15);
	}
}

void on_clistMail_select_row (GtkCList *clist, gint row, gint column, GdkEvent *event, gpointer user_data)
{
   GList *selection;

   selection = GTK_CLIST(clist)->selection;
   /* there's no reason to refresh txtMessage if there are
    * more then one message selected */
   if(g_list_length(selection) == 1 && cMesg != row)
   {
      /* highlight/select the new row */
      cMesg = row;
      refresh_txtMessage();
      update_messageStatus();
   }
}

void on_clistMail_clicked (GtkWidget *clist, GdkEvent *event, gpointer user_data)
{
   GtkWidget *clistMail  = get_widget(frmMain, "clistMail");
   GtkWidget *frmMesgReader = NULL;
   gchar *mesg = NULL;
   gchar *mailbox = NULL;
   gchar *mesgid;
   gint seen;
   struct mailboxformat *mb;

   
   if(event->button.button == 1 && (event->type == GDK_2BUTTON_PRESS || 
      event->type == GDK_3BUTTON_PRESS))
   {
      /* okay folks, we got ourselves a double-clicker here... */
      mb = gtk_object_get_data (GTK_OBJECT(selected_mailbox), "mailboxformat");
      if (mb == NULL)
         return;

      gtk_label_get (GTK_LABEL (GTK_BIN (GTK_WIDGET(selected_mailbox))->child), &mailbox);
      gtk_clist_get_text(GTK_CLIST(clistMail), cMesg, 0, &mesgid);

      if (cMesg >= 0)
      {
         if (mb->format == 1)
         	mesg = mailbox_get_mesg(atoi(mesgid), mailbox);
         if (mb->format == 2)
         	mesg = imap_fetch(AccountsList[mb->account].socket, atoi(mesgid), 0, &seen);
         	
         frmMesgReader = create_frmMesgReader(mesg, mailbox_get_mesg_subject(mesg));
         gtk_widget_show(frmMesgReader);
         g_free(mesg);
      }
      return;
   }

   if (event->button.button == 3)
   {
      gtk_menu_popup((GtkMenu *)mnuMessage_menu, NULL, NULL, NULL,
                     (gpointer)NULL, (guint)NULL, (guint32)NULL);
   }
}

void on_clistMail_drag_data_get (GtkWidget *clist, GdkDragContext *context, 
                                 GtkSelectionData *selection, guint info, 
                                 guint32 clk_time, gpointer user_data)
{
   char string[32];
   
   strcpy(string, "data on the way");
   gtk_selection_data_set(selection, selection->target, 8, string, strlen(string));
}

void on_clistMail_click_column (GtkWidget *clist, gint column, gpointer user_data)
{
   gtk_clist_freeze(GTK_CLIST(clist));

   if (column == sort_column)
   {
      if (sort_type == GTK_SORT_ASCENDING)
         sort_type = GTK_SORT_DESCENDING;
      else
         sort_type = GTK_SORT_ASCENDING;
      gtk_clist_set_sort_type (GTK_CLIST (clist), sort_type);
   }
   else
   {
      sort_column = column;
      gtk_clist_set_sort_column (GTK_CLIST (clist), sort_column);
      sort_type = GTK_SORT_ASCENDING;
      gtk_clist_set_sort_type (GTK_CLIST (clist), sort_type);
      switch (sort_column)
      {
         case 0:         /* sort by message id */
            gtk_clist_set_compare_func (GTK_CLIST (clist), id_compare);
            break;
         case 3:         /* sort by date */
            gtk_clist_set_compare_func (GTK_CLIST (clist), date_compare);
            break;
         default:
            gtk_clist_set_compare_func (GTK_CLIST (clist), str_compare);
      }
   }

   gtk_clist_sort(GTK_CLIST(clist));

   gtk_clist_thaw(GTK_CLIST(clist));
}

void on_treeBoxes_selection_changed (GtkWidget *tree)
{
	GList *selection;
	
	selection = GTK_TREE_SELECTION(tree);
	if (selection == NULL)
	{
		selected_mailbox = NULL;
		return;
	}
	
	if (GTK_TREE_ITEM (GTK_WIDGET (selection->data))->subtree == NULL && selection->data != selected_mailbox)
	{
		selected_mailbox = selection->data;
		refresh_mail_list(TOP);
	}
}

void on_clistBoxes_select_row (GtkCList *clist, gint row, gint column,
                               GdkEvent *event, gpointer user_data)
{
   cMbox = row;
   refresh_mail_list(TOP);
}

void on_treeBoxes_clicked (GtkWidget *tree, GdkEvent *event, gpointer user_data)
{
   if(event->button.button == 3)
   {
      gtk_menu_popup((GtkMenu *)mnuMailboxes_menu, NULL, NULL, NULL, 
                     (gpointer)NULL, (guint) NULL, (guint32)NULL);
   }
}

void on_treeBoxes_drag_data_recieved (GtkWidget *item, GdkDragContext *context, 
                                       gint x, gint y, 
                                       GtkSelectionData *selection_data, 
                                       guint info, guint32 clk_time)
{
   gchar *mailbox, *mesgid, *oldmailbox;
   GtkWidget *clistMail = get_widget(frmMain, "clistMail");
   GList *selection;
   gint num = 0, *mesg_nums, i = 0, done, temp;
   struct mailboxformat *mb_old, *mb_new;
	
   /*gtk_clist_get_selection_info(GTK_CLIST(clist), x, y, &row, &col);
   gtk_clist_get_text(GTK_CLIST(clist), row, 0, &mailbox);
   gtk_clist_get_text(GTK_CLIST(clist), cMbox, 0, &oldmailbox);*/
   if (selected_mailbox == NULL)
   	return;

   mb_old = gtk_object_get_data (GTK_OBJECT(selected_mailbox), "mailboxformat");
   if (mb_old == NULL)
   	return;

   gtk_label_get (GTK_LABEL (GTK_BIN (GTK_WIDGET(selected_mailbox))->child), &oldmailbox);
   
   mb_new = gtk_object_get_data (GTK_OBJECT(item), "mailboxformat");
   if (mb_new == NULL)
   	return;

   gtk_label_get (GTK_LABEL (GTK_BIN (GTK_WIDGET(item))->child), &mailbox);


   if (!strcmp(mailbox, oldmailbox))
   {
      /* mailboxes are the same */
      return;
   }

   selection = GTK_CLIST(clistMail)->selection;
   while (selection != NULL)
   {
      num++;
      selection = selection->next;
   }

   mesg_nums = g_malloc0(sizeof(gint)*num);

   selection = GTK_CLIST(clistMail)->selection;
   while(selection != NULL)
   {
      gtk_clist_get_text(GTK_CLIST(clistMail), (gint)selection->data, 0, &mesgid);
      mesg_nums[i] = atoi(mesgid);
      i++;
      selection=selection->next;
   }

   done = 0;
   while (done == 0)
   {
      done = 1;
      i = 0;
      while(i < num - 1)
      {
         if(mesg_nums[i] > mesg_nums[i+1])
         {
            temp = mesg_nums[i];
            mesg_nums[i] = mesg_nums[i+1];
            mesg_nums[i+1] = temp;
            done = 0;
         }
         i++;
      }
   }

   if (context->action == GDK_ACTION_MOVE)
   {
      if (mb_new->format == 1 && mb_old->format == 1)
      {
          mailbox_move_mesgs(num, mesg_nums, oldmailbox, mailbox);
          mailbox_refresh_mailpos(num, mesg_nums, NumMesgs, oldmailbox);
          clistMail_update();
      }
   }

   if (context->action == GDK_ACTION_COPY)
   {
      if (mb_new->format == 1 && mb_old->format == 1)
          mailbox_copy_mesgs(num, mesg_nums, oldmailbox, mailbox);
   }
   
   g_free(mesg_nums);
   gtk_drag_finish(context, 1, FALSE, clk_time);
}

void on_clistMime_select_row (GtkWidget *clist, gint row, gint col, gpointer user_data)
{
	gint i;
	GList *tmp;

	i = 0;
	tmp = mime_parts;
	while(tmp != NULL && i < row)
   {
		tmp=tmp->next;
		i++;
	}
	
	if(!g_strcasecmp(((struct mime_part *)tmp->data)->type, "text") ||
	   !g_strcasecmp(((struct mime_part *)tmp->data)->type, "message"))
   {
		mime_preferred_part = row + 1;
		refresh_txtMessage();
	}	
}

void on_frmMainSaveAs_destroy (GtkObject *object, gpointer user_data)
{
   gtk_widget_destroy(frmMainSaveAs);
   SaveAsOpen = 0;
}

void on_cmdMainSaveAs_OK_clicked (GtkButton *button, gpointer user_data)
{
   if (SaveFile != NULL)
      g_free(SaveFile);
   SaveFile = g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(frmMainSaveAs)));

   save_message();

   gtk_widget_destroy(frmMainSaveAs);
   SaveAsOpen = FALSE;
}

void on_cmdMainSaveAs_Cancel_clicked (GtkButton *button, gpointer user_data)
{
   gtk_widget_destroy(frmMainSaveAs);
   SaveAsOpen = FALSE;
}

void on_dlgNewMailbox_destroy (GtkObject *object, gpointer user_data)
{
   gtk_widget_destroy(dlgNewMailbox);
   MbxNewOpen = FALSE;
}

/* currently you can't create remote mailboxes */
void on_cmdDlgNewMailboxOK_clicked (GtkButton *button, gpointer user_data)
{
   GtkWidget *txtMailboxName = get_widget(dlgNewMailbox, "txtMailboxName");
   GtkWidget *radSpruce      = get_widget(dlgNewMailbox, "radSpruce");
   GtkWidget *treelocalBoxes = get_widget(frmMain, "treelocalBoxes");
   GtkWidget *treespoolBoxes = get_widget(frmMain, "treespoolBoxes");
   GtkWidget *item           = NULL;
   gchar *mailbox;
   struct mailboxformat *mb;

   if (strlen(gtk_entry_get_text(GTK_ENTRY(txtMailboxName))) > 0 )
	{
      mailbox = gtk_entry_get_text(GTK_ENTRY(txtMailboxName));

      if (GTK_TOGGLE_BUTTON(radSpruce)->active)
      {
         /* normal spruce mailbox */
         if ( !GTK_IS_TREE(treelocalBoxes) )
         {
            fprintf(stderr, "Error: Local Mailbox Tree is NULL. Cannot append a new mailbox.\n");
            fflush(stderr);
            gtk_widget_destroy(dlgNewMailbox);
            MbxNewOpen = FALSE;
            return;
         }

         item = gtk_tree_item_new_with_label (mailbox);
         gtk_tree_append (GTK_TREE (treelocalBoxes), item);
         mb = g_malloc0 (sizeof(struct mailboxformat));
         gtk_object_set_data (GTK_OBJECT (item), "mailboxformat", mb);
         gtk_signal_connect (GTK_OBJECT (item), "button_press_event",
						           GTK_SIGNAL_FUNC(on_treeBoxes_clicked), NULL);
         gtk_widget_show (item);
         g_free(mb);

         mailbox_create(mailbox);

         NumMailboxes++;
      }
      else
      {
         /* local spool -> /var/spool/mail type mailbox entry */
         if ( !GTK_IS_TREE(treespoolBoxes) )
         {
            fprintf(stderr, "Error: Local Spool Tree is NULL. Cannot append a new mailbox.\n");
            fflush(stderr);
            gtk_widget_destroy(dlgNewMailbox);
            MbxNewOpen = FALSE;
            return;
         }

         item = gtk_tree_item_new_with_label (mailbox);
         gtk_tree_append (GTK_TREE (treespoolBoxes), item);
         mb = g_malloc0 (sizeof(struct mailboxformat));
         gtk_object_set_data (GTK_OBJECT (item), "mailboxformat", mb);
         gtk_signal_connect (GTK_OBJECT (item), "button_press_event",
						           GTK_SIGNAL_FUNC(on_treeBoxes_clicked), NULL);
         gtk_widget_show (item);
         g_free(mb);

         /*mailbox_create(mailbox);*/

         NumSpoolboxes++;
      }

      rc_save_defaults();

      gtk_widget_destroy(dlgNewMailbox);
      MbxNewOpen = FALSE;
	}
}

void on_cmdDlgNewMailboxCancel_clicked (GtkButton *button, gpointer user_data)
{
   gtk_widget_destroy(dlgNewMailbox);
   MbxNewOpen = FALSE;
}

void on_dlgCopyMove_destroy (GtkObject *object, gpointer user_data)
{
   gtk_widget_destroy(dlgCopyMove);
   CopyMoveOpen = FALSE;
}

void on_cmdCopyMoveOK_clicked (GtkButton *button, gpointer user_data)
{
   GtkWidget *cmboMailbox = get_widget(dlgCopyMove, "cmboMailbox");
   GtkWidget *clistMail   = get_widget(frmMain, "clistMail");
   gchar *original_mbox;
   gchar *mesgid;
   GList *selection;
   guint num = 0, *mesg_nums, i = 0;
   gint y, temp;
   struct mailboxformat *mb;

   if (selected_mailbox == NULL)
   	return;

   mb = gtk_object_get_data (GTK_OBJECT(selected_mailbox), "mailboxformat");
   if (mb == NULL)
   	return;

   gtk_label_get (GTK_LABEL (GTK_BIN (GTK_WIDGET(selected_mailbox))->child), &original_mbox);
   gtk_clist_get_text(GTK_CLIST(clistMail), cMesg, 0, &mesgid);

   selection = GTK_CLIST(clistMail)->selection;
   num = g_list_length(selection);
   if (num <= 0)	/* no messages */
   	return;
   
   mesg_nums = g_malloc0(sizeof(gint) * num);

   selection = GTK_CLIST(clistMail)->selection;
   while (selection != (GList *)NULL)
   {
      gtk_clist_get_text(GTK_CLIST(clistMail), (gint)selection->data, 0, &mesgid);
      mesg_nums[i] = atoi(mesgid);
      selection = selection->next;
      i++;
   }

   /* gotta sort the ids */
   y = 0;
   while (y == 0)
   {
      y = 1;
      i = 0;
      while (i < num - 1)
      {
         if (mesg_nums[i] > mesg_nums[i+1])
         {
            temp = mesg_nums[i];
            mesg_nums[i] = mesg_nums[i+1];
            mesg_nums[i+1] = temp;
            y = 0;
         }
         i++;
      }
   }

   switch (cm_operation)
	{
      case MCOPY:
         if (mb->format == 1)
            mailbox_copy_mesgs(num, mesg_nums, original_mbox, 
            gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(cmboMailbox)->entry)));
         break;
      case MMOVE:
         if (mb->format == 1)
         {
            mailbox_move_mesgs(num, mesg_nums, original_mbox, 
			   gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(cmboMailbox)->entry)));

         	clistMail_update();
            mailbox_refresh_mailpos(num, mesg_nums, NumMesgs, original_mbox);
         }
         /*if (mb->format == 1)
         	mailbox_refresh_mailpos(num, mesg_nums, NumMesgs, original_mbox);*/
         cMesg--;
         gtk_clist_select_row(GTK_CLIST(clistMail), cMesg+1, 0);
         /*refresh_mail_list(STAY);*/
         break;
	}

   g_free(mesg_nums);

   gtk_widget_destroy(dlgCopyMove);
   CopyMoveOpen = FALSE;
}

void on_cmdCopyMoveCancel_clicked (GtkButton *button, gpointer user_data)
{
   gtk_widget_destroy(dlgCopyMove);
   CopyMoveOpen = FALSE;
}

void on_imaptree_expand (GtkWidget *item, gint account)
{
   int sock;
   struct mailboxformat *mb;
   GList *mailboxes = NULL;
   GList *tmp;
   GtkWidget *mailbox_item;

   if (account > NumAccounts - 1)
      return;

   sock = imap_connect (&AccountsList[account].server);

	if (sock < 0)
   {
      fprintf (stderr, _("Couldn't connect to imap server %s\n"), AccountsList[account].server.hostname);
      fflush(stderr);
      return;
   }

   if (!imap_login (sock, AccountsList[account].login, AccountsList[account].passwd))
   {
      fprintf (stderr, _("Couldn't log in to imap server %s\n"), AccountsList[account].server.hostname);
      fflush(stderr);
   }

   mailboxes = imap_list(sock);

   mailboxes = g_list_insert(mailboxes, "INBOX", 0);

   tmp = mailboxes;
   while (tmp != NULL)
   {
      mb = g_malloc0 (sizeof(struct mailboxformat));
      mb->format = 2;
      mb->account = account;
      mailbox_item = gtk_tree_item_new_with_label (tmp->data);
      gtk_widget_show (mailbox_item);
      gtk_object_set_data (GTK_OBJECT (mailbox_item), "mailboxformat", mb);
      gtk_tree_append (GTK_TREE (GTK_TREE_ITEM (item)->subtree), mailbox_item);
      tmp = tmp->next;
   }

   g_list_free (mailboxes);

   AccountsList[account].socket = sock;
}

void on_imaptree_collapse (GtkWidget *item, gint account)
{
   GList *children;
   GtkWidget *tree;

   if (account > NumAccounts - 1)
      return;

   if (AccountsList[account].socket < 0)
      return;

   imap_logout (AccountsList[account].socket);

   close (AccountsList[account].socket);

   AccountsList[account].socket = -1;

   children = gtk_container_children (GTK_CONTAINER (GTK_TREE_ITEM (item)->subtree));
   while (children)
   {
      gtk_object_remove_data (GTK_OBJECT (children->data), "mailboxformat");
      gtk_container_remove (GTK_CONTAINER (GTK_TREE_ITEM (item)->subtree), children->data);
      children = g_list_remove_link (children, children);
   }

   tree = gtk_tree_new();
   gtk_tree_item_set_subtree(GTK_TREE_ITEM (item), tree);
	
   refresh_mail_list(TOP);
   cMesg = -1;
   refresh_txtMessage();
}

gint save_message ()
{
   GtkWidget *clistMail  = get_widget(frmMain, "clistMail");
   gchar *mailbox;
   gchar *mesg = NULL;
   gchar *mesgid;
   FILE *fp;
   gint i;
   struct mailboxformat *mb;

   if (selected_mailbox == NULL)
      return -1;	
   
   mb = gtk_object_get_data (GTK_OBJECT(selected_mailbox), "mailboxformat");
   if (mb == NULL)
      return -1;
   
   gtk_label_get (GTK_LABEL (GTK_BIN (GTK_WIDGET(selected_mailbox))->child), &mailbox);

   gtk_clist_get_text(GTK_CLIST(clistMail), cMesg, 0, &mesgid);

   fp = fopen(SaveFile, "wt");
   if (fp == (FILE *)NULL)
      return 0;

   if (mb->format == 1)
      mesg = mailbox_get_mesg(atoi(mesgid), mailbox);
   if (mb->format == 2)
      mesg = imap_fetch(AccountsList[mb->account].socket, atoi(mesgid), 0, &i);

   if (hdr_trim_level == 0)
   {
      fprintf(fp, "Date:    %s\n", mailbox_get_mesg_date(mesg));
      fprintf(fp, "From:    %s\n", mailbox_get_mesg_from(mesg));
      fprintf(fp, "Subject: %s\n", mailbox_get_mesg_subject(mesg));
   }

   for (i = 0; i < 78; i++)
      fprintf(fp, "-");
   fprintf(fp, "\n\n");
   trim_header(mesg, hdr_trim_level);
   fprintf(fp, "%s", mesg);

   fclose(fp);

   g_free(mesg);

   return 1;
}

void refresh_mailboxes (int hilite)
{
   GtkWidget *treelocalBoxes = get_widget(frmMain, "treelocalBoxes_item");
   GtkWidget *treeremoteBoxes = get_widget(frmMain, "treeremoteBoxes_item");
   GtkWidget *treespoolBoxes = get_widget(frmMain, "treespoolBoxes_item");
   GtkWidget *item;
   GtkWidget *tree;
   struct mailboxformat *mb;
   FILE *fp;
   gchar buffer[257];
   gint i;
   GList *children;
   GtkTargetEntry target[] = { {"STRING", 0, 1},
  			      {"text/plain", 0, 2}};


   if (!refreshing_boxes)
   {
      refreshing_boxes = TRUE;

      fp = fopen(spruceconf, "rt");
      if (fp == (FILE *)NULL)
         return;
     
      NumMailboxes = 0;
      NumRemoteboxes = 0;
      NumSpoolboxes = 0;

      /* clear the local mailbox tree */
      children = gtk_container_children (GTK_CONTAINER (GTK_TREE_ITEM(treelocalBoxes)->subtree));
      while (children)
      {
         gtk_object_remove_data (GTK_OBJECT (children->data), "mailboxformat");
         gtk_container_remove (GTK_CONTAINER (GTK_TREE_ITEM(treelocalBoxes)->subtree), children->data);
         children = g_list_remove_link (children, children);
      }
      if (GTK_TREE_ITEM (treelocalBoxes)->subtree == NULL)
      {
         tree = gtk_tree_new ();
         gtk_tree_item_set_subtree (GTK_TREE_ITEM(treelocalBoxes), tree);
         gtk_object_set_data (GTK_OBJECT(frmMain), "treelocalBoxes", tree);
         gtk_tree_item_expand (GTK_TREE_ITEM(treelocalBoxes));
      }
      /* clear the remote mailbox tree */
      children = gtk_container_children (GTK_CONTAINER (GTK_TREE_ITEM(treeremoteBoxes)->subtree));
      while (children)
      {
         gtk_object_remove_data (GTK_OBJECT (children->data), "mailboxformat");
         gtk_container_remove (GTK_CONTAINER (GTK_TREE_ITEM(treeremoteBoxes)->subtree), children->data);
         children = g_list_remove_link (children, children);
      }
      if (GTK_TREE_ITEM (treeremoteBoxes)->subtree == NULL)
      {
         tree = gtk_tree_new ();
         gtk_tree_item_set_subtree (GTK_TREE_ITEM(treeremoteBoxes), tree);
         gtk_object_set_data (GTK_OBJECT(frmMain), "treeremoteBoxes", tree);
         gtk_tree_item_expand (GTK_TREE_ITEM(treeremoteBoxes));
      }
      /* clear the /var/spool/mail tree */
      children = gtk_container_children (GTK_CONTAINER (GTK_TREE_ITEM(treespoolBoxes)->subtree));
      while (children)
      {
         gtk_object_remove_data (GTK_OBJECT (children->data), "mailboxformat");
         gtk_container_remove (GTK_CONTAINER (GTK_TREE_ITEM(treespoolBoxes)->subtree), children->data);
         children = g_list_remove_link (children, children);
      }
      if (GTK_TREE_ITEM (treespoolBoxes)->subtree == NULL)
      {
         tree = gtk_tree_new ();
         gtk_tree_item_set_subtree (GTK_TREE_ITEM(treespoolBoxes), tree);
         gtk_object_set_data (GTK_OBJECT(frmMain), "treespoolBoxes", tree);
         gtk_tree_item_expand (GTK_TREE_ITEM(treespoolBoxes));
      }

      while (!feof(fp))
      {
         memset(buffer, 0, 257);
         fgets(buffer, 256, fp);
         trim_leadspc(buffer);
         if (!strncmp("mailbox", buffer, strlen("mailbox")))
	      {
	         mb = g_malloc0 (sizeof(struct mailboxformat));
	         mb->format = 1;
	         strcut(buffer, 0, strlen("mailbox"));
	         trim_whtspc(buffer);
	         item = gtk_tree_item_new_with_label (buffer);
	         gtk_object_set_data (GTK_OBJECT(item), "mailboxformat", mb);
	         gtk_tree_append (GTK_TREE (GTK_TREE_ITEM_SUBTREE (treelocalBoxes)), item);
	         gtk_widget_show (item);

            gtk_signal_connect (GTK_OBJECT (item), "button_press_event",
						              GTK_SIGNAL_FUNC(on_treeBoxes_clicked), NULL);

            /* for some unknown reason this doesn't work, but the one below does...
             * so drag-n-drop is broken for the moment */
            /*gtk_signal_connect (GTK_OBJECT (item), "drag_data_received", GTK_SIGNAL_FUNC(on_treeBoxes_drag_data_recieved), NULL);
            gtk_drag_dest_set (item, GTK_DEST_DEFAULT_ALL, target, 2, GDK_ACTION_MOVE | GDK_ACTION_COPY);*/

	         NumMailboxes++;

            continue;
	      }
	      if (!strncmp("mbox-spool", buffer, strlen("mbox-spool")))
	      {
	         mb = g_malloc0(sizeof(struct mailboxformat));
	         mb->format = 1;
	         strcut(buffer, 0, strlen("mbox-spool"));
	         trim_whtspc(buffer);
	         item = gtk_tree_item_new_with_label (buffer);
	         gtk_object_set_data (GTK_OBJECT(item), "mailboxformat", mb);
	         gtk_tree_append (GTK_TREE (GTK_TREE_ITEM_SUBTREE (treespoolBoxes)), item);
	         gtk_widget_show (item);

            gtk_signal_connect (GTK_OBJECT (item), "button_press_event",
						              GTK_SIGNAL_FUNC(on_treeBoxes_clicked), NULL);

            NumSpoolboxes++;

            continue;
	      }
      }
      /*gtk_signal_connect (GTK_OBJECT (treelocalBoxes), "drag_data_received", GTK_SIGNAL_FUNC(on_treeBoxes_drag_data_recieved), NULL);
      gtk_drag_dest_set (treelocalBoxes, GTK_DEST_DEFAULT_ALL, target, 2, GDK_ACTION_MOVE | GDK_ACTION_COPY);*/

      /* setup the remote mailbox trees */
      for (i = 0; i < NumAccounts; i++)
      {
         if (AccountsList[i].type == TYPE_IMAP)
         {
            item = gtk_tree_item_new_with_label (AccountsList[i].server.hostname);
            gtk_widget_show (item);
            gtk_tree_append (GTK_TREE(GTK_TREE_ITEM_SUBTREE (treeremoteBoxes)), item);
            tree = gtk_tree_new ();
            gtk_tree_item_set_subtree (GTK_TREE_ITEM(item), tree);
            gtk_widget_show (tree);
            gtk_signal_connect (GTK_OBJECT(item), "expand", GTK_SIGNAL_FUNC(on_imaptree_expand),
                               (gpointer) i);
            gtk_signal_connect (GTK_OBJECT(item), "collapse", GTK_SIGNAL_FUNC(on_imaptree_collapse),
                               (gpointer) i);
            gtk_signal_connect (GTK_OBJECT (item), "button_press_event",
						              GTK_SIGNAL_FUNC(on_treeBoxes_clicked), NULL);

            NumRemoteboxes++;
         }
      }
      
      fclose(fp);
     
      if (NumMailboxes)       /* if there are any mailboxes */
      {
         if (hilite == TOP)
         {
            gtk_tree_select_item (GTK_TREE (GTK_TREE_ITEM (treelocalBoxes)->subtree), 0);
            cMbox = 0;
         }
         else
	         if (hilite == STAY)
	         {
			      if (cMbox >= NumMailboxes)
				      cMbox = NumMailboxes - 1;
	         }
	      /*refresh_mail_list(TOP);*/
      }
      else
         cMbox = -1;
     
      refreshing_boxes = FALSE;
   }
}

void refresh_mail_list (gint hilite)
{
   GtkWidget *clist = get_widget(frmMain, "clistMail");
   gint i, max = 0, seen;
   gchar *text[4] = {"Id", "Sender", "Subject", "Date"};
   gchar *mesg = NULL;
   gchar *mailbox;
   gchar mesgid[10];
   struct mailboxformat *mb;
   gchar *msgid;
   GdkFont *unread_font = NULL;
   GdkFont *read_font = NULL;
   GtkStyle *style1, *style2;
  
   if (selected_mailbox == NULL)
   {
   	gtk_clist_clear (GTK_CLIST (clist));
   	return;
   }

   mb = gtk_object_get_data (GTK_OBJECT(selected_mailbox), "mailboxformat");
   if (mb == NULL)
   	return;

   gtk_label_get (GTK_LABEL (GTK_BIN (GTK_WIDGET(selected_mailbox))->child), &mailbox);

   if (!refreshing_maillist)
   {
      refreshing_maillist = TRUE;
      gtk_clist_freeze(GTK_CLIST(clist));
      gtk_clist_clear(GTK_CLIST(clist));
      
      if (unread_mesg_header_font != NULL)
         unread_font = gdk_font_load(unread_mesg_header_font);
      if (read_mesg_header_font != NULL)
         read_font = gdk_font_load(read_mesg_header_font);
         
      if (mb->format == 1)
      {
	      max = mailbox_get_num_mesgs(mailbox);
	      
	      for(i = 1; i <= max; i++)
	      {
	         gtk_clist_append(GTK_CLIST(clist), (gchar**) text);
            if (mailbox[0] == '/')
				{
					printf("getting message %d\n", i); fflush(stdout);
				}
	         mesg = mailbox_get_mesg(i, mailbox);

	         if (mesg == (gchar*)NULL)
	            break;                         /* this is just a temp fix!! */
	         g_snprintf(mesgid, 10, "%d", i);
	         gtk_clist_set_text(GTK_CLIST(clist), i-1, 0, mesgid);
	         gtk_clist_set_text(GTK_CLIST(clist), i-1, 1, mailbox_get_mesg_from(mesg));
	         gtk_clist_set_text(GTK_CLIST(clist), i-1, 2, mailbox_get_mesg_subject(mesg));
	         gtk_clist_set_text(GTK_CLIST(clist), i-1, 3, mailbox_get_mesg_date(mesg));
	         msgid = get_msgid_from_message(mesg);
	         style1 = gtk_widget_get_style(clist);
	         style2 = gtk_style_copy(style1);
	         if (msgid != NULL)
	         {
               if ((!find_msgid(msgid)) && (unread_mesg_header_font != NULL))
               {
                  style2->font = gdk_font_load(unread_mesg_header_font);
                  gtk_clist_set_row_style(GTK_CLIST(clist), i-1, style2);
               }
               else
                  if (find_msgid(msgid) && (read_mesg_header_font != NULL))
                  {
                     style2->font = gdk_font_load(read_mesg_header_font);
                     gtk_clist_set_row_style(GTK_CLIST(clist), i-1, style2);
                  }
            }

            gtk_style_unref(style2);
         	g_free(mesg);
         }
      }
      else
         if (mb->format == 2)
         {
		      max = imap_select_mailbox(AccountsList[mb->account].socket, mailbox);
		      for (i = 1; i <= max; i++)
            {
               mesg = imap_fetch (AccountsList[mb->account].socket, i, 1, &seen);
               strip (mesg, '\r');
               strcat (mesg, "\n\n");

               gtk_clist_append (GTK_CLIST(clist), (gchar **) text);
               g_snprintf (mesgid, 10, "%d", i);
               gtk_clist_set_text (GTK_CLIST (clist), i-1, 0, mesgid);
               gtk_clist_set_text(GTK_CLIST(clist), i-1, 1, mailbox_get_mesg_from(mesg));
               gtk_clist_set_text(GTK_CLIST(clist), i-1, 2, mailbox_get_mesg_subject(mesg));
               gtk_clist_set_text(GTK_CLIST(clist), i-1, 3, mailbox_get_mesg_date(mesg));
	         	
               style1 = gtk_widget_get_style(clist);
               style2 = gtk_style_copy(style1);
               if (seen && (read_mesg_header_font != NULL))
               {
                  style2->font = gdk_font_load(read_mesg_header_font);
                  gtk_clist_set_row_style(GTK_CLIST(clist), i-1, style2);
	         	}
               if (!seen && (unread_mesg_header_font != NULL))
               {
                  style2->font = gdk_font_load(unread_mesg_header_font);
                  gtk_clist_set_row_style(GTK_CLIST(clist), i-1, style2);
               }
	         	
               gtk_style_unref(style2);
               g_free (mesg);
            }
         }

      if(max > 0)     /* if there are messages */
	   {
         if (hilite == TOP)
      	   cMesg = 0;
         else
            if (hilite == STAY)
            {
			      if (cMesg >= max)
                  cMesg = max - 1;
			   }
         gtk_clist_sort (GTK_CLIST (clist));  /* sorts the clist to the default column */
         /*refresh_txtMessage();*/
         cMesg--;
         gtk_clist_select_row(GTK_CLIST(clist), cMesg + 1, 0);
         gtk_clist_moveto(GTK_CLIST(clist), cMesg, 0, 1.0, 0.0);
	   }
      else
      {
         cMesg = -1;
         refresh_txtMessage();
      }

		NumMesgs = max;

      /*gtk_clist_sort (GTK_CLIST (clist));*/  /* sorts the clist to the default column */
      gtk_clist_thaw(GTK_CLIST(clist));
      refreshing_maillist = FALSE;
   }
}

void refresh_txtMessage ()
{
   GtkWidget *txtBody      = get_widget(frmMain, "txtMessage");
   GtkWidget *clistMail    = get_widget(frmMain, "clistMail");
	GtkWidget *clistMime    = get_widget(frmMain, "clistMime");
   guint len, seen;
   gchar *mesg = NULL;
   gchar *header_mesg = NULL;
   gchar *mailbox;
   gchar *mesgid;
   gchar *part;
   GdkFont *fixed_font = NULL;
   struct mailboxformat *mb;

   mime = 0;	

   
   if (!refreshing_message)
   {
      refreshing_message = TRUE;
      gtk_text_freeze(GTK_TEXT(txtBody));

      /* delete all the the text in there */
      len = gtk_text_get_length(GTK_TEXT(txtBody));
      gtk_text_set_point(GTK_TEXT(txtBody), len);
      gtk_text_backward_delete(GTK_TEXT(txtBody), len);

      /* and clear the mime clist */
      if (mime_preferred_part == 0)
      	gtk_clist_clear(GTK_CLIST(clistMime));
		
      if (cMesg >= 0)
      {
         mb = gtk_object_get_data (GTK_OBJECT(selected_mailbox), "mailboxformat");
         if (mb == NULL)
            return;
         gtk_label_get (GTK_LABEL (GTK_BIN (GTK_WIDGET(selected_mailbox))->child), &mailbox);

         /* put the new email in there */
         gtk_clist_get_text(GTK_CLIST(clistMail), cMesg, 0, &mesgid);
         if (mb->format == 1)
         	mesg = mailbox_get_mesg(atoi(mesgid), mailbox);
         if (mb->format == 2)
         	mesg = imap_fetch(AccountsList[mb->account].socket, atoi(mesgid), 0, &seen);
         
         /* since old messages may not have been stripped by pop3io... */
         /*strip(mesg, '\r');*/

         header_mesg = g_strdup(mesg);
         
         if(mime_detect(mesg))
         {
         	mime = 1;
            mime_parse(mesg);
         }
         else
         	trim_header(header_mesg, hdr_trim_level);
         
         
         /* Load a fixed font */
         if (mesg_body_font != (gchar*) NULL)
            fixed_font = gdk_font_load (mesg_body_font);

         if (hdr_trim_level > 0 && mime_preferred_part == 0)
         {
            GdkColormap *cmap;
            GdkColor colour;
            gchar *hdrstripped;
            gint  hdrlen;

            /* Get the system colour map and allocate the colour blue */
            cmap = gdk_colormap_get_system();
            colour.red = 0;
            colour.green = 0;
            colour.blue = 0xffff;
            if (!gdk_color_alloc(cmap, &colour))
               g_error("couldn't allocate colour");

            hdrlen = get_header_len(header_mesg);
            hdrstripped = get_trimmed_header(header_mesg, hdr_trim_level, hdrlen);
            gti (GTK_TEXT (txtBody), fixed_font, &colour, NULL, hdrstripped, -1);
            gti (GTK_TEXT (txtBody), fixed_font, &colour, NULL, "\n\n", -1);
            g_free(hdrstripped);
         }
         
         if (mime)
         {
            if (mime_preferred_part == 0)
               part = mime_get_part(mesg, mime_get_first_text(), &len);
            else
               part = mime_get_part(mesg, mime_preferred_part, &len);

            if (part != (gchar*) NULL)
            {
               gti (GTK_TEXT (txtBody), fixed_font, NULL, NULL, part, -1);
               g_free(part);
            }
            else
            {
               trim_header(mesg, 0);
               gti (GTK_TEXT (txtBody), fixed_font, NULL, NULL, mesg, -1);
            }
            
         }
         else
         {
            trim_header(mesg, 0);
            gti (GTK_TEXT (txtBody), fixed_font, NULL, NULL, mesg, -1);
         }

	      if (mime_preferred_part == 0 && mime)
            refresh_clistMime();
            
         g_free(mesg);
         g_free(header_mesg);
      }

      gtk_text_thaw(GTK_TEXT(txtBody));
      mime_preferred_part = 0;
      refreshing_message = FALSE;
   }
}

void refresh_clistMime()
{
	GtkWidget *clist = get_widget(frmMain,"clistMime");
	GList *tmp;
	gchar *text[4], id[16], len[32], type[128], name[128];
	gint i, ret;

	gtk_clist_clear(GTK_CLIST(clist));
	
	if(g_list_length(mime_parts) > 1)
   {
		i = 1;
		tmp = mime_parts;
		while(tmp != NULL)
      {
			sprintf(id, "%d", i);
			text[0] = id;
			sprintf(type, "%s/%s", ((struct mime_part *)tmp->data)->type,
					((struct mime_part *)tmp->data)->subtype);
			text[1] = type;
			ret = mime_get_parameter_value(((struct mime_part *)tmp->data)->parameter, "name", name);
			if(ret)
				text[2] = name;
			else
				text[2] = NULL;
			sprintf(len, "%d", ((struct mime_part *)tmp->data)->len);
			text[3] = len;
			gtk_clist_append(GTK_CLIST(clist), text);
			i++;
			tmp = tmp->next;
		}
	}
}

void clistMail_update()
{
   GtkWidget *clistMail = get_widget(frmMain, "clistMail");
   gint i, y;
   guint mid, tlid, tmid;   /* message id, temp clist id, temp message id */
   gchar newid[10];
   gchar *mesgid = NULL;
   guint *lids, *mids;     /* clist ids, mesg ids */
   guint clist_size = 0;
   GList *selection;

   /* Lock the list while updating. */
   gtk_clist_freeze(GTK_CLIST(clistMail));

   /* Determine how many items were selected. */
   y = 0;
   selection = GTK_CLIST(clistMail)->selection;
   clist_size = g_list_length(selection);

   lids = (guint *)g_malloc0(sizeof(guint) * clist_size);
   mids = (guint *)g_malloc0(sizeof(guint) * clist_size);

   selection = GTK_CLIST(clistMail)->selection;
   for (y = 0; selection != (GList *)NULL; y++)
   {
      /* Add each id. */
      lids[y] = (guint)selection->data;
      gtk_clist_get_text(GTK_CLIST(clistMail), lids[y], 0, &mesgid);
      mids[y] = atoi(mesgid);

      selection = selection->next;
   }

   /* Sort the ids. */
   for (y = 0; y == 0; y = 1)
   {
      for (i = 0; i < clist_size - 1; i++)
      {
         /* Swap ids if current id is greather than next. */
         if (lids[i] > lids[i+1])
         {
            tlid = lids[i];
            tmid = mids[i];
            lids[i] = lids[i+1];
            mids[i] = mids[i+1];
            lids[i+1] = tlid;
            mids[i+1] = tmid;

	         /* Set flag to continue sorting. */
            y = 0;
         }
      }
   }

   /* Remove the clist items in reverse order, using a temporary copy. */
   for (y = clist_size - 1; y >= 0; y--)
   {
      gtk_clist_remove(GTK_CLIST(clistMail), lids[y]);
      NumMesgs--;
   }

   /* Modify each of the clist items to show their new id numbers, iterating 
      in reverse order to keep the algorithm simple. */
   for (y = clist_size - 1; y >= 0; y--)
   {
      for (i = 0; i < NumMesgs; i++)
      {
         /* Decrement the messageg id of all messages with ids greater than 
            the one we deleted. */
         gtk_clist_get_text(GTK_CLIST(clistMail), i, 0, &mesgid);
         mid = atoi(mesgid);
         if (mid > mids[y])
         {
            /* this message id needs to be decremented */
            g_snprintf(newid, 10, "%d", mid - 1);
            gtk_clist_set_text(GTK_CLIST(clistMail), i, 0, newid);
         }
      }
   }

   cMesg = (cMesg >= NumMesgs ? NumMesgs - 1 : cMesg);
   g_free(lids);
   g_free(mids);

   /* Remove the lock on the compound list. */
   gtk_clist_thaw(GTK_CLIST(clistMail));
}


void read_sizes (void)
{
   GtkWidget *clistMail = get_widget(frmMain, "clistMail");
   FILE *fp;
   gchar buffer[256], *field;
   gint width, heigth, i;

   if (save_sizes)
   {
      fp = fopen(spruceconf, "rt");
      if(fp == NULL)
      {
         fprintf(stderr, "Spruce: %s failed to open for reading.\n", spruceconf);
         fprintf(stderr, "Please check with your local Administrator.\n");
         return;
      }

      while (!feof(fp))
      {
         fgets(buffer, 256, fp);
         trim_leadspc(buffer);
         if (buffer[0] != '#' && buffer[0] != '\n')
         {
            if (!strncmp("spruce-sizes", buffer, strlen("spruce-sizes")))
            {
               strcut(buffer, 0, strlen("spruce-sizes"));
               trim_whtspc(buffer);
               if (!strcmp("",buffer))
                  continue;

               field = get_field(buffer, 1, ':');
               width = atoi(field);
               g_free(field);

               field = get_field(buffer, 2, ':');
               heigth = atoi(field);
               g_free(field);

               gtk_widget_set_usize(frmMain, width, heigth);

               i = 0;
               while (i < GTK_CLIST(clistMail)->columns)
               {
                  field = get_field(buffer, i+3, ':');
                  gtk_clist_set_column_width (GTK_CLIST(clistMail), i, atoi(field));
                  g_free(field);
                  i++;
               }
            }
         }
      }	
   }
}

gchar *get_msgid_from_message(gchar *message)
{
   static gchar buffer[512];
   gchar *msgid;
   gchar *str, *end, *start, *ptr, *endptr;

   str = g_strdup(message);

   endptr = strstr(str, "\n\n");
   if (endptr == (gchar*) NULL)
   {
      g_free(str); 
      return (gchar*) NULL;
   }
   *endptr = '\0';

   ptr = strstrcase(str, "Message-ID: ");
   if (ptr == (gchar*) NULL) 
   {
      g_free(str);
      return (gchar*) NULL;
   }

   start = ptr + strlen("Message-ID: ");   /* beginning of mesg id */
   for (end = start; *end != '\n' && *end != '\0'; end++);
   if ( *(end-1) != '>')
   {
      *end = '>';
      end++;
   }
   *end = '\0';                /* NULL terminate mesg id */

   memset(buffer, 0, sizeof(buffer));
   if (*start == '<')
      strncpy(buffer, start, sizeof(buffer)-1);
   else
   {
      buffer[0] = '<';
      strncat(buffer, start, sizeof(buffer)-1);
   }

   msgid = (gchar*) buffer;

   return (gchar*) msgid;
}

void update_messageStatus()
{
   GtkWidget *clistMail  = get_widget(frmMain, "clistMail");
   gchar *mesg = NULL;
   gchar *mailbox;
   gchar *mesgid;
   GtkStyle *rowstyle = NULL;
   GtkStyle *newrowstyle = NULL;
   gchar *msgid = NULL; 
   struct mailboxformat *mb;

   mb = gtk_object_get_data (GTK_OBJECT(selected_mailbox), "mailboxformat");
   if (mb == NULL)
   	return;

   gtk_label_get (GTK_LABEL (GTK_BIN (GTK_WIDGET(selected_mailbox))->child), &mailbox);

   if (cMesg >= 0)
   {
      gtk_clist_get_text(GTK_CLIST(clistMail), cMesg, 0, &mesgid);	
      if (mb->format == 1)
      {
         mesg = mailbox_get_mesg(atoi(mesgid), mailbox);
         msgid = get_msgid_from_message(mesg);
         if (msgid != (gchar*) NULL)
         {
            if (!find_msgid(msgid))
            {
               add_msgid(msgid);
               if (read_mesg_header_font !=  NULL)
               {
                  rowstyle = gtk_clist_get_row_style(GTK_CLIST(clistMail), cMesg);		
                  newrowstyle = gtk_style_copy(rowstyle);
                  newrowstyle->font = gdk_font_load (read_mesg_header_font);
                  gtk_clist_set_row_style(GTK_CLIST(clistMail), cMesg, newrowstyle);
                  gtk_style_unref(newrowstyle);
               }
            }
         }
      }
      g_free(mesg);
   }
}
