;;;
;;;               im-wl -- IM interface for Wanderlust.
;;;                          ...not completed.
;;;
;;; Copyright (C) 1998 OKUNISHI Fujikazu <fuji0924@mbox.kyoto-inet.or.jp>
;;; Copyright (C) 1998 Yuuichi Teranishi <teranisi@gohome.org>
;;;
;;; Author: OKUNISHI Fujikazu <fuji0924@mbox.kyoto-inet.or.jp>
;;;         Yuuichi Teranishi <teranisi@gohome.org>
;;; Keywords: mail, news, Wanderlust, IM

;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Emacs; see the file COPYING.  If not, write to the
;;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;;; Boston, MA 02111-1307, USA.
;;;

;;;
;;;  Setting:
;;;  (autoload 'wl-draft-send-with-imput-async "im-wl")
;;;  (setq wl-draft-send-func 'wl-draft-send-with-imput-async)
;;;  or 
;;;  (autoload 'wl-draft-send-with-imput "im-wl")
;;;  (setq wl-draft-send-func 'wl-draft-send-with-imput)

;;; Code:
(require 'emu)

;;; Variables:
(defvar im-wl-debug nil)

(defvar im-wl-prog-touch "utime"
  "Program to update time stamp.")

(defvar im-wl-prog-imput "imput"
  "Program to post an article.
This is most commonly `imput(impost)' or `inews'.")

(defvar im-wl-prog-imput-args '("-h" "-watch" "--debug=no" "--Queuing=yes")
  "Switches for wl-draft-send-by-imput to pass to `inews' for posting an article.")

(defvar im-wl-prog-imput-error-msg (format "^%s: ERROR:" im-wl-prog-imput)
  "Error message of im-wl-imput-program.")

(defvar im-wl-default-temp-file-name "~/.imput-temp"
  "Default temporary file name (for async).")

;(defvar im-wl-real-send-hook nil
;  "Hook called before really sending a message.")

;(defvar nnspool-rejected-article-hook nil
;  "*A hook that will be run when an article has been rejected by the server.")

;; Buffer local variables (For async).
(defvar im-wl-buffer-editing-buffer nil)
(defvar im-wl-buffer-sending-buffer nil)
(defvar im-wl-buffer-kill-when-done nil)
(make-variable-buffer-local 'im-wl-buffer-editing-buffer)
(make-variable-buffer-local 'im-wl-buffer-sending-buffer)
(make-variable-buffer-local 'im-wl-buffer-kill-when-done)



(defun wl-draft-send-with-imput (editing-buffer kill-when-done) 
  "Send the message in the current buffer with imput. "
  (unless (as-binary-process (funcall 'wl-draft-send-with-imput-internal))
    (error "%s: failed!" im-wl-prog-imput))
  (when kill-when-done
    ;; hide editing-buffer.
    (wl-draft-hide editing-buffer)
    ;; delete editing-buffer and its file.
    (wl-draft-delete editing-buffer)
    ))

(defun wl-draft-send-with-imput-async (editing-buffer kill-when-done)
  "Send the message in the current buffer with imput asynchronously."
  (let (buffer-process 
	(sending-buffer (current-buffer))
	(msg (save-excursion
	       (set-buffer editing-buffer)
	       (or wl-draft-buffer-file-name
		   (setq wl-draft-buffer-file-name
			 (expand-file-name
			  im-wl-default-temp-file-name))))))
    ;; current buffer is raw buffer.
    (save-excursion
      (goto-char (point-max))
      ;; require one newline at the end.
      (or (= (preceding-char) ?\n)
	  (insert ?\n))
      ;; Change header-delimiter to be what imput expects.
      (let ((case-fold-search t))
	(save-restriction
	  (std11-narrow-to-header mail-header-separator)
	  ;; Insert Message-ID: 'cause wl-do-fcc() does not take care..
	  (goto-char (point-min))
	  (when (and wl-insert-message-id
		     (not (re-search-forward "^Message-ID[ \t]*:" nil t)))
	    (insert (concat "Message-ID: "
			    (wl-draft-make-message-id-string) "\n")))
	  ;; Insert date field.
	  (goto-char (point-min))
	  (or (re-search-forward "^Date[ \t]*:" nil t)
	      (wl-draft-insert-date-field)))
	(run-hooks 'wl-mail-send-pre-hook) ;; X-PGP-Sig, Cancel-Lock
	(goto-char (point-min))
	(re-search-forward
	 (concat "^" (regexp-quote mail-header-separator) "\n") nil t)
	(replace-match "\n")
	(backward-char 1)
	(setq delimline (point-marker))
	;; ignore any blank lines in the header
	(goto-char (point-min))
	(while (and (re-search-forward "\n\n\n*" delimline t)
		    (< (point) delimline))
	  (replace-match "\n"))
	;; Find and handle any FCC fields. 
	;; 'cause imput can NOT handle `Fcc: %IMAP'.
	(goto-char (point-min))
	(if (re-search-forward "^FCC:" delimline t)
	    (wl-draft-do-fcc delimline))))
    (set-buffer-modified-p t)
    (as-binary-output-file
     (write-region (point-min)(point-max) msg nil t))    
    (set-buffer (generate-new-buffer " *Wl Watch*"))
    (setq im-wl-buffer-sending-buffer sending-buffer)
    (setq im-wl-buffer-editing-buffer editing-buffer)
    (setq im-wl-buffer-kill-when-done kill-when-done)
    (setq buffer-process
	  (as-binary-process
	   (apply (function start-process)
		  "IMPUT" (current-buffer) im-wl-prog-imput
		  (append (list "-draftmessage" msg
				"--preserve=on" "-verbose")
			  im-wl-prog-imput-args))))
    (set-process-sentinel buffer-process 'im-wl-watch-process-async)
    (message "Sending a message in background")
    (if kill-when-done
	(wl-draft-hide editing-buffer))
    ))


;;; Internal functions.

;;; nnspool-request-post()
(defun wl-draft-send-with-imput-internal ()
  "Post a new article in current buffer."
  (unwind-protect
      (save-excursion
	(goto-char (point-max))
	;; require one newline at the end.
	(or (= (preceding-char) ?\n)
	    (insert ?\n))
	;; Change header-delimiter to be what imput expects.
	(goto-char (point-min))
	(let ((case-fold-search t))
	  (save-restriction
	    (std11-narrow-to-header mail-header-separator)
	    ;; Insert Message-ID: 'cause wl-do-fcc() does not take care..
	    (goto-char (point-min))
	    (when (and wl-insert-message-id
		       (not (re-search-forward "^Message-ID[ \t]*:" nil t)))
	      (insert (concat "Message-ID: "
			      (wl-draft-make-message-id-string) "\n")))
	    ;; Insert date field.
	    (goto-char (point-min))
	    (or (re-search-forward "^Date[ \t]*:" nil t)
		(wl-draft-insert-date-field)))
	  (run-hooks 'wl-mail-send-pre-hook) ;; X-PGP-Sig, Cancel-Lock
	  (goto-char (point-min))
	  (re-search-forward
	   (concat "^" (regexp-quote mail-header-separator) "\n") nil t)
	  (replace-match "\n")
	  (backward-char 1)
	  (setq delimline (point-marker))
	  ;; ignore any blank lines in the header
	  (goto-char (point-min))
	  (while (and (re-search-forward "\n\n\n*" delimline t)
		      (< (point) delimline))
	    (replace-match "\n"))	
	  ;; Find and handle any FCC fields. 
	  ;; 'cause imput can NOT handle `Fcc: %IMAP'.
	  (goto-char (point-min))
	  (if (re-search-forward "^FCC:" delimline t)
	      (wl-draft-do-fcc delimline)))
	(let* ((inews-buffer (generate-new-buffer " *wl Watch*"))
	       (status
		(condition-case nil ;; err?
		    (as-binary-process
		     (apply 'call-process-region (point-min) (point-max)
			    im-wl-prog-imput nil inews-buffer nil
			    im-wl-prog-imput-args))))
	       (debug-on-error im-wl-debug))
	  (if (and (= 0 status)
	           (im-wl-watch-process inews-buffer))
	      ;; The inews program successed.
	      t ;; rc
	    ;; failed
	    nil)))))

;;; nnspool-inews-sentinel()
(defun im-wl-watch-process (buf)
  (save-excursion
    (set-buffer buf)
    (goto-char (point-min))
    (if (or (zerop (buffer-size)) ;; for inews
            (null (re-search-forward im-wl-prog-imput-error-msg nil t)))
	(progn
	  (kill-buffer buf)
	  t) ;; rc = t
      ;; abnormal status
      (kill-buffer buf)
      nil) ;; rc = nil
    ))

(defun im-wl-watch-process-async (process event)
  (let ((process-buffer (process-buffer process))
	editing-buffer kill-when-done raw-buffer)
    (set-buffer process-buffer)
    (setq editing-buffer im-wl-buffer-editing-buffer)
    (setq kill-when-done im-wl-buffer-kill-when-done)
    (setq raw-buffer im-wl-buffer-sending-buffer)
    (goto-char (point-min))
    (if (null (re-search-forward im-wl-prog-imput-error-msg nil t))
	(progn
	  ;; sent successfully.
	  (kill-buffer raw-buffer)
	  (kill-buffer process-buffer)
	  (if kill-when-done
	      (wl-draft-delete editing-buffer))
	  )
      (ding)
      (message "Send failed")
      (kill-buffer raw-buffer)
      (switch-to-buffer editing-buffer)
      (condition-case ()
	  (progn
	    (split-window-vertically)
	    (select-window (next-window)))
	(error)) ; ignore error.
      (switch-to-buffer process-buffer)
      (beginning-of-line)
      )))


;;; NOT implemented yet.
(defconst im-wl-DOSfs
  (or (memq system-type '(OS/2 emx windows-nt))
      (not (fboundp 'make-symbolic-link))))

(defun im-wl-touch-folder (target)
  (if (not im-wl-DOSfs)
      ()
    (let* ((target (expand-file-name target))
           (dir (if (file-directory-p dir) dir
		  (file-name-directory dir))))
      (if (string-match "\\(.*\\)/$" dir)
          (setq dir (substring dir  (match-beginning 1) (match-end 1))))
      (call-process im-wl-prog-touch nil nil nil dir))))


(provide 'im-wl)

;;; im-wl.el ends here


