;;;
;;; Wanderlust -- Yet Another Message Interface on Emacsen.
;;;
;;; Copyright (C) 1998 Yuuichi Teranishi <teranisi@gohome.org>
;;;
;;; Time-stamp: <99/05/15 16:53:11 teranisi>

;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Emacs; see the file COPYING.  If not, write to the
;;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;;; Boston, MA 02111-1307, USA.
;;;

(require 'wl-vars)
(provide 'wl-demo)
(if (featurep 'xemacs)
    (require 'wl-xmas))

(eval-when-compile
  (or (fboundp 'startup-center-spaces)
      (defun startup-center-spaces (a)))
  (or (fboundp 'make-extent)
      (defun make-extent (a b)))
  (or (fboundp 'make-glyph)
      (defun make-glyph (a)))
  (or (fboundp 'set-extent-end-glyph)
      (defun set-extent-end-glyph (a b)))
  (unless (boundp ':data)
	(make-local-variable ':data)
	(eval (list 'setq ':data nil))))
;;
;; demo ;-)
;;
(and window-system
     (featurep 'xemacs)
     (featurep 'xpm)
     (eval-when-compile
       (if (featurep 'xemacs)
	   (defmacro wl-title-logo ()
	     (and (file-exists-p (expand-file-name 
				  "etc/wl-logo.xpm"
				  ))
		  (let ((buffer (generate-new-buffer " *wl-logo*"))
			(coding-system-for-read 'binary)
			buffer-file-format format-alist
			insert-file-contents-post-hook
			insert-file-contents-pre-hook)
		    (prog1
			(save-excursion
			  (set-buffer buffer)
			  (insert-file-contents (expand-file-name 
						 "etc/wl-logo.xpm"
						 ))
			  (buffer-string))
		      (kill-buffer buffer)))))
	 (defmacro wl-title-logo () )
	 )))

(defconst wl-title-logo
  (and window-system
       (featurep 'xemacs)
       (featurep 'xpm)
       (wl-title-logo)))

(defun wl-demo ()
  (interactive)
  (let ((demo-buf (get-buffer-create "*WL Demo*"))
	wl-logo elmo-logo logo-ext title-start)
    (switch-to-buffer demo-buf)
    (erase-buffer)
    (if wl-title-logo
	(progn
	  (setq wl-logo (make-glyph (vector 'xpm :data wl-title-logo)))
	  (insert-char ?\n (max 1 (- (/ (window-height) 3) 2)))
	  (indent-to (startup-center-spaces wl-logo))
	  (insert-char ?\ (max 0 (/ (- (window-width) 68) 2))) 
	  (setq logo-ext (make-extent (point)(point)))
	  (set-extent-end-glyph logo-ext wl-logo))
      (insert-char ?\n (max 1 (- (/ (window-height) 3) 2))))
    (setq title-start (point))
    (insert (format "\n%s\nversion %s - \"%s\"\n\n"
		    (if wl-title-logo "" wl-appname) wl-version wl-codename
		    ))
    (insert "Copyright (C) 1998, 1999 Yuuichi Teranishi <teranisi@gohome.org>")
    (put-text-property (point-min) (point-max) 'face 'wl-highlight-demo-face)
    (let ((fill-column (window-width)))
      (center-region title-start (point)))
    (goto-char (point-min))
	(if wl-on-nemacs
		(sit-for 1)
	  (sit-for 0.5))
;    (delete-extent logo-ext)
    demo-buf))
