/*********************************************************************

** This library uses the netcdf - version 2.4.3 which is
** Copyright 1993-1997 University Corporation for Atmospheric Research/Unidata

** The netcdf library is provided as per the terms of the
** UCAR/Unidata license

** See interface/netcdf-2.4.3/COPYRIGHT for the full notice

********************************************************************/

/* $Id: diskio_utilfunc.c,v 1.3 1997/08/04 04:18:19 dhb Exp $ */
/* $Log: diskio_utilfunc.c,v $
 * Revision 1.3  1997/08/04 04:18:19  dhb
 * include of strings.h does not work under Solaris.  Include
 * of string.h should suffice.
 *
 * Revision 1.2  1997/07/26 00:12:00  venkat
 * Added
 * */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <varargs.h>
#include <sys/types.h>

#include "interface/absff_ext.h"
#include "diskio_ext.h"


void ffError(format, va_alist)
	char *format;
va_dcl
{
	char error[256];
	va_list args;

	va_start(args);
	vsprintf(error, format, args);
	va_end(args);	 

	fprintf(stderr, "Error: %s\n", error);
}

char * ParentDiskio_Interface(elm)
 Element *elm; 
{
  Element *parentofelm;

  parentofelm = elm->parent;

  if(strcmp(BaseObject(parentofelm)->name, "variable") == 0) 
	return ((struct Gen_Diskio_Type *)(parentofelm->parent))->adi;
  else if(strcmp(BaseObject(parentofelm)->name, "diskio") == 0)
	return ((struct Gen_Diskio_Type *)(parentofelm))->adi;
  else
	return (NULL);
}

char *ParentVariable_Interface(elm)
 Element *elm;
{
 Element *parentofelm;

 parentofelm = elm->parent;

 if(strcmp(BaseObject(parentofelm)->name, "variable") == 0) 
	return ((struct Gen_Variable_Type *)(parentofelm))->avi;
 else
	return (NULL);
}

char *SelfVariable_Interface(elm)
 Element *elm;
{
 if(strcmp(BaseObject(elm)->name, "variable") == 0) 
	return ((struct Gen_Variable_Type *)(elm))->avi;
 else
	return (NULL);
}

char *SelfMetadata_Interface(elm)
 Element *elm;
{
 if(strcmp(BaseObject(elm)->name, "metadata") == 0) 
	return ((struct Gen_Metadata_Type *)(elm))->amdi;
 else
	return (NULL);
}

char * ffCreateName(genesis_name, genesis_index)
 char *genesis_name;
 int genesis_index;
{
 char *buf;
 char locbuf[10];
 int namesize;

 if(genesis_name == NULL) return NULL;
  
 namesize = strlen(genesis_name) + 1; 
 buf = (char *) malloc(sizeof(char) * namesize);
 strcpy(buf, genesis_name);
 if(genesis_index != 0) {
	namesize += (strlen("-_")+1);
	buf = (char *) realloc(buf, namesize); 
 	strcat(buf, "-_");

 	sprintf(locbuf, "%d", genesis_index);
	namesize += (strlen(locbuf)+1);
	buf = (char *) realloc(buf, namesize);
 	strcat(buf, locbuf);
 }
 return buf;
}

char * ffRecreateName(nameinfile, index_val)
 char *nameinfile;
 int *index_val;
{
  char* genesis_name;
  char index_part[10];
  char *ptr;

  if(nameinfile == NULL || index_val == NULL) return NULL;

  ptr = strstr(nameinfile,  "-_");
  if(ptr != NULL){
	*ptr = '\0'; genesis_name = CopyString(nameinfile);
	ptr+=2; /* go past the "-_" */
	if(ptr != NULL) {
		strcpy(index_part, ptr);	
		*index_val = atoi(index_part);
	}
	else
		*index_val = 0;
  }
  else{
	genesis_name = CopyString(nameinfile);
	*index_val = 0;
  }
  return genesis_name;
} 

long ffParseIndexedField(field)
 char *field;
{
 char *indexpart, *ptr;
 long indexval;
 char buf[BUFSIZ];
 char val[2];

 indexpart = strchr(field, '[');

 if(indexpart == NULL) return -1;
  
 val[1] = '\0';
 strcpy(buf, "");
 for(ptr=indexpart+1; ptr != NULL && *ptr != ']'; ptr++) {
        val[0] = *ptr;
        strcat(buf, val);
 }
 
 indexval = Absff_Atol(buf);
 return indexval;
}


long ffParseWhiteSpacedString(string, eachstr)
 char *string;
 char **eachstr;
{
  long nstrings;
  char *ptr;

  if(string == NULL || eachstr == NULL) 
	return 0;

  nstrings=0; 

  for(ptr=string; ptr != NULL; ptr++) {
	if(*ptr == ' '){
		string++;
		continue;
	}
	ptr = strchr(string, ' ');	
	if(ptr == NULL){
		eachstr[nstrings] = CopyString(string);
		nstrings++;
		break;
	}
	else{
		*ptr = '\0';
		eachstr[nstrings] = CopyString(string);
		nstrings++;
		string+=(int)(ptr-string+1);
	}
  }
	
  return nstrings;
} 
  

void Expand_And_Copy_String(copybuf, origbuf)
 char **copybuf, *origbuf;
{
  int spacesize;
  int newsize;

  if(copybuf == NULL || *copybuf == NULL || origbuf == NULL) return;

  spacesize = 1;
  newsize = spacesize;

  *copybuf = (char *) realloc(*copybuf, newsize * sizeof(char));
  strcat(*copybuf, " ");

  newsize = strlen(origbuf) + 1 ;
  *copybuf = (char *) realloc(*copybuf, newsize*sizeof(char)); 
  strcat(*copybuf, origbuf); 
}
