/*********************************************************************

** This library uses the netcdf - version 2.4.3 which is
** Copyright 1993-1997 University Corporation for Atmospheric Research/Unidata

** The netcdf library is provided as per the terms of the
** UCAR/Unidata license

** See netcdf-2.4.3/COPYRIGHT for the full notice

********************************************************************/
/* $Id: absff_struct.h,v 1.4 1997/08/08 00:30:52 dhb Exp $ */
/* $Log: absff_struct.h,v $
 * Revision 1.4  1997/08/08 00:30:52  dhb
 * Added aix as one of the systems to avoid uchar definition on.
 *
 * Revision 1.3  1997/08/03 20:04:02  dhb
 * Added additional ifdefs for ulong and uchar typedefs to avoid
 * similar standard typedefs on Paragon and T3E.
 *
 * Revision 1.2  1997/07/26 00:15:24  venkat
 * Added-Copyright-notice-and-RCS-headers
 * */

#ifndef ABS_STRUCT_H
#define ABS_STRUCT_H

/* Maybe useful typedefs for  generic 8-bit data type */

#if defined(BSD) && !(defined(Linux) || defined(FreeBSD) || defined(T3E))
typedef unsigned long ulong;
#endif

#if !defined(Paragon) && !defined(T3E) && !defined(aix)
typedef unsigned char uchar;
#endif

typedef char byte;

/* Enum that defines the basic data types used by fileformats */

typedef enum {
	/*8-bit signed & unsigned */
	abs_uint8=0,
	abs_int8,
	/*16-bit unsigned & signed*/
	abs_uint16,	
	abs_int16,
	/*32-bit unsigned & signed */
	abs_uint32,
	abs_int32,
	/*64-bit unsigned & signed */
	abs_uint64,
	abs_int64,
	/** 32 and 64-bit floating points **/
	abs_float32,
	abs_float64,
	/** 8-bit signed and unsigned char, unicode(16-bit char) and strings(??) **/
	abs_uchar8,
	abs_char8,
	abs_char16,
	abs_string
}Abs_Type;

/* A union of the various allowed types - Could be useful in certain cases */
typedef union{
	uchar uchar_value;
	char char_value;
	ushort ushort_value;
	short short_value;
	uint uint_value;
	int int_value;
	ulong ulong_value;
	long long_value;
	float float_value;
	double double_value;
	/* Need to add something for 16-bit chars here */
	char *string_value;
}Abs_ComponentValue;

/* Typedefs for the essential interface structs */
typedef struct Abs_Diskio_Type 		Abs_Diskio;
typedef struct Abs_Metadata_Type 	Abs_Metadata;
typedef struct Abs_Variable_Type 	Abs_Variable;


/* Structure that defines the shape of a variable in terms of 
	domains or dimensions */
typedef struct Abs_Varshape_Type {
	int ndomains;
	char **domainname;
	long *domainsize;
	byte *domaintype; /* UNLIMITED or not */
}Abs_Varshape;

/** The Abstract DiskIO structure **/
/**
  This interfaces between client code and the physical file on disk.
    At the moment the works are not there to deal with the file in many
    ways other than opening/creating it in a particular mode and writing/reading 
    from it and eventually closing it. Features such as dynamically 
    switching between files, changing the mode of access and physically deleting
    the file will probably be added in future.

    One important issue that needs to be addressed well in future is the 
    coordinate variable business. To the library (for Netcdf) this is just 
    another variable but with the same name as a dimension in the file. So
    no special constructors/destructors are provided for it but the diskio 
    interface struct has handles to an array (size=MAX_COORD_VAR) of these
    variable interfaces that are allocated in the client code. (CREATE action for
    the gen_variable object in Genesis). Support is therfore provided in this interface for any
    number of  multi-dimensional variables  but for no more than MAX_COORD_VAR coord variables 
**/

#define ABS_DISKIO_TYPE \
	char			*filename; \
	short			is_open; \
	short 			is_writable; \
\
	int 			nglobmetadata; \
	char 			**globmetadatanames; \
	int 			nvariables; \
	char 			**variablenames; \
\
/* Methods to be overridden by individual file format diskios*/ \
	Abs_Metadata*		(*ConstructMetadata_Interface) (/* char *name, Abs_Type type, long size */); \
	Abs_Variable*		(*ConstructVariable_Interface) (/* char *name, Abs_Type type, Abs_Varshape* */); \
	/* \
	int			(*SetAccessmode) (); \
	int			(*GetAccessmode) (); \
	*/ \
	int			(*Flush) (); \
	int			(*Destruct)(); \
\
/* Public methods to deal with coordinate variables in particular - overriden by specific file formats */ \
	int			(*IsCoordVariable)(); /* args=char *varname */ \
	Abs_Variable*		(*ConstructCoord_Interface)(/*char *coordvarname*/); \
\
/* Methods added to deal with backwards compatibility with disk_out/disk_in */ \
	int			(*SetFile)(); /*args=char *filename, char accessmode */ \
/* Private methods */ \
	int 			(*OpenFile)();/*args=char *filename, char accessmode */	\
	void			(*GatherInfo)(); \
\
/* These methods are generic interface methods pertaining to the format in general \
   rather than any component in the format - should be overridden by \
   subclass methods */	\
	char* 			(*CreateIndexedName)(); /* args=char *clientname, int index */ \
	char*			(*RecreateNameAndIndex)(); /*args= char *nameinfile, int *index	*/

struct Abs_Diskio_Type {
	ABS_DISKIO_TYPE
};

/* The abstract metadata structure */

#define ABS_METADATA_TYPE \
/* Handles to the parent components in the file format */ \
	Abs_Diskio		*adi; \
	Abs_Variable		*avi; \
/* value addr is cached to deal with non-garbage-collecting file formats */ \
	void 			*vals; \
/* type and size are cached so genesis string args can be converted easily */ \
	Abs_Type		abstype; \
	long 			size; \
/* These are private methods called from the metadata constructors */ \
	int			(*Create)(); /* args = Abs_Type type, long size */ \
/* Public methods to be overridden by individual metadata objects */ \
	int			(*SetType)(); /* arg=Abs_Type type*/ \
	int			(*SetSize)(); /* arg=long size */ \
	int			(*SetValues)(); /*args=void *vals,long start_index,long count */ \
	int			(*SetValuesFromString)(); /*args=char **vals, long start_index, long count*/ \
	Abs_Type		(*GetType)(); \
	long			(*GetSize)(); \
	int			(*GetValues)();/*args=void *vals,long start_index,long count */ \
	int			(*GetValuesAsString)(); /*args=char **vals, long start_index, long count*/ \
\
	int			(*Rename)(); /*args=char *newname */ \
	int			(*Delete)(); \
	int			(*Flush) (); \
	int			(*Destruct)();

struct Abs_Metadata_Type {
	ABS_METADATA_TYPE
};

/* Abs_Metadata methods */
/*private: */
extern int Absff_CreateMetadata(/* Abs_Type type, int size */);
/*public: */
extern int Absff_SetMetadataType(/* Abs_Type type */);
extern int Absff_SetMetadataSize(/* int size */);
extern int Absff_SetMetadataValues(/*void *vals, int start, int count */);
extern int Absff_SetMetadataValuesFromString(/*char **vals, int start, int count */);

extern Abs_Type Absff_GetMetadataType();
extern long Absff_GetMetadataSize();
extern int Absff_GetMetadataValues(/*void *vals, int start, int count */);
extern int Absff_GetMetadataValuesAsString(/* char **vals, int start, int count */);

#define ABS_VARIABLE_TYPE \
/* Handle to the parent component in the file format */ \
	Abs_Diskio 		*adi;	 \
\
	int			nlocalmetadata; \
	char 			**localmetadatanames; \
\
/* The shape of the var is cached to avoid inquiring the library often */ \
	Abs_Varshape 		*varshape; \
/* The type is cached so genesis string args can be converted easily */ \
	Abs_Type		abstype; \
/* These are private methods */ \
	int			(*Create)();/*args=char *name, Abs_Type type, Abs_Varshape *shape */ \
/* Methods that are overridden by individual file format variable objects */ \
	Abs_Metadata*		(*ConstructMetadata_Interface)(); /*Constructor for local attributes*/ \
\
	int			(*SetShape)(); /* arg=Abs_Varshape *shape */ \
	int			(*SetType)(); /* arg=Abs_Type type */ \
	int			(*SetValues)(); /*args=void *vals,long start_index[],long count[]*/ \
	int			(*SetValuesFromString)(); /*args=char **vals, long start_index[], long count[]*/ \
\
	Abs_Varshape*		(*GetShape)(); \
	Abs_Type		(*GetType)(); \
	size_t			(*GetTypeSize)(); \
	int			(*GetValues)(); /* args=void *vals, long start_index[], long count[] */ \
	int			(*GetValuesAsString)(); /*args=char **vals, long start_index[], long count[]*/ \
\
/* The following fields and methods here are relevant only to coord variables*/ \
\
/* This remembers the last index to the coord so the next search is faster */ \
	long			last_retrieved_index; \
\
	long			(*GetIndexForInput)(); /*args=char *input */ \
	long			(*FastGetIndexForInput)(); /*args=char *input */ \
	void			(*ResetFastIndexForInput)(); \
\
	int			(*IsName)();/*args=char *name*/ \
	int			(*Rename)(); /*args=char *newname */ \
	int			(*Delete)(); \
	int			(*Flush) (); \
	int			(*Destruct)(); 

struct Abs_Variable_Type {
	ABS_VARIABLE_TYPE
};

/* Abs_Variable methods */
/*public: */
extern int Absff_SetVariableType(/* Abs_Type type */);
extern int Absff_SetVariableShape(/* Abs_Varshape *shape */);
extern int Absff_SetVariableValues(/*void *vals, long start[], long count[] */);
extern int Absff_SetVariableValuesFromString(/* char **vals, long start[], long count[] */);

extern Abs_Type Absff_GetVariableType();
extern size_t Absff_GetVariableTypeSize();
extern Abs_Varshape* Absff_GetVariableShape();
extern int Absff_GetVariableValues(/*void *vals, long start[], long count[] */);
extern int Absff_GetVariableValuesAsString(/* char **vals, long start[], long count[] */);
extern long Absff_GetVariableIndexForInput(/* char *input */);
extern long Absff_FastGetVariableIndexForInput(/* char *input */);
extern void Absff_ResetFastVariableIndexForInput();

/* Some utility functions */
extern Abs_Varshape * Absff_ConstructDefaultShape(/* char *domainname */);
extern void Absff_DestructDefaultShape(/*Abs_Varshape **shape*/);
extern void Absff_FreeVariableShape(/*Abs_Varshape *shape */);
extern void* Absff_AllocDefaultMetadataValues(/* Abs_Type type, int size */);
extern void* Absff_ReallocDefaultMetadataValues(/*void *vals, Abs_Type type, int size */);
extern void Absff_ConvertVariableValueFromString(/*char *value*/);
extern char* Absff_CopyString(/*char * str */);
extern void Absff_FreeString(/*char *str*/);
extern double Absff_Atod(/*char *str*/);
extern float Absff_Atof(/*char *str*/);
extern long Absff_Atol(/*char *str*/);

#endif
