static char rcsid[] = "$Id: expsum.c,v 1.3 1997/07/18 03:11:14 dhb Exp $";

/*
** $Log: expsum.c,v $
** Revision 1.3  1997/07/18 03:11:14  dhb
** Fix for getopt problem; getopt(), optopt and optind are now
** G_getopt(), G_optopt and G_optind.
**
** Revision 1.2  1993/02/24 23:46:34  dhb
** 1.4 to 2.0 command argument changes.
**
** Revision 1.1  1992/12/11  19:03:37  dhb
** Initial revision
**
*/

#include "per_ext.h"

/* 3/89 Matt Wilson */
float ExpSum(argc,argv)
int argc;
char **argv;
{
float 		maxval;
float 		rate;
float 		minval;
float 		x,y;
ElementList	*list;
Element		*element;
char 		*path;
int		i;
float		px,py;
float		sum;

    initopt(argc, argv, "path rate maxvalue minvalue x y");
    if (G_getopt(argc, argv) != 0)
      {
	printoptusage(argc, argv);
	return(0);
      }

    path = optargv[1];
    rate = Atof(optargv[2]);
    maxval = Atof(optargv[3]);
    minval = Atof(optargv[4]);
    px = Atof(optargv[5]);
    py = Atof(optargv[6]);

    list = WildcardGetElement(path,1);
    sum = 0;
    for(i=0;i<list->nelements;i++){
	element = list->element[i];
	x = element->x;
	y = element->y;
	/*
	** set the weight according to the radial distance between
	** the source and dst and the velocity
	*/
	sum += (maxval - minval)*exp(rate*sqrt(
		pow(x - px,2.0) + pow(y - px,2.0))) + minval;
    }
    FreeElementList(list);
    return(sum);
}
