
#import <appkit/appkit.h>

typedef enum _mode {forward, reverse, bounce} mode;

@interface Controller:Object
{
    id	animateWindow;
    id	browser;
    Matrix  *theMatrix;
    id  fpsField;
    id  actualField;
    id  commandField;
    
    int frames;
    int currentFrame;
    const char *const *files;
    const char *const *filesbase;
    const char *directory;
    
    int fps;
    
    DPSTimedEntry timer;
    BOOL timerEnabled;
    mode theMode;
    int bounceDir;
    int bufferLevel;
    BOOL hiliteFrame;
    BOOL onceFlag;
    BOOL commandFlag;
    
    char commandString[256];
}

- appDidInit:sender;
- (int)browser:sender fillMatrix:theMatrix inColumn:(int)column;
- browserCellSelected:sender;
- hiliteCurrentFrame:sender;
- bounce:sender;
- command:sender;
- load:sender;
- loop:sender;
- once:sender;
- stepdown:sender;
- stepup:sender;
- fpsEntered:sender;
- step;
- commandEntered:sender;

@end
