
#import "PrintCam.h"
#import <3Dkit/N3DRIBImageRep.h>

@implementation PrintCam

- setTokenStream:(NXStream *)tokens
{
  [NXImage registerImageRep:[N3DRIBImageRep class]];
  image = [[NXImage alloc] 
	initFromStream:tokens];
  [image getSize:&theSize];
  [self sizeTo:theSize.width :theSize.height];
  return self;
}

- setTokenFile:(char *)filepath
{
  [NXImage registerImageRep:[N3DRIBImageRep class]];
  image = [[NXImage alloc] 
	initFromFile:filepath];
  [image getSize:&theSize];
  [self sizeTo:theSize.width :theSize.height];
  return self;
}

- drawPS:(const NXRect *)r :(int)c
{
    if(image) [image composite:NX_COPY toPoint:&bounds.origin];
    return self;
}

@end
