#include "mibload.h"
#include "../common/drawer.h"
#include "../common/lang.h"
#include "gvui.h"
static /* prefix to ``char Root[]...'' */
#include "interface/Credits.mib"

extern Display *dpy;
extern char builddate[], buildinfo1[], buildinfo2[];
extern char *buildinfographics;
extern Pixmap geomicon;

/* private methods and variables */
/*****************************************************************************/

static void add_text(Widget, char *[]);
static Widget shell;
static char geometry[40];

static char *credits[] = {
  NULL,
  " ",
  "Original Geomview Kernel + GL version:",
  "Stuart Levy, Tamara Munzner, Mark Phillips",
  " ",
  "X Window System Version:",
  "Daeron Meyer, Timothy Rowley",
  " ",
  "NeXTSTEP Version:",
  "Dan Krech, Scott Wisdom",
  " ",
  "Important Modifications:",
  "Celeste Fowler, Charlie Gunn, Nathaniel Thurston", 
  " ",
  "The Geometry Center   Copyright (c) 1996",
  "anonymous ftp: geom.umn.edu",
  "email: software@geom.umn.edu",
  "www: http://www.geom.umn.edu/",
  " ",
  "geomview/OOGL is free software which may be.",
  "obtained via anonymous ftp from the above site.",
  "You can redistribute and/or modify it only",
  "under the terms given in the file COPYING,",
  "which is included in the geomview distribution.",
  " ",
  "The National Science and Technology Research",
  "Center for the Computation and Visualization of",
  "Geometric Structures",
  " ",
  "University of Minnesota",
  "1300 South Second Street",
  "Minneapolis, MN  55454  USA",
  " ",
  "Compiled:",
  buildinfo1,
  buildinfo2,
  NULL
};

/*****************************************************************************/

void ui_load_creditspanel()
{
  Arg	     args[20];
  int	     n;
  Widget     creditsform,
	     creditslist,
	     HideButton;

  mib_Widget *creditsload;
  Atom       AProtocol;
  static char Credits[] = "Credits";

/*****************************************************************************/

  shell = ui_make_panel_and_form(Credits, Root, True,
		&creditsform);

/*creditsload = mib_load_interface(creditsform, "interface/Credits.mib",
		MI_FROMFILE);*/
  creditsload = mib_load_interface(creditsform, Root,
		MI_FROMSTRING);
 
  XtManageChild(creditsform);

/*****************************************************************************/

  HideButton = mib_find_name(creditsload, "HideButton")->me;
  XtAddCallback(HideButton, XmNactivateCallback, (XtCallbackProc) ui_hide,
			(XtPointer) Credits);

  creditslist = mib_find_name(creditsload, "CreditsList")->me;
  add_text(creditslist, credits);
}


/*****************************************************************************/

static void add_text(Widget clist, char *text[])
{
  int line = 0;
  XmString str;
  char first[128];

  sprintf(first, "Geomview %.80s %.20s", geomview_version, buildinfographics);
  text[0] = first;
  while (text[line])
  {
   str = XmStringCreateSimple(text[line]);
   XmListAddItemUnselected(clist, str, 0);
   XmStringFree(str);
   line++;
  }
}
