/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef _TRANSOBJ_
#define _TRANSOBJ_

#ifndef _HANDLE_
#  include "handle.h"
#endif /*_HANDLE_*/

#define	TRANSMAGIC	OOGLMagic('t', 1)

typedef struct TransObj {
	REFERENCEFIELDS
	Transform T;
} TransObj;

extern void TransPosition( TransObj *tobj, Transform Tinto );
extern void TransTransformTo( TransObj *tobj, Transform Tfrom );
extern void TransDelete( TransObj *tobj );

extern int TransStreamIn( Pool *, Handle **, Transform );
extern int TransStreamOut( Pool *, Handle *, Transform );
extern TransObj *TransCreate( Transform );

extern void TransUpdate( Handle **transhandle, Ref *ignored, Transform );


#endif /*_TRANSOBJ_*/
