/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef BEZIERPDEFS
#define BEZIERPDEFS

#include "geomclass.h"
#include "bezier.h"
#include "meshP.h"

struct Bezier {
  GEOMFIELDS
  int		flag, degree_u, degree_v, dimn;
  int		nu, nv;	/* these must match mesh dimensions or remake mesh */
  float		*CtrlPnts;
  float		*STCords;
  Mesh 		*mesh;
  ColorA	c[4];		/* if flag & BEZ_C */

};

/*
 * Hidden routines, not user-callable
 */
extern Bezier *BezierCreate( Bezier *exist, GeomClass *, va_list attrlist );
extern void  BezierDelete( Bezier * );
extern Bezier *BezierCopy( Bezier * );

#endif /* ! BEZIERPDEFS */
