/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "bezierP.h"
#include "listP.h"

List *
BezierListSave(bezierlist, fname)
    List *bezierlist;
    char *fname;
{
    List *q;
    FILE *f;

    if((f = fopen(fname, "w")) == NULL)
	return NULL;
    q = BezierListFSave(bezierlist, f);
    fclose(f);
    return q;
}

List *
BezierListFSave(bezierlist, f)
    List *bezierlist;
    FILE *f;
{
    List *bl;
    register Bezier *bez;
    register float *p;
    register int u, v;
    int dimwas = -1, uwas = -1, vwas = -1, flagwas = -1;

    for(bl = bezierlist; bl != NULL; bl = bl->cdr) {
	if(bl->car == NULL)
	    continue;
	if((bez = (Bezier *)(bl->car)) == NULL)
	    continue;

	if(bez->magic != BEZIERMAGIC) {
	    GeomError(1/*warning-mismatch*/, "BezierListFSave: Non-Bezier object on BezierList: %x magic %x",
		bez, bez->magic);
	    continue;
	}

	if(bez->dimn != dimwas || bez->flag != flagwas
	   || bez->degree_u != uwas || bez->degree_v != vwas) {

	    if(bez->dimn == 3 && bez->degree_u == 3 && bez->degree_v == 3
						   && !(bez->flag & BEZ_C)) {
		fputs(bez->flag & BEZ_ST ? "STBBP" : "BBP", f);
	    } else {
		if(bez->flag & BEZ_C)
		    fputc('C', f);
		fprintf(f, "BEZ%c%c%c", bez->degree_u + '0',
					bez->degree_v + '0',
					bez->dimn + '0');
		if(bez->flag & BEZ_ST)
		    fputs("_ST", f);
	    }
	    dimwas = bez->dimn;
	    flagwas = bez->flag;
	    uwas = bez->degree_u;
	    vwas = bez->degree_v;
	}

	fputc('\n', f);

	p = bez->CtrlPnts;
	for(v = 0; v <= bez->degree_v; v++) {
	    fputc('\n', f);
	    for(u = 0; u <= bez->degree_u; u++) {
		if(bez->dimn == 4)
		    fprintf(f, "%11.8g ", *p++);
		fprintf(f, "%11.8g %11.8g %11.8g\n", p[0], p[1], p[2]);
		p += 3;
	    }
	}
	if(bez->flag & BEZ_ST && bez->STCords != NULL) {
	    fputc('\n', f);
	    for(u = 0, p = bez->STCords; u < 4; u++, p += 2)
		fprintf(f, "%8g %8g  ", p[0], p[1]);
	}
	if(bez->flag & BEZ_C && bez->c != NULL) {
	    fputc('\n', f);
	    for(u = 0, p = (float *)bez->c; u < 4; u++, p += 4)
		fprintf(f, "%6g %6g %6g %6g\n", p[0], p[1], p[2], p[3]);
	}
    }

}
