/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/*
 * Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips,
 * Nathaniel Thurston
 */

#ifndef COMMENTPDEFS
#define COMMENTPDEFS

/*
 * Private definitions for Comments.
 */

#include "comment.h"
#include "bboxP.h"	/* includes geomclass.h */

#define COMMENTMAGIC	GeomMagic('c', 1)

struct Comment {
    GEOMFIELDS
    char	*name;
    char	*type;
    int		length;		/* 0 if data is ASCII */
    char	*data;
};

extern GeomClass *CommentClass;		/* Public read-only; valid only
					 * after first call to CommentMethods()
					 */

extern Comment *CommentCreate( Comment *exist, GeomClass *Class, va_list attrs );
extern void  CommentDelete( Comment * );
extern Comment *CommentCopy( Comment * );
extern Comment *CommentDice( Comment *, int nu, int nv );

#endif /*COMMENTPDEFS*/
