#include "discgrpP.h"

static int constraint_depth;
static float constraint_stored, constraint_printd;

void
DiscGrpInitStandardConstraint(int depth, float ind0, float ind1)
{
    constraint_depth = depth;
    constraint_stored = ind0;
    constraint_printd = ind1;
}

	static HPoint3 origin = {0.0, 0.0, 0.0, 1.0};
int
DiscGrpStandardConstraint(DiscGrpEl *dgel)
{
 	int big=0, l;
	float d;
	HPoint3 image;
	int metric = dgel->attributes & DG_METRIC_BITS;
	extern double getnorm();
	
	if ((l = strlen(dgel->word)) > constraint_depth) 
		return(DG_CONSTRAINT_LONG);
	if (l == constraint_depth) big |= DG_CONSTRAINT_MAXLEN;

	/* find hyperbolic distance of image from origin: take short cut */
	HPt3Transform(dgel->tform, &origin, &image);
	d = HPt3SpaceDistance(&origin, &image, metric);

	if ( d < constraint_stored)	{
	    big |= DG_CONSTRAINT_STORE;
	    if ( d < constraint_printd)	{
	        big |= DG_CONSTRAINT_PRINT;
		}
	    }
	else		{	
		big |= DG_CONSTRAINT_TOOFAR;
		}
		
	return(big);
}

