/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips,
   Celeste Fowler */

#include "listP.h"

void
ListHandleScan( List *list, int (*func)(), void *arg )
{
    while(list) {
	if(list->carhandle)
	    (*func)(&list->carhandle, list, arg);
	GeomHandleScan( list->car, func, arg );
	list = list->cdr;
    }
}

List *
ListDice( List *list, int nu, int nv )
{
    register List *l;
    for(l = list; l != NULL; l = l->cdr)
	GeomDice(l->car, nu, nv);
    return list;
}

List *
ListEvert( List *list )
{
    register List *l;

    for(l = list; l != NULL; l = l->cdr)
	GeomEvert( l->car );

    return list;
}

BBox *
ListBound( list, T )
    List *list;
    Transform  T;
{
    Geom *carbox = NULL;
    BBox *newbox = NULL;
    BBox *bbox = NULL;
    register List *l;

    for(l = list; l != NULL; l = l->cdr) {
	carbox = GeomBound( l->car, T );
	if(carbox == NULL)
		continue;
	if(bbox) {
	    BBoxUnion3(bbox, (BBox *)carbox, bbox);
	    GeomDelete( carbox );
	} else {
	    bbox = (BBox *)carbox;
	}
    }
    return bbox;
}

List *
ListTransform( list, T )
    List *list;
    Transform T;
{
    register List *l;

    for(l = list; l != NULL; l = l->cdr)
	GeomTransform( l->car, T );

    return list;
}

List *
ListTransformTo( list, T )
     List *list;
     Transform T;
{
  return(ListTransform(list, T));
}
