/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "ndmeshP.h"

static GeomClass *aNDMeshMethods = NULL;

int NDMeshPresent = 1;

static char ndmeshName[] = "ndmesh";

extern NDMesh      *NDMeshCreate( va_list );
extern NDMesh      *NDMeshDelete( NDMesh * );
extern NDMesh      *NDMeshCopy( NDMesh * );

char *
NDMeshName()
{
	return ndmeshName;
}

GeomClass      *
NDMeshMethods()
{
	if (!aNDMeshMethods)
	{
		aNDMeshMethods = GeomClassCreate(ndmeshName);

		aNDMeshMethods->name = NDMeshName;
		aNDMeshMethods->methods = (GeomMethodsFunc *) NDMeshMethods;
		aNDMeshMethods->create = (GeomCreateFunc *) NDMeshCreate;
		aNDMeshMethods->Delete = (GeomDeleteFunc *) NDMeshDelete;
		aNDMeshMethods->fload = (GeomFLoadFunc *) NDMeshFLoad;
		aNDMeshMethods->fsave = (GeomFSaveFunc *) NDMeshFSave;
		aNDMeshMethods->bound = (GeomBoundFunc *) NDMeshBound;
		aNDMeshMethods->draw = (GeomDrawFunc *) NDMeshDraw;
	}
	return aNDMeshMethods;
}
