/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

 /*
  * Geometry Routines
  * 
  * Geometry Supercomputer Project
  * 
  * ROUTINE DESCRIPTION:  Save a vect object to a file.
  * 
  */

#include "vectP.h"

Vect *
VectFSave(v, f)
	Vect *v;
	FILE *f;
{
	register int i;
	register HPoint3 *p;
	register ColorA *c;

	/* This one just saves in ASCII format */

	if(v == NULL || f == NULL)
		return NULL;

	if (v->geomflags & VERT_4D)
	    fprintf(f, "4");
	fprintf(f, "VECT\n%d %d %d\n", v->nvec, v->nvert, v->ncolor);
	for(i = 0; i < v->nvec; i++)
		fprintf(f, "%d\n", v->vnvert[i]);
	
	fputc('\n', f);
	for(i = 0; i < v->nvec; i++)
		fprintf(f, "%d\n", v->vncolor[i]);

	fputc('\n', f);
	if  (v->geomflags & VERT_4D)	{
	    for(i = v->nvert, p = v->p; --i >= 0; p++)
		fprintf(f, "%g %g %g %g\n", p->x, p->y, p->z, p->w);
	    }
	else	{
	    for(i = v->nvert, p = v->p; --i >= 0; p++)
		fprintf(f, "%g %g %g\n", p->x, p->y, p->z);
	    }

	fputc('\n', f);
	for(i = v->ncolor, c = v->c; --i >= 0; c++)
		fprintf(f, "%.3g %.3g %.3g %.3g\n", c->r, c->g, c->b, c->a);

	return ferror(f) ? NULL : v;
}
