#include "mgP.h"
#include "mgribP.h"
#include "mgribtoken.h"

#define	HAS_N	0x1
#define	HAS_C	0x2
#define	HAS_SMOOTH 0x4

#define VI_TUPLET_LIMIT 2 /* for sgi vi formatting (so we can use it!) */

static void mgrib_submesh( int wrap, int nu, int nv, HPoint3 *P, Point3 *N, ColorA *C );
static void mgrib_prmanmesh( int wrap, int nu, int nv, HPoint3 *P );

int
mgrib_mesh( wrap, nu, nv, P, N, C)
    int wrap;
    int nu, nv;
    HPoint3 *P;
    Point3 *N;
    ColorA *C;
{
    register Appearance *ap;
    ColorA	*c;
    Color   *c3;
    Point3  *n;
    HPoint3 *p;
    int u,v;

    ap = &_mgc->astk->ap;

    if(ap->flag & APF_FACEDRAW) {
	mgrib_submesh( wrap, nu, nv, P, N, C);
    }
    
    if(ap->flag & APF_EDGEDRAW) {
	/* must draw edges manually */
	c3 = &ap->mat->edgecolor;
	mrti(mr_attributebegin, mr_color, mr_parray, 3, c3,
	    mr_opacity, mr_array, 3, 1., 1., 1.,
	    mr_surface, mr_constant, mr_NULL);
	mgrib_prmanmesh( wrap, nu, nv, P);
	mrti(mr_attributeend,mr_NULL);
    }
    
    if((ap->flag & APF_NORMALDRAW) && N!=NULL) {
	p = P;
	n = N;
	for(u = nu*nv; --u >= 0; )
	    mgrib_drawnormal(p++, n++);
    }
    
    return 1;
}

static void
mgrib_submesh( int wrap, int nu, int nv, HPoint3 *P, Point3 *N, ColorA *C )
{
    register Appearance *ap;
    char    *uwrap,*vwrap;
    int     shading;
    int     i;
    register HPoint3 *p;
    register Point3  *n;
    register ColorA	*c;
    int     nunv;
    int     viflag; /* used to insert \n into RIB file so lines */
		    /* won't be too long for 'vi' to work well   */
    float   alpha;

    nunv = nu * nv;
    p = P;
    n = N;
    c = C;
	    
    ap = &_mgc->astk->ap;
    
    uwrap = (wrap & MM_UWRAP) ? "periodic" : "nonperiodic";
    vwrap = (wrap & MM_VWRAP) ? "periodic" : "nonperiodic";
    
    mrti(mr_attributebegin, mr_NULL);

/* THIS SHOULD BE AT A HIGHER LEVEL
    mgrib_print("ShadingInterpolation ");
    if(ap->shading & APF_SMOOTH) mgrib_print("\"smooth\"\n");
    else mgrib_print("\"constant\"\n");
*/
    
    mrti(mr_patchmesh, mr_string, "bilinear",
    	mr_int, nu, mr_string, uwrap,
    	mr_int, nv, mr_string, vwrap,
	mr_P, mr_buildarray, 3*nunv, mr_NULL);
	
    for(i=0; i<nunv; i++, p++, viflag++) {
	mrti(mr_subarray3, p, mr_NULL);
	if(viflag>=VI_TUPLET_LIMIT) {
	    viflag=0;
	    /* wrap lines so they won't be too long for vi */
	    mrti(mr_nl, mr_NULL);
	}
    }
    
    /* use normals if supplied */
    if(N!=NULL) {
	viflag = 0;
	mrti(mr_N, mr_buildarray, 3*nunv, mr_NULL);
	for(i=0; i<nunv; i++, n++, viflag++) {
	    mrti(mr_subarray3, n, mr_NULL);
	    if(viflag>=VI_TUPLET_LIMIT) {
		viflag = 0;
		mrti(mr_nl, mr_NULL);
	    }
	}
    }
    
    /* use colors if supplied and not overridden */
    if(C && !( (ap->mat->override & MTF_DIFFUSE) && !_mgc->astk->useshader) ) {
	viflag = 0;
	mrti(mr_Cs, mr_buildarray, 3*nunv, mr_NULL);
	for(i=0; i<nunv; i++, c++, viflag++) {
	    mrti(mr_subarray3, c, mr_NULL);
	    if(viflag>=VI_TUPLET_LIMIT) {
		viflag = 0;
		mrti(mr_nl, mr_NULL);
	    }
	}
	
	/* transparancy */
	if(ap->flag & APF_TRANSP) {
	    c = C;
	    mrti(mr_Os, mr_buildarray, 3*nunv, mr_NULL);
	    for(i=0; i<nunv; i++, c++) {
		mrti(mr_subarray3, c, mr_NULL);
		if(viflag>=VI_TUPLET_LIMIT)
		{
		    viflag = 0;
		    mrti(mr_nl, mr_NULL);
		}
	    }
	}			
    }
    mrti(mr_attributeend, mr_NULL);
}

static void
mgrib_prmanmesh( int wrap, int nu, int nv, HPoint3 *P )
{
    int u, v, prevu, prevv;

    for(v=0; v<nv; v++) {
	if(wrap & MM_UWRAP) u = 0, prevu = nu-1;
	else		    u = 1, prevu = 0;
	for( ; u<nu; u++) {
	    mgrib_drawline(&P[prevu + v * nu], &P[u + v * nu]);
	    prevu = u;
	}
    }

    for(u=0; u<nu; u++) {
	if(wrap & MM_VWRAP) v = 0, prevv = nv-1;
	else		    v = 1, prevv = 0;
	for( ; v<nv; v++) {
	    mgrib_drawline(&P[u + prevv * nu], &P[u + v * nu]);
	    prevv = v;
	}
    }
}
