%%NAME
%%  eaxespol - draw scaled axes and arc around polar plot area 
%%
%%SYNOPSIS
%%  eaxespol([axisRadiusScale,axisAngleScale])
%%
%%PARAMETER(S)
%%  axisRadiusScale   scale vector of radius axis  [start step end] 
%%  axisAngleScale    scale vector of angle circle [start step end] 
%% 
%%    special cases of scale vectors are: 
%%      if start=0 and end=0 then autorange=on 
%%      if step=0 then autoscale=on 
%%                                          
%%GLOBAL PARAMETER(S)
%%  ePolarAxisRadScale
%%  ePolarAxisAngScale
%%  ePolarAxisRadVisible
%%  ePolarPlotAreaCenterPos
%%  ePolarPlotAreaRadMin
%%  ePolarPlotAreaRadMax
%%  ePolarPlotAreaAngStart
%%  ePolarPlotAreaAngEnd
%%  ePolarPlotAreaValStart
%%  ePolarPlotAreaValEnd
%%  ePolarAxisRadVisible
%%  ePolarAxisRadValueFormat
%%  ePolarAxisRadValueVisible
%%  ePolarAxisAngVisible
%%  ePolarAxisAngValueFormat
%%  ePolarAxisAngValueVisible
%%  eAxesValueFontSize
%%  eAxesLineWidth
%%  eAxesTicShortLength
%%  eAxesTicLongLength
%%  eAxesTicLongMaxN
%%  eAxesValueSpace
% written by Stefan Mueller stefan.mueller@fgan.de 1997

function eaxespol(axisRadiusScale,axisAngleScale)
  if nargin~=0 & nargin~=2
    usage('egridpol ([axisRadiusScale,axisAngleScale])');
  end
  eglobpar;
  if nargin==2
    ePolarAxisRadScale=axisRadiusScale;
    ePolarPlotAreaValStart=ePolarAxisRadScale(1);
    ePolarPlotAreaValEnd=ePolarAxisRadScale(3);
    ePolarAxisAngScale=axisAngleScale;
    yRange=ePolarPlotAreaValEnd-ePolarPlotAreaValStart;
    if yRange==0
      yRange=1;
    end
    ePolarPlotAreaFac=(ePolarPlotAreaRadMax-ePolarPlotAreaRadMin)*...
                      eFac/yRange;
  end
  if nargin==0
    if ePolarAxisRadScale(1)~=ePolarAxisRadScale(3)
      ePolarPlotAreaValStart=ePolarAxisRadScale(1);
      ePolarPlotAreaValEnd=ePolarAxisRadScale(3);
    end
    % scale and draw axes
    if ePolarAxisRadVisible
      escalepr(eFile,...
              ePolarPlotAreaCenterPos(1)*eFac,...
              ePolarPlotAreaCenterPos(2)*eFac,...
              ePolarPlotAreaRadMin*eFac,...
              ePolarPlotAreaRadMax*eFac,...
              ePolarPlotAreaAngStart,...
              ePolarPlotAreaAngEnd,...
              ePolarPlotAreaValStart,...
              ePolarAxisRadScale(2),...
              ePolarPlotAreaValEnd,...
              ePolarAxisRadValueFormat,...
              ePolarAxisRadValueVisible,...
              eAxesValueFontSize*eFac,...
              eAxesLineWidth*eFac,...
              eAxesTicShortLength*eFac,...
              eAxesTicLongLength*eFac,...
              eAxesTicLongMaxN,...
              eAxesValueSpace*eFac);
    end
    if ePolarAxisAngVisible
      maxValues=fix(20*(ePolarPlotAreaAngEnd-ePolarPlotAreaAngStart)/360);
      escalepa(eFile,...
              ePolarPlotAreaCenterPos(1)*eFac,...
              ePolarPlotAreaCenterPos(2)*eFac,...
              ePolarPlotAreaRadMin*eFac,...
              ePolarPlotAreaRadMax*eFac,...
              ePolarPlotAreaAngStart,...
              ePolarPlotAreaAngEnd,...
              ePolarAxisAngScale(1),...
              ePolarAxisAngScale(2),...
              ePolarAxisAngScale(3),...
              ePolarAxisAngValueFormat,...
              ePolarAxisAngValueVisible,...
              eAxesValueFontSize*eFac,...
              eAxesLineWidth*eFac,...
              eAxesTicShortLength*eFac,...
              eAxesTicLongLength*eFac,...
              maxValues,...
              eAxesValueSpace*eFac);
    end
  end
