%%NAME
%%  eplot  - make linear plot
%%
%%SYNOPSIS
%%  eplot ([xData,[yData,[legendText,[dash,[color]]]]])
%%
%%PARAMETER(S)
%%  xData          vector of x-data
%%  yData          vector of y-data
%%  legendText     text of legend, if empty  string then no legend
%%  dash           0=solid line,>0=dash length,
%%                 <0=fill line,string=name of symbol
%%  color          color of plot, vetcor [r g b]
%% 
%%GLOBAL PARAMETER(S)
%%  ePlotTitleText
%%  ePlotTitleFontSize
%%  ePlotTitleTextFont
%%  ePlotTitleDistance
%%  ePlotAreaPos
%%  ePlotAreaWidth
%%  ePlotAreaHeight
%%  eXAxisSouthScale
%%  eYAxisWestScale
%%  ePlotAreaXValueStart
%%  ePlotAreaXValueEnd
%%  ePlotAreaYValueStart
%%  ePlotAreaYValueEnd
%%  ePlotLineInterpolation
%%  ePlotLineWidth
%%  ePlotLineColor; 
%%  ePlotLineDash; 
%%  ePlotLegendPos;
%%  ePlotLegendTextFont
%%  ePlotLegendFontSize
%%  ePlotLegendDistance
% written by Stefan Mueller stefan.mueller@fgan.de

function eplot(xData,yData,legendText,dash,color)
  if nargin>5
    usage ('eplot ([xData,[yData,[legendText,[dash,[color]]]]])');
  end
  eglobpar;
  if (nargin==0)
    %finish plotting
    
    % write title
    if strcmp(ePlotTitleText,'')~=1
    etext(ePlotTitleText,ePlotAreaPos(1)+ePlotAreaWidth/2,...
         ePlotAreaPos(2)+ePlotAreaHeight+ePlotTitleDistance,...
         ePlotTitleFontSize,0,ePlotTitleTextFont,0); 
    end
    %value range
    if eXAxisSouthScale(1)~=eXAxisSouthScale(3)
      %fix scale
      ePlotAreaXValueStart=eXAxisSouthScale(1);
      ePlotAreaXValueEnd=eXAxisSouthScale(3);
    end
    if eYAxisWestScale(1)==eYAxisWestScale(3)
      yRange=ePlotAreaYValueEnd-ePlotAreaYValueStart;
      ePlotAreaYValueStart=ePlotAreaYValueStart-0.05*yRange; 
      ePlotAreaYValueEnd=ePlotAreaYValueEnd+0.05*yRange; 
    else
      %fix scale 
      ePlotAreaYValueStart=eYAxisWestScale(1);
      ePlotAreaYValueEnd=eYAxisWestScale(3);
    end
    egrid;
      
    % plot line and write legend
    ePlotAreaXFac=ePlotAreaWidth*eFac/...
      (ePlotAreaXValueEnd-ePlotAreaXValueStart);
    ePlotAreaYFac=ePlotAreaHeight*eFac/...
      (ePlotAreaYValueEnd-ePlotAreaYValueStart);
    legendPos=ePlotLegendPos;
    for i=1:ePlotLineNr
      parameter=sprintf('global ePlotLineColor%d;',i);
      eval(parameter);
      parameter=sprintf('color=ePlotLineColor%d;',i);
      eval(parameter);
      parameter=sprintf('global ePlotLineDash%d;',i);
      eval(parameter);
      parameter=sprintf('dash=ePlotLineDash%d;',i);
      eval(parameter);
      parameter=sprintf('global ePlotLegendText%d;',i);
      eval(parameter);
      parameter=sprintf('legendText=ePlotLegendText%d;',i);
      eval(parameter);
      parameter=sprintf('global ePlotXData%d;',i);
      eval(parameter);
      parameter=sprintf('xData=ePlotXData%d;',i);
      eval(parameter);
      parameter=sprintf('global ePlotYData%d;',i);
      eval(parameter);
      parameter=sprintf('yData=ePlotYData%d;',i);
      eval(parameter);
      xData=(xData-ePlotAreaXValueStart)*ePlotAreaXFac;
      yData=(yData-ePlotAreaYValueStart)*ePlotAreaYFac;

      eclip(eFile,ePlotAreaPos(1)*eFac,ePlotAreaPos(2)*eFac,...
            ePlotAreaWidth*eFac,ePlotAreaHeight*eFac);   
      if isstr(dash)
        exyplots(eFile,...
          ePlotAreaPos(1)*eFac,...
          ePlotAreaPos(2)*eFac,...
          xData,...
          yData,...
          dash,...
          color);
       
      elseif dash<0;
        exyplotf(eFile,...
          ePlotAreaPos(1)*eFac,...
          ePlotAreaPos(2)*eFac,...
          xData,...
          yData,...
          color)
      else
        if ePlotLineInterpolation
          exyplotc(eFile,...
            ePlotAreaPos(1)*eFac,...
            ePlotAreaPos(2)*eFac,...
            xData,...
            yData,...
            color,...
            dash*eFac,...
            ePlotLineWidth*eFac);
        else
          exyplot(eFile,...
            ePlotAreaPos(1)*eFac,...
            ePlotAreaPos(2)*eFac,...
            xData,...
            yData,...
            color,...
            dash*eFac,...
            ePlotLineWidth*eFac);
        end
      end
      eclip(eFile,0,0,0,0);

      if strcmp(legendText,'')~=1
        eplotlg(eFile,...
          (ePlotAreaPos(1)+legendPos(1))*eFac,...
          (ePlotAreaPos(2)+legendPos(2))*eFac,...
          color,... 
          dash,...
          ePlotLineWidth*eFac,...
          legendText,...
          eFonts(ePlotLegendTextFont,:),...
          ePlotLegendFontSize*eFac);
        legendPos(2)=legendPos(2)-ePlotLegendDistance;
      end
    end
    eaxes;
    ePlotLineNr=0;
  else    
    % add plot line
    ePlotLineNr=ePlotLineNr+1;
    %color
    if (nargin<5)
      color=ePlotLineColor; 
    end
    parameter=sprintf('global ePlotLineColor%d;',ePlotLineNr);
    eval(parameter);
    parameter=sprintf('ePlotLineColor%d=color;',ePlotLineNr);
    eval(parameter);
    
    %dash
    if (nargin<4)
      dash=ePlotLineDash; 
    end
    parameter=sprintf('global ePlotLineDash%d;',ePlotLineNr);
    eval(parameter);
    parameter=sprintf('ePlotLineDash%d=dash;',ePlotLineNr);
    eval(parameter);
  
    % legend text
    if (nargin<3)
      legendText='';
    end
    parameter=sprintf('global ePlotLegendText%d;',ePlotLineNr);
    eval(parameter);
    parameter=sprintf('ePlotLegendText%d=legendText;',ePlotLineNr);
    eval(parameter);
  
    if (nargin==1)
      yData=xData;
      xData=1:length(yData);
    end
    % data
    parameter=sprintf('global ePlotXData%d;',ePlotLineNr);
    eval(parameter);
    parameter=sprintf('ePlotXData%d=xData;',ePlotLineNr);
    eval(parameter);
    parameter=sprintf('global ePlotYData%d;',ePlotLineNr);
    eval(parameter);
    parameter=sprintf('ePlotYData%d=yData;',ePlotLineNr);
    eval(parameter);
  
    %value range
    xMin=min(xData);
    xMax=max(xData);
    if xMin<ePlotAreaXValueStart | ePlotLineNr==1
      ePlotAreaXValueStart=xMin;
    end
    if xMax>ePlotAreaXValueEnd | ePlotLineNr==1
      ePlotAreaXValueEnd=xMax;
    end
    yMin=min(yData);
    yMay=max(yData);
    if yMin<ePlotAreaYValueStart | ePlotLineNr==1
      ePlotAreaYValueStart=yMin;
    end
    if yMay>ePlotAreaYValueEnd | ePlotLineNr==1
      ePlotAreaYValueEnd=yMay;
    end
  end
