%%NAME
%%  einceps  -  include eps-file 
%%
%%SYNOPSIS
%%  einceps(xPos,yPos,epsFileName,[,scaleX[,scaleY[,rotation]]])
%%
%%PARAMETER(S)
%%  xPos          x position
%%  yPos          y position
%%  epsFileName   name of eps-file 
%%  scaleX        scale factor in x-direction
%%  scaleY        scale factor in y-direction
% written by Stefan Mueller stefan.mueller@fgan.de

function einceps(xPos,yPos,epsFileName,scaleX,scaleY,rotation)
  if nargin<3 |nargin>6
    usage('eposeps(xPos,yPos,epsFileName,[,scaleX[,scaleY[,rotation]]])');
  end
  if nargin<6
    rotation=0;
  end
  if nargin<5
    scaleY=1;
  end
  if nargin<4
    scaleX=1;
  end
  eglobpar;
  fprintf(eFile,'gsave %1.2f %1.2f translate\n',xPos*eFac,yPos*eFac);
  fprintf(eFile,'%1.2f rotate\n',rotation);
  fprintf(eFile,'%1.2f %1.2f scale\n',scaleX,scaleY);
  epsFile=fopen(epsFileName,'r');

  if epsFile>1
    % get file length
    fseek(epsFile,0,1); 
    epsFileLength=ftell(epsFile)
    fclose(epsFile);
    bufferSize=100000;
    epsFile=fopen(epsFileName,'r');
    nBuffer=fix(epsFileLength/bufferSize);
    tail=rem(epsFileLength,bufferSize);
    for i=1:nBuffer
      buffer=fread(epsFile,bufferSize,'char');
      fwrite(eFile,buffer,'char');
    end
    if tail>0 
      buffer=fread(epsFile,tail,'char');
      fwrite(eFile,buffer,'char');
    end
    fclose(epsFile);
  end
  fprintf(eFile,'grestore\n');
