%escalecl(epsFile,side,x,y,offset,angle,length,valueStart,valueStep,
% valueEnd,vForm,vVisible,fontSize,lineWidth,longTicLength,nMax,space)
% written by Stefan Mueller stefan.mueller@fgan.de 1997

function escalecl(epsFile,side,x,y,offset,angle,length,valueStart,...
                  valueStep,valueEnd,vForm,vVisible,fontSize,...
                  lineWidth,longTicLength,nMax,space)
  if (nargin~=17)
    usage(...
   'escalecl(epsFile,side,x,y,offset,angle,length,valueStart,valueStep,valueEnd,vForm,vVisible,fontSize,lineWidth,longTicLength,space)');
  end
  startEndDiff=valueEnd-valueStart;  
  signOfDiff=sign(startEndDiff);
  if valueStep==0
    valueStep=signOfDiff*eticdis(signOfDiff*startEndDiff,nMax);
  end
  classValue=valueStart:valueStep:valueEnd; 
  classStart=classValue-valueStep/2;
  classStart=(classStart-classStart(1))/...
    (startEndDiff+valueStep);
  if size(classStart,2) <2
    classEnd=classStart+1;
  else
    classEnd=classStart+classStart(2);
  end  

  if side=='s'
    startPos=0;
    xLength=length;
    yLength=0;
    moveForm=sprintf('%%1.2f %1.2f moveto\n',-offset);
    ticLineForm='0 -%1.2f rlineto\n';
    moveValueForm=sprintf('0 -%1.2f rmoveto\n',space+fontSize*0.72);
    showForm='(%s) dup stringwidth pop dup 2 div sub neg 0 rmoveto show\n';
  elseif side=='n'
    startPos=0;
    xLength=length;
    yLength=0;
    moveForm=sprintf('%%1.2f %1.2f moveto\n',offset);
    ticLineForm='0 %1.2f rlineto\n';
    moveValueForm=sprintf('0 %1.2f rmoveto\n',space);
    showForm='(%s) dup stringwidth pop dup 2 div sub neg 0 rmoveto show\n';
  elseif side=='w'
    startPos=0;
    xLength=0;
    yLength=length;
    moveForm=sprintf('%1.2f %%1.2f moveto\n',-offset);
    ticLineForm='-%1.2f 0 rlineto\n';
    moveValueForm=sprintf('-%1.2f -%1.2f 0.28 mul rmoveto\n',space,fontSize);
    showForm='(%s) dup stringwidth pop neg 0 rmoveto show\n';
  elseif side=='e'
    startPos=0;
    xLength=0;
    yLength=length;
    moveForm=sprintf('%1.2f %%1.2f moveto\n',offset);
    ticLineForm='%1.2f 0 rlineto\n';
    moveValueForm=sprintf('%1.2f -%1.2f 0.28 mul rmoveto\n',space,fontSize);
    showForm='(%s) show\n';
  end

  
  % start draw
  fprintf(epsFile,'%1.2f %1.2f translate\n',x,y);
  fprintf(epsFile,'%1.2f rotate\n',angle);
  fprintf(epsFile,'newpath\n');
  fprintf(epsFile,'/Helvetica findfont %d scalefont setfont\n',fontSize);
  nClasses=size(classStart,2);
  for i=1:nClasses
    % long tic of start of class
    currentPos=startPos+length*classStart(i);
    fprintf(epsFile,moveForm,currentPos);
    fprintf(epsFile,ticLineForm,longTicLength);
    % long tic of end of class
    currentPos=startPos+length*classEnd(i);
    fprintf(epsFile,moveForm,currentPos);
    fprintf(epsFile,ticLineForm,longTicLength);
    % class value
    currentPos=startPos+length*(classStart(i)+classEnd(i))/2;
    fprintf(epsFile,moveForm,currentPos);
    if vVisible
      fprintf(epsFile,moveValueForm);
      valueForm=sprintf('%%1.%df',vForm);
      valueForm=sprintf(valueForm,classValue(i));
      fprintf(epsFile,showForm,valueForm);
    end
  end

  %axis
  fprintf(epsFile,moveForm,startPos);
  fprintf(epsFile,'%1.2f %1.2f rlineto\n',xLength,yLength);
  fprintf(epsFile,'%1.2f setlinewidth\n',lineWidth);
  fprintf(epsFile,'stroke\n');
  fprintf(epsFile,'%1.2f rotate\n',-angle);
  fprintf(epsFile,'%1.2f %1.2f translate\n',-x,-y);

