/*
 * Copyright 1996 Thierry Bousch
 * Licensed under the Gnu Public License, Version 2
 *
 * $Id: errlist.c,v 1.3 1996/08/18 09:38:12 bousch Exp $
 *
 * List of error messages
 */

#include "saml-errno.h"

const char *saml_errlist[] = {
	"Unknown error",		/*  0 */
	"General error",		/*  1 */
	"Wrong operand type",		/*  2 */
	"Wrong array size",		/*  3 */
	"Type conflict",		/*  4 */
	"Size conflict",		/*  5 */
	"Operation not supported",	/*  6 */
	"Static table is full",		/*  7 */
	"Division by zero",		/*  8 */
	"Out of definition domain",	/*  9 */
	"Index out of range",		/* 10 */
	"Not invertible",		/* 11 */
	"No such type",			/* 12 */
	"Not an array",			/* 13 */
	"Type already defined",		/* 14 */
	"Cannot parse string",		/* 15 */
	"Cannot cast",			/* 16 */
	"Not yet implemented",		/* 17 */
	"Uninitialized",		/* 18 */
	"Heterogeneous operands",	/* 19 */
	"Not a scalar",			/* 20 */
	"Internal overflow",		/* 21 */
	"Object is too sparse",		/* 22 */
	"Not the same modulus"		/* 23 */
};

const char* saml_strerror (int errno)
{
	if ((unsigned)errno > SE_MAX_ERROR)
		errno = 0;
	return saml_errlist[errno];
}
