/*
    Copyright (C) 1996-1998  Ulric Eriksson <ulric@edu.stockholm.se>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston,
    MA 02111-1307, USA.
*/

#ifndef RICHCHAR_H
#define RICHCHAR_H

/* one character */
typedef struct rich_char {
        unsigned char c;                /* a single character */
        unsigned int fmt;              /* same as in Siag */
} rich_char;


/* from richchar.c */
extern size_t rc_strlen(rich_char *);
extern rich_char *rc_strcpy(rich_char *, rich_char *);
extern rich_char *rc_strcat(rich_char *, rich_char *);
extern rich_char *rc_strdup(rich_char *);
extern rich_char *rc_strins(rich_char *, rich_char *, size_t);
extern rich_char *rc_makerich(unsigned char *, int);
extern unsigned char *rc_makeplain(rich_char *);
extern void rc_forparts(rich_char *, void (*)(rich_char *, size_t));

#endif	/* RICHCHAR_H */
