/*
   Egon Animator
   Copyright (C) 1997  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

/*
 * types.h
 */

#ifndef EGON_TYPES
#define EGON_TYPES

/* misc stuff originally in animator.h */

#define ANI_OK 0
#define ANI_ERR 1

#define ANI_NONE 0

#define ANI_STOP 1
#define ANI_NEXT 2
#define ANI_PREVIOUS 3
#define ANI_CONTINUE 4
#define ANI_QUIT 5

#define ANI_LINE 1
#define ANI_RECTANGLE 2
#define ANI_ARC 3
#define ANI_ELLIPSE 4
#define ANI_PIXMAP 5
#define ANI_STRING 6
#define ANI_POINT 7
#define ANI_FILLRECT 8
#define ANI_FILLARC 9
#define ANI_FILLELLIPSE 10
#define ANI_PLUGIN 11

#define ANI_X 1
#define ANI_Y 2
#define ANI_WIDTH 3
#define ANI_HEIGHT 4
#define ANI_VISIBLE 5
#define ANI_FORMAT 7
#define ANI_TEXT 8


/* linked list of positions, sizes et al of an object */
typedef struct s_ani_script {
        int time;
        int x, y;       /* position */
        int width, height;
        int visible;
        struct s_ani_script *next;
} ani_script;

/* linked list of all the objects on the stage */
typedef struct s_ani_object {
        int type;
        char *name;
        ani_script *script;
        int fmt;
        char *string;
        struct s_ani_object *next;
} ani_object;

#endif
