/*
   Copyright (C) 1999  Ulric Eriksson <ulric@edu.stockholm.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the Licence, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

#ifndef s_Check_h
#define s_Check_h

/****************************************************************
 *
 * Check widget
 *
 ****************************************************************/

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 destroyCallback     Callback		Pointer		NULL
 height		     Height		Dimension	0
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0

*/

/* define any special resource names here that are not in <X11/StringDefs.h> */

typedef enum {
	SiagCheckWin,
	SiagRadioWin,
	SiagCheckMotif,
	SiagRadioMotif
} SiagCheckStyle;

#ifndef XtNradioStart
#define XtNradioStart "radioStart"
#define XtCRadioStart "RadioStart"
#endif
#ifndef XtNradioGroup
#define XtNradioGroup "radioGroup"
#define XtCRadioGroup "RadioGroup"
#endif
#ifndef XtNcheckStyle
#define XtNcheckStyle "checkStyle"
#define XtCCheckStyle "CheckStyle"
#endif
#ifndef XtNstate
#define XtNstate "state"
#define XtCState "State"
#endif

/* declare specific CheckWidget class and instance datatypes */

typedef struct s_CheckClassRec*	CheckWidgetClass;
typedef struct s_CheckRec*		CheckWidget;

/* declare the class constant */

extern WidgetClass checkWidgetClass;

#endif /* s_Check_h */

