#    Copyright (C) 1998  Dennis Roddeman
#    email: dennis.roddeman@uibk.ac.at
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#   
#   
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software Foundation
#    59 Temple Place, Suite 330, Boston, MA, 02111-1307, USA

proc search_data {} {

  global tnpath
  source $tnpath/gid/global.tcl

  global searchdata

  if { $tn_switch } { puts "In proc SEARCH_DATA" }

#  window
  set w_tngidmbar_search_data .w_tngidmbar_search_data
  catch {destroy $w_tngidmbar_search_data}
  toplevel $w_tngidmbar_search_data
  wm title $w_tngidmbar_search_data "Search for data items containing ... "
  wm geometry $w_tngidmbar_search_data 700x500
  wm geometry $w_tngidmbar_search_data $tn_window_offset
  focus $w_tngidmbar_search_data

#    main frame
  set f $w_tngidmbar_search_data.frame
  frame $f -relief groove -borderwidth 2
  pack $f -expand 1 -fill both

#   ready
  frame $f.framespecials -relief flat
  pack $f.framespecials -side bottom -pady 2m -fill x
  button $f.framespecials.ready -text "Ready" -command { destroy $w_tngidmbar_search_data }
  button $f.framespecials.search -text "Search" -command { search_data_list }
  button $f.framespecials.help -text "Help" -command { 
    help "Enter one word to search. Press search (or press return). All data items containing the word will be displayed."
  }
  pack $f.framespecials.ready $f.framespecials.search -side left -anchor w
  pack $f.framespecials.help -side right -anchor e

#   item
  frame $f.frameitem -relief flat
  pack $f.frameitem -side top -pady 2m -anchor w
  label $f.frameitem.lab -text "Word: "
  entry $f.frameitem.ent -textvariable searchdata -relief sunken -width 30
  bind $f.frameitem.ent <Return> { search_data_list }
  pack $f.frameitem.lab $f.frameitem.ent -side left -anchor w

  if { $tn_switch } { puts "Out proc SEARCH_DATA" }

}

proc search_data_syntax { } {
}

proc search_data_list { } {

  global tnpath
  source $tnpath/gid/global.tcl

  global searchdata

  if { $tn_switch } { 
    puts "In proc SEARCH_DATA_LIST" 
    puts "searchdata: $searchdata" 
  }

  set f $w_tngidmbar_search_data.frame
  catch {destroy $f.frametext}
  frame $f.frametext -relief flat
  pack $f.frametext -fill both -side top -expand 1
  text $f.frametext.text -relief raised -yscrollcommand "$f.frametext.scroll set"
  scrollbar $f.frametext.scroll -command "$f.frametext.text yview"
  pack $f.frametext.scroll -side right -fill y
  pack $f.frametext.text -side left -fill both -expand 1

  for {set imember 0} {$imember<$cmd_array_length} {incr imember} {
    set cmd_array_member $cmd_array($imember)
    set ind [string first $searchdata $cmd_array_member]
    if { $searchdata=="" || $ind>=0 } {
      $f.frametext.text insert end $cmd_array_member
      set data_array_syntax data_array_syntax_$cmd_array_member
      $f.frametext.text insert end "  "
      $f.frametext.text insert end [set $data_array_syntax]
      $f.frametext.text insert end "\n\n"
    }
  }

  if { $tn_switch } { puts "Out proc SEARCH_DATA_LIST" }
}
