C igmk3d.f
C
C VIS-5D version 4.0
C
C VIS-5D system for visualizing five dimensional gridded data sets
C Copyright (C) 1990-1994  Bill Hibbard and Dave Santek
C
C This program is free software; you can redistribute it and/or modify
C it under the terms of the GNU General Public License as published by
C the Free Software Foundation; either version 1, or (at your option)
C any later version.
C
C This program is distributed in the hope that it will be useful,
C but WITHOUT ANY WARRANTY; without even the implied warranty of
C MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C GNU General Public License for more details.
C
C You should have received a copy of the GNU General Public License
C along with this program; if not, write to the Free Software
C Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
C
C
      FUNCTION IGMK3D(GFNO,IDENT,MAXSIZ)
C
C $ FUNCTION IGMK3D(GFNO, IDENT)  (DAS)
C $ CREATE A 3-D GRID FILE. RETURNS 0 (OK), 1 (ALREADY EXISTS), OR -1
C $   (CAN'T CREATE).
C $ INPUT:
C $   GFNO = (I) GRID FILE NUMBER (1...9999)
C $  IDENT = (I) OPTIONAL 8-WORDS OF EBCDIC TEXT (IGNORED IF FIRST IS 0)
C $  MAXSIZ = (I) MAXIMUM SIZE OF A 3-D GRID
C $$ IGMK3D = GRID
C
      IMPLICIT INTEGER (A-Z)
      PARAMETER (MAXGRD=2000,MAXWRD=100000000)
      CHARACTER*8 FILNAM
      DIMENSION IDENT(*)
      INTEGER HEAD(64)
      DATA MAXGF/9999/
      DATA MISS/'80808080'X/
C
      IF (GFNO.LT.1.OR.GFNO.GT.MAXGF) GOTO 92
      CALL IGNM3D(GFNO,FILNAM)
      IGMK3D=LWFILE(FILNAM)
      IF (IGMK3D.NE.0) RETURN
      CALL ZEROW(64,HEAD)
      IF(IDENT(1).NE.0) CALL MOVW(8,IDENT,HEAD)
      HEAD(9)=NPROJ(IDUM)
      CALL GETDAY(HEAD(10))
      IF(MAXSIZ.LE.0) THEN
         CALL EDEST('IGMK3D ERROR----INVALID MAXSIZ ',MAXSIZ)
         CALL ABORT()
      ENDIF
      HEAD(11)=MAXSIZ
      NUMGRD=MIN0(MAXWRD/MAXSIZ,MAXGRD)
      HEAD(12)=NUMGRD
      HEAD(13)=(MAXGRD+1)*64
      CALL LWO(FILNAM,0,64,HEAD)
      DO 10 I=1,64
10    HEAD(I)=MISS
      DO 20 GNO=1,NUMGRD
20    CALL LWO(FILNAM,64*GNO,64,HEAD)
      RETURN
 92   IGMK3D=-1
      RETURN
      END
C
C
C
C
      SUBROUTINE IGNM3D(GFNO,FILNAM)
C $ SUBROUTINE IGNM3D(GFNO, FILNAM)  (DAS)
C $ CONSTRUCT A 3-D GRID FILE NAME FROM A NUMBER
C $ GFNO = (I) INPUT  GRID FILE NUMBER
C $ FILNAM = (I) OUTPUT  FILE NAME, IN FORM 'GR3DNNNN'
C $$ IGNM3D = GRID
      IMPLICIT INTEGER (A-Z)
      CHARACTER*8 FILNAM
      CHARACTER*12 CFJ,CTEMP
C
      CTEMP=CFJ(GFNO)
      FILNAM='GR3D'//CTEMP(9:12)
      RETURN
      END
C
C
C
C
      SUBROUTINE IGQT3D(GFNO)
C $ SUBROUTINE IGQT3D(GFNO)  (DAS)
C $ DELETE 3-D GRID FILE
C $ GFNO = (I) INPUT  GRID FILE NUMBER
C $$ IGQT3D = GRID
      IMPLICIT INTEGER (A-Z)
      CHARACTER*8 FILNAM
      DATA MAXGF/9999/
C
      IF (GFNO.LT.1.OR.GFNO.GT.MAXGF) RETURN
      CALL TRMNL(IT)
      IF (IT.NE.0) RETURN
C-----CHECK (AREA) QUIT-PROTECT TABLES
      CALL IGNM3D(GFNO,FILNAM)
      I=LWD(FILNAM)
      RETURN
      END
C
C
C
C
      FUNCTION IGOP3D(GFNO,FILNAM)
C $ FUNCTION IGOP3D(GFNO, FILNAM)  (DAS)
C $ OPEN 3-D GRID FILE, RETURN FILE-REF-NUMBER.  FN VAL IS 0 (OK), -1
C $   CAN'T OPEN, E.G., NO SUCH FILE OR NOT A GRID FILE).
C $ GFNO = (I) INPUT  GRID FILE NO.
C $ FILNAM = (I) OUTPUT  FILE NAME OF THE SPECIFIED GRID FILE (8-CHARS)
C $$ IGOP3D = GRID
C
      IMPLICIT INTEGER (A-Z)
      CHARACTER*8 FILNAM
      DATA MAXGF/9999/
C
      IF (GFNO.LT.1.OR.GFNO.GT.MAXGF) GOTO 92
         CALL IGNM3D(GFNO,FILNAM)
         IF (LWI(FILNAM,0,1,I) .LT. 0) GOTO 92
         IGOP3D=0
         RETURN
 92   CONTINUE
      IGOP3D=-1
      RETURN
      END
C
C
C
C
      SUBROUTINE IGMP3D
C $ SUBROUTINE IGMP3D  (DAS)
C $ CLOSE ALL OPEN GRID FILES.  ALWAYS CALL AFTER ANY GRID PROCESSING.
C $$ IGMP3D = GRID
      IMPLICIT INTEGER (A-Z)
C
      CALL LWMOP
      RETURN
      END
C
C
C

      FUNCTION IGGT3D(GFNO,GNO,MAXWDS,GRID,NR,NC,NL,TABLE)
C $ FUNCTION IGGT3D(GFNO, GNO, MAXWDS, GRID, NR, NC, NL, TABLE)  (DAS)
C $ GET A 3-D GRID FROM A GRID FILE.  FN VAL IS 0 (OK), -1 (NO SUCH GRID
C $   OR TOO BIG), OR -2 (NO SUCH FILE).
C $ INPUT:
C $   GFNO = (I) GRID FILE NO
C $   GNO = (I) GRID NO. WITHIN GRID FILE
C $   MAXWDS = (I) MAX SIZE OF GRID ALLOWED TO READ
C $   GRID = (R*4) ARRAY TO CONTAIN GRID
C $ OUTPUT:
C $   NR = (I) RETURNED AS NUMBER OF ROWS IN GRID
C $   NC = (I) RETURNED AS NUMBER OF COLUMNS IN GRID
C $   NL = (I) RETURNED AS NUMBER OF LEVELS IN GRID
C $   TABLE = (I) 64-WORD ARRAY TO RECEIVE GRID HEADER
C $$ IGGT3D = GRID
C
C-----IGGT3D OPENS THE GRID FILE AS NECESSARY
C
C
      IMPLICIT INTEGER (A-Z)
      DIMENSION GRID(*),TABLE(64)
      INTEGER HEAD(64)
      CHARACTER*8 FILNAM
      DATA HEDSIZ/64/,LASNO/-999/
      INTEGER*4 MAXGRD
C
C
c      IF(GFNO.NE.LASNO) THEN
         IF (IGOP3D(GFNO,FILNAM).NE.0) GOTO 92
         I=LWI(FILNAM,0,64,HEAD)
         MAXGRD=HEAD(12)
         LASNO=GFNO
c      ENDIF
      IF (GNO.LT.1.OR.GNO.GT.MAXGRD) GOTO 91
      I=LWI(FILNAM,GNO*HEDSIZ,HEDSIZ,TABLE)

C     This call swaps the order of the 4 characters if we're on a DEC:
      call swapchar( TABLE(9) )

      SIZE=TABLE(1)
      NR=TABLE(2)
      NC=TABLE(3)
      NL=TABLE(4)
      IWORD=TABLE(5)
      IF (SIZE.LT.1.OR.SIZE.GT.MAXWDS) GOTO 91
      IF (NR.LT.1) GOTO 91
      I=LWI(FILNAM,IWORD,SIZE,GRID)
      IGGT3D=0
      RETURN
 91   IGGT3D=-1
      GOTO 95
 92   IGGT3D=-2
 95   NR=0
      NC=0
      NL=0
      RETURN
      END
C
C
C
C
      FUNCTION IGPT3D(GFNO,IGNO,GRID,NR,NC,NL,TABLE,GNO)
C $ FUNCTION IGPT3D(GFNO, IGNO, GRID, NR, NC, NL, TABLE, GNO)  (DAS)
C $ PUT A 3-D GRID INTO A GRID FILE.  FN VAL IS 0 (OK), -1 (NO ROOM),
C $  OR  -2 (NO SUCH GRID FILE).
C $ INPUT:
C $   GFNO = (I) GRID FILE NO.
C $   IGNO = (I) IF .GE. 0, GRID IS WRITTEN IN NEXT EMPTY SLOT AFTER
C $      IGNO. IF -, GRID IS WRITTEN IN ABS(IGNO), OVERWRITING ANY GRID
C $      THAT IS THERE.
C $   GRID = (R*4) THE GRID ARRAY
C $   NR, NC,NL = (I) NOS. OF ROWS, COLUMNS, LEVELS IN 3-D GRID.
C $   TABLE = (I) 64-WORD GRID HEADER. CALLER MUST SET IT UP, EXCEPT
C $      THAT IGPT3D STUFFS IN THE NR,NC,NL  FIELDS.
C $ OUTPUT:
C $   GNO = (I) RETURNED AS ACTUAL GRID NUMBER STORED
C $$ IGPT3D = GRID
C
C
      IMPLICIT INTEGER (A-Z)
      DIMENSION GRID(*),TABLE(64)
      INTEGER HEAD(64)
      CHARACTER*8 FILNAM
      DATA HEDSIZ/64/
C
C
      IF (IGOP3D(GFNO,FILNAM).LT.0) GOTO 92
      I=LWI(FILNAM,0,HEDSIZ,HEAD)
      MAXGRD=HEAD(12)
      MAXSIZ=HEAD(11)
      IF (IGNO.LT.-MAXGRD.OR.IGNO.GT.MAXGRD) GOTO 91
      SIZE=NR*NC*NL
      IF (SIZE.GT.MAXSIZ) GOTO 91
      TABLE(4)=NL
      TABLE(3)=NC
      TABLE(2)=NR
      TABLE(1)=SIZE
      GNO=IABS(IGNO)
      IF (IGNO.LT.0) GOTO 4
         JBEGN=MIN0(MAX0(GNO,1),MAXGRD)
         DO 3 J=JBEGN,MAXGRD
            I=LWI(FILNAM,HEDSIZ*J,1,EXIST)
            IF (EXIST.LE.0) THEN
               GNO=J
               GO TO 4
            ENDIF
 3       CONTINUE
         GOTO 91
 4    CONTINUE
      IWORD=HEAD(13)+HEAD(11)*(GNO-1)
      TABLE(5)=IWORD
      CALL LWO(FILNAM,HEDSIZ*GNO,HEDSIZ,TABLE)
      CALL LWO(FILNAM,IWORD,SIZE,GRID)
C-----SUCCESS
      IGPT3D=0
      RETURN
C-----BAD GRID NO., ETC.
 91   IGPT3D=-1
      GNO=-1
      RETURN
C-----NO SUCH GRID FILE
 92   IGPT3D=-2
      GNO=-2
      RETURN
      END
C
C
C
C
      FUNCTION IGCF3D(N)
C $ FUNCTION IGCF3D(N)  (DAS)
C $ SET CURRENT 3-D GRID FILE; RETURN NUMBER TO CALLER
C $ N = (I) INPUT  # OF GRID FILE TO MAKE CURRENT GRID FILE.  IF N < 1
C $   OR > 9999 CURRENT GRID FILE NOT ALTERED.
C $$ IGCF3D = GRID
      IMPLICIT INTEGER(A-Z)
      DATA MAXGF/9999/
C
      IF (N.GE.1.AND.N.LE.MAXGF) CALL PUC(N,7)
      IGCF3D=MIN0(MAX0(LUC(7),1),MAXGF)
      RETURN
      END
