/*  ReferenceStation  Implementation for regular tide station.
    Last modified 1998-03-06

    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "common.hh"

ReferenceStation::ReferenceStation (TideContext *in_tidecontext,
ConstantSetWrapper *in_constants): Station (in_tidecontext) {
  assert (in_constants);
  constants = in_constants;
}

ReferenceStation::~ReferenceStation() {
  if (constants)
    delete constants;
  if (markLevel)
    delete markLevel;
}

// tm is "uncorrected" or "internal" timestamp
// t_out is "corrected" timestamp (with offsets applied)
// For reference station or simple offsets, they are identical.
// pv_out is undefined if the event is a sun or moon event.
void ReferenceStation::predictExactTideEvent (Timestamp &tm, Direction d,
Timestamp &t_out, EventType &etype_out, Dstr &etype_desc,
PredictionValue &pv_out) {
  _predictExactTideEvent (tm, d, etype_out);
  t_out = tm;
  if (!isSunMoonEvent (etype_out))
    pv_out = Station::predictApproximate (tm);
  etypedesc (etype_out, pv_out, etype_desc);
}

int ReferenceStation::is_reference_station() {
  return 1;
}
